/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.List;
import javax.annotation.Nullable;

final class PolymerBehaviorExtractor {
    private static final ImmutableSet<String> BEHAVIOR_NAMES_NOT_TO_COPY = ImmutableSet.of((Object)"created", (Object)"attached", (Object)"detached", (Object)"attributeChanged", (Object)"configure", (Object)"ready", (Object[])new String[]{"properties", "listeners", "observers", "hostAttributes"});
    private final AbstractCompiler compiler;
    private final GlobalNamespace globalNames;

    PolymerBehaviorExtractor(AbstractCompiler compiler, GlobalNamespace globalNames) {
        this.compiler = compiler;
        this.globalNames = globalNames;
    }

    ImmutableList<BehaviorDefinition> extractBehaviors(Node behaviorArray) {
        if (behaviorArray == null) {
            return ImmutableList.of();
        }
        if (!behaviorArray.isArrayLit()) {
            this.compiler.report(JSError.make(behaviorArray, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR_ARRAY, new String[0]));
            return ImmutableList.of();
        }
        ImmutableList.Builder behaviors = ImmutableList.builder();
        for (Node behaviorName : behaviorArray.children()) {
            if (behaviorName.isObjectLit()) {
                PolymerPassStaticUtils.switchDollarSignPropsToBrackets(behaviorName, this.compiler);
                PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(behaviorName, this.compiler);
                if (NodeUtil.getFirstPropMatchingKey(behaviorName, "is") != null) {
                    this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR, new String[0]));
                }
                behaviors.add((Object)new BehaviorDefinition((List<PolymerPass.MemberDefinition>)PolymerPassStaticUtils.extractProperties(behaviorName, PolymerClassDefinition.DefinitionType.ObjectLiteral, this.compiler), (List<PolymerPass.MemberDefinition>)PolymerBehaviorExtractor.getBehaviorFunctionsToCopy(behaviorName), (List<PolymerPass.MemberDefinition>)PolymerBehaviorExtractor.getNonPropertyMembersToCopy(behaviorName), !NodeUtil.isInFunction(behaviorName), (FeatureSet)NodeUtil.getEnclosingScript(behaviorName).getProp((byte)89)));
                continue;
            }
            ResolveBehaviorNameResult resolveResult = this.resolveBehaviorName(behaviorName);
            if (resolveResult == null) {
                this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            Node behaviorValue = resolveResult.node;
            if (behaviorValue.isArrayLit()) {
                behaviors.addAll(this.extractBehaviors(behaviorValue));
                continue;
            }
            if (behaviorValue.isObjectLit()) {
                PolymerPassStaticUtils.switchDollarSignPropsToBrackets(behaviorValue, this.compiler);
                PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(behaviorValue, this.compiler);
                if (NodeUtil.getFirstPropMatchingKey(behaviorValue, "is") != null) {
                    this.compiler.report(JSError.make(behaviorValue, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR, new String[0]));
                }
                behaviors.add((Object)new BehaviorDefinition((List<PolymerPass.MemberDefinition>)PolymerPassStaticUtils.extractProperties(behaviorValue, PolymerClassDefinition.DefinitionType.ObjectLiteral, this.compiler), (List<PolymerPass.MemberDefinition>)PolymerBehaviorExtractor.getBehaviorFunctionsToCopy(behaviorValue), (List<PolymerPass.MemberDefinition>)PolymerBehaviorExtractor.getNonPropertyMembersToCopy(behaviorValue), resolveResult.isGlobalDeclaration, (FeatureSet)NodeUtil.getEnclosingScript(behaviorValue).getProp((byte)89)));
                continue;
            }
            this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
        }
        return behaviors.build();
    }

    @Nullable
    private ResolveBehaviorNameResult resolveBehaviorName(Node nameNode) {
        String name = PolymerBehaviorExtractor.getQualifiedNameThroughCast(nameNode);
        if (name == null) {
            return null;
        }
        GlobalNamespace.Name globalName = this.globalNames.getSlot(name);
        if (globalName == null) {
            return null;
        }
        boolean isGlobalDeclaration = true;
        GlobalNamespace.Ref declarationRef = globalName.getDeclaration();
        if (declarationRef == null) {
            List<GlobalNamespace.Ref> behaviorRefs = globalName.getRefs();
            for (GlobalNamespace.Ref ref : behaviorRefs) {
                if (!ref.isSet()) continue;
                isGlobalDeclaration = false;
                declarationRef = ref;
                break;
            }
        }
        if (declarationRef == null) {
            return null;
        }
        Node declarationNode = declarationRef.getNode();
        if (declarationNode == null) {
            return null;
        }
        Node rValue = NodeUtil.getRValueOfLValue(declarationNode);
        if (rValue == null) {
            return null;
        }
        if (rValue.isQualifiedName()) {
            return this.resolveBehaviorName(rValue);
        }
        JSDocInfo behaviorInfo = NodeUtil.getBestJSDocInfo(declarationNode);
        if (behaviorInfo == null || !behaviorInfo.isPolymerBehavior()) {
            this.compiler.report(JSError.make(declarationNode, PolymerPassErrors.POLYMER_UNANNOTATED_BEHAVIOR, new String[0]));
        }
        return new ResolveBehaviorNameResult(rValue, isGlobalDeclaration);
    }

    private static ImmutableList<PolymerPass.MemberDefinition> getBehaviorFunctionsToCopy(Node behaviorObjLit) {
        Preconditions.checkState((boolean)behaviorObjLit.isObjectLit());
        ImmutableList.Builder functionsToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            boolean isFunctionDefinition = keyNode.isStringKey() && keyNode.getFirstChild().isFunction() || keyNode.isMemberFunctionDef();
            if (!isFunctionDefinition || BEHAVIOR_NAMES_NOT_TO_COPY.contains((Object)keyNode.getString())) continue;
            functionsToCopy.add((Object)new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return functionsToCopy.build();
    }

    @Nullable
    private static String getQualifiedNameThroughCast(Node node) {
        if (node.isName()) {
            String name = node.getString();
            return name.isEmpty() ? null : name;
        }
        if (node.isGetProp()) {
            String left = PolymerBehaviorExtractor.getQualifiedNameThroughCast(node.getFirstChild());
            if (left == null) {
                return null;
            }
            String right = node.getLastChild().getString();
            return left + "." + right;
        }
        if (node.isCast()) {
            return PolymerBehaviorExtractor.getQualifiedNameThroughCast(node.getFirstChild());
        }
        return null;
    }

    private static ImmutableList<PolymerPass.MemberDefinition> getNonPropertyMembersToCopy(Node behaviorObjLit) {
        Preconditions.checkState((boolean)behaviorObjLit.isObjectLit());
        ImmutableList.Builder membersToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            boolean isNonFunctionMember = keyNode.isGetterDef() || keyNode.isStringKey() && !keyNode.getFirstChild().isFunction();
            if (!isNonFunctionMember || BEHAVIOR_NAMES_NOT_TO_COPY.contains((Object)keyNode.getString())) continue;
            membersToCopy.add((Object)new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return membersToCopy.build();
    }

    static final class BehaviorDefinition {
        final List<PolymerPass.MemberDefinition> props;
        final List<PolymerPass.MemberDefinition> functionsToCopy;
        final List<PolymerPass.MemberDefinition> nonPropertyMembersToCopy;
        final boolean isGlobalDeclaration;
        final FeatureSet features;

        BehaviorDefinition(List<PolymerPass.MemberDefinition> props, List<PolymerPass.MemberDefinition> functionsToCopy, List<PolymerPass.MemberDefinition> nonPropertyMembersToCopy, boolean isGlobalDeclaration, FeatureSet features) {
            this.props = props;
            this.functionsToCopy = functionsToCopy;
            this.nonPropertyMembersToCopy = nonPropertyMembersToCopy;
            this.isGlobalDeclaration = isGlobalDeclaration;
            this.features = features;
        }
    }

    private static class ResolveBehaviorNameResult {
        final Node node;
        final boolean isGlobalDeclaration;

        public ResolveBehaviorNameResult(Node node, boolean isGlobalDeclaration) {
            this.node = node;
            this.isGlobalDeclaration = isGlobalDeclaration;
        }
    }
}

