/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class PolymerClassRewriter {
    private static final String VIRTUAL_FILE = "<PolymerClassRewriter.java>";
    private final AbstractCompiler compiler;
    private final int polymerVersion;
    private final boolean propertyRenamingEnabled;
    @VisibleForTesting
    static final String POLYMER_ELEMENT_PROP_CONFIG = "PolymerElementProperties";
    private final Node polymerElementExterns;

    PolymerClassRewriter(AbstractCompiler compiler, Node polymerElementExterns, int polymerVersion, boolean propertyRenamingEnabled) {
        this.compiler = compiler;
        this.polymerElementExterns = polymerElementExterns;
        this.polymerVersion = polymerVersion;
        this.propertyRenamingEnabled = propertyRenamingEnabled;
    }

    void rewritePolymerCall(Node exprRoot, PolymerClassDefinition cls, boolean isInGlobalScope) {
        Node props;
        FeatureSet oldFeatures;
        FeatureSet newFeatures;
        Node scriptNode;
        Node objLit = (Node)Preconditions.checkNotNull((Object)cls.descriptor);
        JSDocInfoBuilder objLitDoc = new JSDocInfoBuilder(true);
        objLitDoc.recordLends(cls.target.getQualifiedName() + ".prototype");
        objLit.setJSDocInfo(objLitDoc.build());
        this.addTypesToFunctions(objLit, cls.target.getQualifiedName(), cls.defType);
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(objLit, this.compiler);
        PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(objLit, this.compiler);
        for (PolymerPass.MemberDefinition prop : cls.props) {
            if (!prop.value.isObjectLit()) continue;
            PolymerPassStaticUtils.switchDollarSignPropsToBrackets(prop.value, this.compiler);
        }
        Node block = IR.block();
        JSDocInfoBuilder constructorDoc = this.getConstructorDoc(cls);
        Node ctorKey = cls.constructor.value.getParent();
        if (ctorKey != null) {
            ctorKey.removeProp((byte)29);
        }
        if (cls.target.isGetProp()) {
            Node assign = IR.assign(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            NodeUtil.markNewScopesChanged(assign, this.compiler);
            assign.setJSDocInfo(constructorDoc.build());
            Node exprResult = IR.exprResult(assign);
            exprResult.useSourceInfoIfMissingFromForTree(cls.target);
            block.addChildToBack(exprResult);
        } else {
            Node var = IR.var(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            NodeUtil.markNewScopesChanged(var, this.compiler);
            var.useSourceInfoIfMissingFromForTree(exprRoot);
            var.setJSDocInfo(constructorDoc.build());
            block.addChildToBack(var);
        }
        this.appendPropertiesToBlock(cls, block, cls.target.getQualifiedName() + ".prototype.");
        this.appendBehaviorMembersToBlock(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> attributeReflectedProps = this.parseAttributeReflectedProperties(cls);
        this.addInterfaceExterns(cls, (List<PolymerPass.MemberDefinition>)readOnlyProps, (List<PolymerPass.MemberDefinition>)attributeReflectedProps);
        this.removePropertyDocs(objLit, PolymerClassDefinition.DefinitionType.ObjectLiteral);
        Node statements = block.removeChildren();
        Node parent = exprRoot.getParent();
        if (!isInGlobalScope && !cls.target.isGetProp()) {
            scriptNode = NodeUtil.getEnclosingScript(parent);
            scriptNode.addChildrenToFront(statements);
            this.compiler.reportChangeToChangeScope(scriptNode);
        } else {
            Node beforeRoot = exprRoot.getPrevious();
            if (beforeRoot == null) {
                parent.addChildrenToFront(statements);
            } else {
                parent.addChildrenAfter(statements, beforeRoot);
            }
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        this.compiler.reportChangeToEnclosingScope(statements);
        if (cls.features != null && !(newFeatures = (oldFeatures = (FeatureSet)(scriptNode = NodeUtil.getEnclosingScript(parent)).getProp((byte)89)).union(cls.features)).equals(oldFeatures)) {
            scriptNode.putProp((byte)89, newFeatures);
            this.compiler.reportChangeToChangeScope(scriptNode);
        }
        if (NodeUtil.isNameDeclaration(exprRoot)) {
            Node assignExpr = PolymerClassRewriter.varToAssign(exprRoot);
            parent.replaceChild(exprRoot, assignExpr);
            this.compiler.reportChangeToEnclosingScope(assignExpr);
        }
        if (this.polymerVersion > 1 && this.propertyRenamingEnabled && cls.descriptor != null && (props = NodeUtil.getFirstPropMatchingKey(cls.descriptor, "properties")) != null && props.isObjectLit()) {
            this.addObjectReflectionCall(cls, props);
        }
    }

    void rewritePolymerClassDeclaration(Node clazz, PolymerClassDefinition cls, boolean isInGlobalScope) {
        if (cls.descriptor != null) {
            this.addTypesToFunctions(cls.descriptor, cls.target.getQualifiedName(), cls.defType);
        }
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(NodeUtil.getClassMembers(clazz), this.compiler);
        for (PolymerPass.MemberDefinition prop : cls.props) {
            if (!prop.value.isObjectLit()) continue;
            PolymerPassStaticUtils.switchDollarSignPropsToBrackets(prop.value, this.compiler);
        }
        Node block = IR.block();
        this.appendPropertiesToBlock(cls, block, cls.target.getQualifiedName() + ".prototype.");
        ImmutableList<PolymerPass.MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> attributeReflectedProps = this.parseAttributeReflectedProperties(cls);
        this.addInterfaceExterns(cls, (List<PolymerPass.MemberDefinition>)readOnlyProps, (List<PolymerPass.MemberDefinition>)attributeReflectedProps);
        if (!readOnlyProps.isEmpty() || !attributeReflectedProps.isEmpty()) {
            Node jsDocInfoNode = NodeUtil.getBestJSDocInfoNode(clazz);
            JSDocInfoBuilder classInfo = JSDocInfoBuilder.maybeCopyFrom(jsDocInfoNode.getJSDocInfo());
            String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
            JSTypeExpression interfaceType = new JSTypeExpression(new Node(Token.BANG, IR.string(interfaceName)), VIRTUAL_FILE);
            classInfo.recordImplementedInterface(interfaceType);
            jsDocInfoNode.setJSDocInfo(classInfo.build());
        }
        if (block.hasChildren()) {
            this.removePropertyDocs(cls.descriptor, cls.defType);
            Node stmt = NodeUtil.getEnclosingStatement(clazz);
            stmt.getParent().addChildrenAfter(block.removeChildren(), stmt);
            this.compiler.reportChangeToEnclosingScope(stmt);
        }
        this.addReturnTypeIfMissing(cls, "is", new JSTypeExpression(IR.string("string"), VIRTUAL_FILE));
        Node type = new Node(Token.BANG);
        Node array = IR.string("Array");
        type.addChildToBack(array);
        Node arrayTemplateType = new Node(Token.BLOCK, IR.string("string"));
        array.addChildToBack(arrayTemplateType);
        this.addReturnTypeIfMissing(cls, "observers", new JSTypeExpression(type, VIRTUAL_FILE));
        this.addReturnTypeIfMissing(cls, "properties", new JSTypeExpression(IR.string(POLYMER_ELEMENT_PROP_CONFIG), VIRTUAL_FILE));
        if (this.propertyRenamingEnabled && cls.descriptor != null) {
            this.addObjectReflectionCall(cls, cls.descriptor);
        }
    }

    private void addReturnTypeIfMissing(PolymerClassDefinition cls, String getterPropName, JSTypeExpression jsType) {
        JSDocInfo info;
        Node classMembers = NodeUtil.getClassMembers(cls.definition);
        Node getter = NodeUtil.getFirstGetterMatchingKey(classMembers, getterPropName);
        if (!(getter == null || (info = NodeUtil.getBestJSDocInfo(getter)) != null && info.hasReturnType())) {
            JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
            builder.recordReturnType(jsType);
            getter.setJSDocInfo(builder.build());
        }
    }

    private void addObjectReflectionCall(PolymerClassDefinition cls, Node propertiesLiteral) {
        Preconditions.checkNotNull((Object)propertiesLiteral);
        Preconditions.checkState((boolean)propertiesLiteral.isObjectLit());
        Node parent = propertiesLiteral.getParent();
        Node objReflectCall = IR.call(NodeUtil.newQName(this.compiler, "$jscomp.reflectObject"), cls.target.cloneTree(), propertiesLiteral.detach()).useSourceInfoIfMissingFromForTree(propertiesLiteral);
        parent.addChildToFront(objReflectCall);
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private void addTypesToFunctions(Node objLit, String thisType, PolymerClassDefinition.DefinitionType defType) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getLastChild();
            if (value == null || !value.isFunction()) continue;
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(keyNode.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(thisType)), VIRTUAL_FILE));
            keyNode.setJSDocInfo(fnDoc.build());
        }
        for (PolymerPass.MemberDefinition property : PolymerPassStaticUtils.extractProperties(objLit, defType, this.compiler)) {
            Node defaultValue;
            if (!property.value.isObjectLit() || (defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value")) == null || !defaultValue.isFunction()) continue;
            Node defaultValueKey = defaultValue.getParent();
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(thisType)), VIRTUAL_FILE));
            fnDoc.recordReturnType(PolymerPassStaticUtils.getTypeFromProperty(property, this.compiler));
            defaultValueKey.setJSDocInfo(fnDoc.build());
        }
    }

    private ImmutableList<PolymerPass.MemberDefinition> parseReadOnlyProperties(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        ImmutableList.Builder readOnlyProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node readOnlyValue;
            if (!prop.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(prop.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
            Node setter = this.makeReadOnlySetter(prop.name.getString(), qualifiedPath);
            setter.useSourceInfoIfMissingFromForTree(prop.name);
            block.addChildToBack(setter);
            readOnlyProps.add((Object)prop);
        }
        return readOnlyProps.build();
    }

    private ImmutableList<PolymerPass.MemberDefinition> parseAttributeReflectedProperties(PolymerClassDefinition cls) {
        ImmutableList.Builder attrReflectedProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node reflectedValue;
            if (!prop.value.isObjectLit() || (reflectedValue = NodeUtil.getFirstPropMatchingKey(prop.value, "reflectToAttribute")) == null || !reflectedValue.isTrue()) continue;
            attrReflectedProps.add((Object)prop);
        }
        return attrReflectedProps.build();
    }

    private JSDocInfoBuilder getConstructorDoc(PolymerClassDefinition cls) {
        JSDocInfoBuilder constructorDoc = JSDocInfoBuilder.maybeCopyFrom(cls.constructor.info);
        constructorDoc.recordConstructor();
        JSTypeExpression baseType = new JSTypeExpression(new Node(Token.BANG, IR.string(PolymerPassStaticUtils.getPolymerElementType(cls))), VIRTUAL_FILE);
        constructorDoc.recordBaseType(baseType);
        String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
        JSTypeExpression interfaceType = new JSTypeExpression(new Node(Token.BANG, IR.string(interfaceName)), VIRTUAL_FILE);
        constructorDoc.recordImplementedInterface(interfaceType);
        return constructorDoc;
    }

    private void appendPropertiesToBlock(PolymerClassDefinition cls, Node block, String basePath) {
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node propertyNode = IR.exprResult(NodeUtil.newQName(this.compiler, basePath + prop.name.getString()));
            if (prop.name.isQuotedString()) continue;
            propertyNode.useSourceInfoIfMissingFromForTree(prop.name);
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(prop.info);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            if (propType == null) {
                return;
            }
            info.recordType(propType);
            propertyNode.getFirstChild().setJSDocInfo(info.build());
            block.addChildToBack(propertyNode);
        }
    }

    private void removePropertyDocs(Node objLit, PolymerClassDefinition.DefinitionType defType) {
        for (PolymerPass.MemberDefinition prop : PolymerPassStaticUtils.extractProperties(objLit, defType, this.compiler)) {
            prop.name.removeProp((byte)29);
        }
    }

    private void appendBehaviorMembersToBlock(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        HashMap<String, Node> nameToExprResult = new HashMap<String, Node>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : cls.behaviors) {
            for (PolymerPass.MemberDefinition behaviorFunction : behavior.functionsToCopy) {
                String fnName = behaviorFunction.name.getString();
                if (NodeUtil.getFirstPropMatchingKey(cls.descriptor, fnName) != null) continue;
                if (nameToExprResult.containsKey(fnName)) {
                    block.removeChild((Node)nameToExprResult.get(fnName));
                }
                Node fnValue = behaviorFunction.value.cloneTree();
                NodeUtil.markNewScopesChanged(fnValue, this.compiler);
                Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + fnName), fnValue));
                exprResult.useSourceInfoIfMissingFromForTree(behaviorFunction.name);
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunction.info);
                info.addSuppression("unusedPrivateMembers");
                if (behaviorFunction.info != null && behaviorFunction.info.getVisibility() == JSDocInfo.Visibility.PROTECTED) {
                    info.overwriteVisibility(JSDocInfo.Visibility.PUBLIC);
                }
                if (!behavior.isGlobalDeclaration) {
                    NodeUtil.getFunctionBody(fnValue).removeChildren();
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(fnName, exprResult);
            }
            for (PolymerPass.MemberDefinition behaviorProp : behavior.nonPropertyMembersToCopy) {
                String propName = behaviorProp.name.getString();
                if (nameToExprResult.containsKey(propName)) {
                    block.removeChild((Node)nameToExprResult.get(propName));
                }
                Node exprResult = IR.exprResult(NodeUtil.newQName(this.compiler, qualifiedPath + propName));
                exprResult.useSourceInfoFromForTree(behaviorProp.name);
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorProp.info);
                if (behaviorProp.name.isGetterDef()) {
                    info = new JSDocInfoBuilder(true);
                    if (behaviorProp.info != null && behaviorProp.info.getReturnType() != null) {
                        info.recordType(behaviorProp.info.getReturnType());
                    }
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(propName, exprResult);
            }
        }
    }

    private Node makeReadOnlySetter(String propName, String qualifiedPath) {
        String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        Node fnNode = IR.function(IR.name(""), IR.paramList(IR.name(propName)), IR.block());
        this.compiler.reportChangeToChangeScope(fnNode);
        Node exprResNode = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + setterName), fnNode));
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordOverride();
        exprResNode.getFirstChild().setJSDocInfo(info.build());
        return exprResNode;
    }

    private void addInterfaceExterns(PolymerClassDefinition cls, List<PolymerPass.MemberDefinition> readOnlyProps, List<PolymerPass.MemberDefinition> attributeReflectedProps) {
        Node block = IR.block();
        String interfaceName = PolymerClassRewriter.getInterfaceName(cls);
        Node fnNode = NodeUtil.emptyFunction();
        this.compiler.reportChangeToChangeScope(fnNode);
        Node varNode = IR.var(NodeUtil.newQName(this.compiler, interfaceName), fnNode);
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordInterface();
        varNode.setJSDocInfo(info.build());
        block.addChildToBack(varNode);
        if (this.polymerVersion == 1) {
            this.appendPropertiesToBlock(cls, block, interfaceName + ".prototype.");
        } else {
            ArrayList<PolymerPass.MemberDefinition> interfaceProperties = new ArrayList<PolymerPass.MemberDefinition>();
            interfaceProperties.addAll(readOnlyProps);
            if (attributeReflectedProps != null) {
                interfaceProperties.addAll(attributeReflectedProps);
            }
            PolymerClassDefinition tmpDef = new PolymerClassDefinition(cls.defType, cls.definition, cls.target, cls.descriptor, null, null, null, (List<PolymerPass.MemberDefinition>)interfaceProperties, null, null);
            this.appendPropertiesToBlock(tmpDef, block, interfaceName + ".prototype.");
        }
        for (PolymerPass.MemberDefinition prop : readOnlyProps) {
            String propName = prop.name.getString();
            String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Node setterExprNode = IR.exprResult(NodeUtil.newQName(this.compiler, interfaceName + ".prototype." + setterName));
            JSDocInfoBuilder setterInfo = new JSDocInfoBuilder(true);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            setterInfo.recordParameter(propName, propType);
            setterExprNode.getFirstChild().setJSDocInfo(setterInfo.build());
            block.addChildToBack(setterExprNode);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node scopeRoot = this.polymerElementExterns;
        if (!scopeRoot.isScript()) {
            scopeRoot = scopeRoot.getParent();
        }
        Node stmts = block.removeChildren();
        scopeRoot.addChildrenToBack(stmts);
        this.compiler.reportChangeToEnclosingScope(stmts);
    }

    private static String getInterfaceName(PolymerClassDefinition cls) {
        return "Polymer" + cls.target.getQualifiedName().replace('.', '_') + "Interface";
    }

    private static Node varToAssign(Node var) {
        Node assign = IR.assign(var.getFirstChild().cloneNode(), var.getFirstChild().removeFirstChild());
        return IR.exprResult(assign).useSourceInfoIfMissingFromForTree(var);
    }
}

