/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Iterator;
import javax.annotation.Nullable;

@GwtIncompatible(value="JsMessage")
final class ReplaceMessages
extends JsMessageVisitor {
    private final MessageBundle bundle;
    private final boolean strictReplacement;
    static final DiagnosticType BUNDLE_DOES_NOT_HAVE_THE_MESSAGE = DiagnosticType.error("JSC_BUNDLE_DOES_NOT_HAVE_THE_MESSAGE", "Message with id = {0} could not be found in replacement bundle");

    ReplaceMessages(AbstractCompiler compiler, MessageBundle bundle, boolean checkDuplicatedMessages, JsMessage.Style style, boolean strictReplacement) {
        super(compiler, checkDuplicatedMessages, style, bundle.idGenerator());
        this.bundle = bundle;
        this.strictReplacement = strictReplacement;
    }

    @Override
    void processMessageFallback(Node callNode, JsMessage message1, JsMessage message2) {
        boolean isFirstMessageTranslated = this.bundle.getMessage(message1.getId()) != null;
        boolean isSecondMessageTranslated = this.bundle.getMessage(message2.getId()) != null;
        Node replacementNode = isSecondMessageTranslated && !isFirstMessageTranslated ? callNode.getChildAtIndex(2) : callNode.getSecondChild();
        callNode.replaceWith(replacementNode.detach());
        Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(replacementNode);
        if (changeScope != null) {
            this.compiler.reportChangeToChangeScope(changeScope);
        }
    }

    @Override
    protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
        Node newValue;
        JsMessage replacement = this.bundle.getMessage(message.getId());
        if (replacement == null) {
            if (this.strictReplacement) {
                this.compiler.report(JSError.make(definition.getMessageNode(), BUNDLE_DOES_NOT_HAVE_THE_MESSAGE, message.getId()));
                return;
            }
            replacement = message;
        }
        Node msgNode = definition.getMessageNode();
        try {
            newValue = this.getNewValueNode(replacement, msgNode);
        }
        catch (JsMessageVisitor.MalformedException e) {
            this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
            newValue = msgNode;
        }
        if (newValue != msgNode) {
            newValue.useSourceInfoIfMissingFromForTree(msgNode);
            msgNode.replaceWith(newValue);
            this.compiler.reportChangeToEnclosingScope(newValue);
        }
    }

    private Node getNewValueNode(JsMessage message, Node origValueNode) throws JsMessageVisitor.MalformedException {
        switch (origValueNode.getToken()) {
            case FUNCTION: {
                this.updateFunctionNode(message, origValueNode);
                return origValueNode;
            }
            case STRING: {
                String newString = message.toString();
                if (!origValueNode.getString().equals(newString)) {
                    origValueNode.setString(newString);
                    this.compiler.reportChangeToEnclosingScope(origValueNode);
                }
                return origValueNode;
            }
            case ADD: {
                return IR.string(message.toString());
            }
            case CALL: {
                return this.replaceCallNode(message, origValueNode);
            }
        }
        throw new JsMessageVisitor.MalformedException("Expected FUNCTION, STRING, or ADD node; found: " + (Object)((Object)origValueNode.getToken()), origValueNode);
    }

    private void updateFunctionNode(JsMessage message, Node functionNode) throws JsMessageVisitor.MalformedException {
        this.checkNode(functionNode, Token.FUNCTION);
        Node nameNode = functionNode.getFirstChild();
        this.checkNode(nameNode, Token.NAME);
        Node argListNode = nameNode.getNext();
        this.checkNode(argListNode, Token.PARAM_LIST);
        Node oldBlockNode = argListNode.getNext();
        this.checkNode(oldBlockNode, Token.BLOCK);
        Iterator<CharSequence> iterator = message.parts().iterator();
        Node valueNode = iterator.hasNext() ? ReplaceMessages.constructAddOrStringNode(iterator, argListNode) : IR.string("");
        Node newBlockNode = IR.block(IR.returnNode(valueNode));
        if (newBlockNode.checkTreeEquals(oldBlockNode) != null) {
            newBlockNode.useSourceInfoIfMissingFromForTree(oldBlockNode);
            functionNode.replaceChild(oldBlockNode, newBlockNode);
            this.compiler.reportChangeToEnclosingScope(newBlockNode);
        }
    }

    private static Node constructAddOrStringNode(Iterator<CharSequence> partsIterator, Node argListNode) throws JsMessageVisitor.MalformedException {
        CharSequence part = partsIterator.next();
        Node partNode = null;
        if (part instanceof JsMessage.PlaceholderReference) {
            JsMessage.PlaceholderReference phRef = (JsMessage.PlaceholderReference)part;
            for (Node node : argListNode.children()) {
                String arg;
                if (!node.isName() || !(arg = node.getString()).equalsIgnoreCase(phRef.getName())) continue;
                partNode = IR.name(arg);
            }
            if (partNode == null) {
                throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + phRef.getName(), argListNode);
            }
        } else {
            partNode = IR.string(part.toString());
        }
        if (partsIterator.hasNext()) {
            return IR.add(partNode, ReplaceMessages.constructAddOrStringNode(partsIterator, argListNode));
        }
        return partNode;
    }

    private Node replaceCallNode(JsMessage message, Node callNode) throws JsMessageVisitor.MalformedException {
        this.checkNode(callNode, Token.CALL);
        Node getPropNode = callNode.getFirstChild();
        this.checkNode(getPropNode, Token.GETPROP);
        Node stringExprNode = getPropNode.getNext();
        ReplaceMessages.checkStringExprNode(stringExprNode);
        Node objLitNode = stringExprNode.getNext();
        Iterator<CharSequence> iterator = message.parts().iterator();
        return iterator.hasNext() ? ReplaceMessages.constructStringExprNode(iterator, objLitNode, callNode) : IR.string("");
    }

    private static Node constructStringExprNode(Iterator<CharSequence> parts, Node objLitNode, Node refNode) throws JsMessageVisitor.MalformedException {
        Preconditions.checkNotNull((Object)refNode);
        CharSequence part = parts.next();
        Node partNode = null;
        if (part instanceof JsMessage.PlaceholderReference) {
            JsMessage.PlaceholderReference phRef = (JsMessage.PlaceholderReference)part;
            if (objLitNode == null) {
                throw new JsMessageVisitor.MalformedException("Empty placeholder value map for a translated message with placeholders.", refNode);
            }
            for (Node key = objLitNode.getFirstChild(); key != null; key = key.getNext()) {
                if (!key.getString().equals(phRef.getName())) continue;
                Node valueNode = key.getFirstChild();
                partNode = valueNode.cloneTree();
            }
            if (partNode == null) {
                throw new JsMessageVisitor.MalformedException("Unrecognized message placeholder referenced: " + phRef.getName(), objLitNode);
            }
        } else {
            partNode = IR.string(part.toString());
        }
        if (parts.hasNext()) {
            return IR.add(partNode, ReplaceMessages.constructStringExprNode(parts, objLitNode, refNode));
        }
        return partNode;
    }

    private static void checkStringExprNode(@Nullable Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Expected a string; found: null");
        }
        switch (node.getToken()) {
            case STRING: 
            case TEMPLATELIT: {
                break;
            }
            case ADD: {
                Node c = node.getFirstChild();
                ReplaceMessages.checkStringExprNode(c);
                ReplaceMessages.checkStringExprNode(c.getNext());
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected a string; found: " + (Object)((Object)node.getToken()));
            }
        }
    }
}

