/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;

public final class RewriteAsyncIteration
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_GENERATORS, FeatureSet.Feature.FOR_AWAIT_OF);
    private final AbstractCompiler compiler;
    private final ArrayDeque<FunctionFlavor> functionFlavorStack;
    private static final String GENERATOR_WRAPPER_NAME = "$jscomp.AsyncGeneratorWrapper";
    private static final String ACTION_RECORD_NAME = "$jscomp.AsyncGeneratorWrapper$ActionRecord";
    private static final String ACTION_ENUM_AWAIT = "$jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE";
    private static final String ACTION_ENUM_YIELD = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE";
    private static final String ACTION_ENUM_YIELD_STAR = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR";
    private static final String FOR_AWAIT_ITERATOR_TEMP_NAME = "$jscomp$forAwait$tempIterator";
    private static final String FOR_AWAIT_RESULT_TEMP_NAME = "$jscomp$forAwait$tempResult";
    private int nextForAwaitId = 0;

    RewriteAsyncIteration(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functionFlavorStack = new ArrayDeque();
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState((boolean)this.functionFlavorStack.isEmpty());
        TranspilationPasses.processTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
        Preconditions.checkState((boolean)this.functionFlavorStack.isEmpty());
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.functionFlavorStack.isEmpty());
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
        Preconditions.checkState((boolean)this.functionFlavorStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.functionFlavorStack.push(FunctionFlavor.fromFunctionNode(n));
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.functionFlavorStack.peek() == FunctionFlavor.ASYNCHRONOUS_GENERATOR) {
            if (n.isAsyncGeneratorFunction()) {
                this.convertAsyncGenerator(n);
            } else if (n.isAwait()) {
                this.convertAwaitOfAsyncGenerator(n);
            } else if (n.isYield()) {
                this.convertYieldOfAsyncGenerator(n);
            }
        }
        if (n.isForAwaitOf()) {
            this.replaceForAwaitOf(n);
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
        if (n.isFunction()) {
            this.functionFlavorStack.pop();
        }
    }

    private void convertAsyncGenerator(Node originalFunction) {
        Preconditions.checkNotNull((Object)originalFunction);
        Preconditions.checkState((boolean)originalFunction.isAsyncGeneratorFunction());
        Node innerBlock = originalFunction.getLastChild();
        originalFunction.removeChild(innerBlock);
        Node innerFunction = IR.function(IR.name(""), IR.paramList(), innerBlock);
        innerFunction.setIsGeneratorFunction(true);
        Node outerBlock = IR.block(IR.returnNode(IR.newNode(NodeUtil.newQName(this.compiler, GENERATOR_WRAPPER_NAME), NodeUtil.newCallNode(innerFunction, new Node[0]))));
        originalFunction.addChildToBack(outerBlock);
        originalFunction.setIsAsyncFunction(false);
        originalFunction.setIsGeneratorFunction(false);
        originalFunction.useSourceInfoIfMissingFromForTree(originalFunction);
        this.compiler.reportChangeToChangeScope(originalFunction);
        this.compiler.reportChangeToChangeScope(innerFunction);
    }

    private void convertAwaitOfAsyncGenerator(Node awaitNode) {
        Preconditions.checkNotNull((Object)awaitNode);
        Preconditions.checkState((boolean)awaitNode.isAwait());
        Preconditions.checkState((this.functionFlavorStack.peek() == FunctionFlavor.ASYNCHRONOUS_GENERATOR ? 1 : 0) != 0);
        Node expression = awaitNode.removeFirstChild();
        Preconditions.checkNotNull((Object)expression, (Object)"await needs an expression");
        Node newActionRecord = IR.newNode(NodeUtil.newQName(this.compiler, ACTION_RECORD_NAME), NodeUtil.newQName(this.compiler, ACTION_ENUM_AWAIT), expression);
        newActionRecord.useSourceInfoIfMissingFromForTree(awaitNode);
        awaitNode.addChildToFront(newActionRecord);
        awaitNode.setToken(Token.YIELD);
    }

    private void convertYieldOfAsyncGenerator(Node yieldNode) {
        Preconditions.checkNotNull((Object)yieldNode);
        Preconditions.checkState((boolean)yieldNode.isYield());
        Preconditions.checkState((this.functionFlavorStack.peek() == FunctionFlavor.ASYNCHRONOUS_GENERATOR ? 1 : 0) != 0);
        Node expression = yieldNode.removeFirstChild();
        Node newActionRecord = IR.newNode(NodeUtil.newQName(this.compiler, ACTION_RECORD_NAME), new Node[0]);
        if (yieldNode.isYieldAll()) {
            Preconditions.checkNotNull((Object)expression);
            newActionRecord.addChildToBack(NodeUtil.newQName(this.compiler, ACTION_ENUM_YIELD_STAR));
            newActionRecord.addChildToBack(expression);
        } else {
            if (expression == null) {
                expression = NodeUtil.newUndefinedNode(null);
            }
            newActionRecord.addChildToBack(NodeUtil.newQName(this.compiler, ACTION_ENUM_YIELD));
            newActionRecord.addChildToBack(expression);
        }
        newActionRecord.useSourceInfoIfMissingFromForTree(yieldNode);
        yieldNode.addChildToFront(newActionRecord);
        yieldNode.removeProp((byte)62);
    }

    private void replaceForAwaitOf(Node forAwaitOf) {
        Node lhsAssignment;
        int forAwaitId = this.nextForAwaitId++;
        String iteratorTempName = FOR_AWAIT_ITERATOR_TEMP_NAME + forAwaitId;
        String resultTempName = FOR_AWAIT_RESULT_TEMP_NAME + forAwaitId;
        Preconditions.checkState((forAwaitOf.getParent() != null ? 1 : 0) != 0, (Object)"Cannot replace parentless for-await-of");
        Node lhs = forAwaitOf.removeFirstChild();
        Node rhs = forAwaitOf.removeFirstChild();
        Node originalBody = forAwaitOf.removeFirstChild();
        Node initializer = IR.constNode(IR.name(iteratorTempName), NodeUtil.newCallNode(NodeUtil.newQName(this.compiler, "$jscomp.makeAsyncIterator"), rhs)).useSourceInfoIfMissingFromForTree(rhs);
        Node resultDeclaration = IR.constNode(IR.name(resultTempName), this.constructAwaitNextResult(iteratorTempName));
        Node breakIfDone = IR.ifNode(IR.getprop(IR.name(resultTempName), "done", new String[0]), IR.block(IR.breakNode()));
        if (lhs.isValidAssignmentTarget()) {
            lhsAssignment = IR.exprResult(IR.assign(lhs, IR.getprop(IR.name(resultTempName), "value", new String[0])));
        } else if (NodeUtil.isNameDeclaration(lhs)) {
            lhs.getFirstChild().addChildToBack(IR.getprop(IR.name(resultTempName), "value", new String[0]));
            lhsAssignment = lhs;
        } else {
            throw new AssertionError((Object)"unexpected for-await-of lhs");
        }
        lhsAssignment.useSourceInfoIfMissingFromForTree(lhs);
        Node newForLoop = IR.forNode(initializer, IR.empty(), IR.empty(), IR.block(resultDeclaration, breakIfDone, lhsAssignment, this.ensureBlock(originalBody)));
        forAwaitOf.replaceWith(newForLoop);
        newForLoop.useSourceInfoIfMissingFromForTree(forAwaitOf);
        this.compiler.reportChangeToEnclosingScope(newForLoop);
    }

    private Node ensureBlock(Node possiblyBlock) {
        return possiblyBlock.isBlock() ? possiblyBlock : IR.block(possiblyBlock).useSourceInfoFrom(possiblyBlock);
    }

    private Node constructAwaitNextResult(String iteratorTempName) {
        if (this.functionFlavorStack.peek() != FunctionFlavor.ASYNCHRONOUS_GENERATOR) {
            return IR.await(NodeUtil.newCallNode(IR.getprop(IR.name(iteratorTempName), "next", new String[0]), new Node[0]));
        }
        return IR.yield(IR.newNode(NodeUtil.newQName(this.compiler, ACTION_RECORD_NAME), NodeUtil.newQName(this.compiler, ACTION_ENUM_AWAIT), NodeUtil.newCallNode(IR.getprop(IR.name(iteratorTempName), "next", new String[0]), new Node[0])));
    }

    private static enum FunctionFlavor {
        NORMAL(false, false),
        GENERATOR(true, false),
        ASYNCHRONOUS(false, true),
        ASYNCHRONOUS_GENERATOR(true, true);

        final boolean isGenerator;
        final boolean isAsynchronous;

        private FunctionFlavor(boolean isGenerator, boolean isAsynchronous) {
            this.isGenerator = isGenerator;
            this.isAsynchronous = isAsynchronous;
        }

        static FunctionFlavor fromFunctionNode(Node functionNode) {
            Preconditions.checkState((boolean)functionNode.isFunction(), (Object)functionNode);
            if (functionNode.isAsyncGeneratorFunction()) {
                return ASYNCHRONOUS_GENERATOR;
            }
            if (functionNode.isAsyncFunction()) {
                return ASYNCHRONOUS;
            }
            if (functionNode.isGeneratorFunction()) {
                return GENERATOR;
            }
            return NORMAL;
        }
    }
}

