/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;

public abstract class Scope
extends AbstractScope<Scope, Var> {
    Scope(Node rootNode) {
        super(rootNode);
    }

    @Override
    public Scope untyped() {
        return this;
    }

    static Scope createGlobalScope(Node rootNode) {
        return new Simple(rootNode);
    }

    static Scope createChildScope(Scope parent, Node rootNode) {
        return new Simple(parent, rootNode);
    }

    Var declare(String name, Node nameNode, CompilerInput input) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.getOwnSlot(name) == null ? 1 : 0) != 0);
        Var var = new Var(name, nameNode, this, this.getVarCount(), input);
        this.declareInternal(name, var);
        return var;
    }

    @Override
    Var makeImplicitVar(AbstractScope.ImplicitVar var) {
        return new Var(var.name, null, this, -1, null);
    }

    private static final class Simple
    extends Scope {
        final Scope parent;
        final int depth;

        Simple(Scope parent, Node rootNode) {
            super(rootNode);
            this.checkChildScope(parent);
            this.parent = parent;
            this.depth = parent.getDepth() + 1;
        }

        Simple(Node rootNode) {
            super(rootNode);
            this.checkRootScope();
            this.parent = null;
            this.depth = 0;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public Scope getParent() {
            return this.parent;
        }
    }
}

