/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public final class FeatureSet
implements Serializable {
    private final ImmutableSet<Feature> features;
    public static final FeatureSet BARE_MINIMUM = new FeatureSet(FeatureSet.emptyEnumSet());
    public static final FeatureSet ES3 = BARE_MINIMUM.with(LangVersion.access$000(LangVersion.ES3));
    public static final FeatureSet ES5 = ES3.with(LangVersion.access$000(LangVersion.ES5));
    public static final FeatureSet ES6_MODULES = ES5.with(LangVersion.access$000(LangVersion.ES6));
    public static final FeatureSet ES6 = ES6_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES7_MODULES = ES6_MODULES.with(LangVersion.access$000(LangVersion.ES7));
    public static final FeatureSet ES7 = ES7_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES8_MODULES = ES7_MODULES.with(LangVersion.access$000(LangVersion.ES8));
    public static final FeatureSet ES8 = ES8_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES2018_MODULES = ES8_MODULES.with(LangVersion.access$000(LangVersion.ES2018));
    public static final FeatureSet ES2018 = ES2018_MODULES.without(Feature.MODULES, new Feature[0]);
    public static final FeatureSet ES_NEXT = ES2018_MODULES.with(LangVersion.access$000(LangVersion.ES_NEXT));
    public static final FeatureSet TYPESCRIPT = ES_NEXT.with(LangVersion.access$000(LangVersion.TYPESCRIPT));
    public static final FeatureSet TYPE_CHECK_SUPPORTED = ES8.without(Feature.ARRAY_PATTERN_REST, new Feature[0]).without(Feature.ASYNC_FUNCTIONS, new Feature[0]).without(Feature.CLASSES, new Feature[0]).without(Feature.CLASS_EXTENDS, new Feature[0]).without(Feature.CLASS_GETTER_SETTER, new Feature[0]).without(Feature.DEFAULT_PARAMETERS, new Feature[0]).without(Feature.DESTRUCTURING, new Feature[0]).without(Feature.MODULES, new Feature[0]).without(Feature.NEW_TARGET, new Feature[0]);

    private FeatureSet(EnumSet<Feature> features) {
        this.features = ImmutableSet.copyOf(features);
    }

    public String version() {
        if (ES3.contains(this)) {
            return "es3";
        }
        if (ES5.contains(this)) {
            return "es5";
        }
        if (ES6_MODULES.contains(this)) {
            return "es6";
        }
        if (ES7_MODULES.contains(this)) {
            return "es7";
        }
        if (ES8_MODULES.contains(this)) {
            return "es8";
        }
        if (ES2018_MODULES.contains(this)) {
            return "es9";
        }
        if (ES_NEXT.contains(this)) {
            return "es_next";
        }
        if (TYPESCRIPT.contains(this)) {
            return "ts";
        }
        throw new IllegalStateException(this.toString());
    }

    public String versionForDebugging() {
        if (ES3.contains(this)) {
            return "es3";
        }
        if (ES5.contains(this)) {
            return "es5";
        }
        if (TYPE_CHECK_SUPPORTED.contains(this)) {
            return "typeCheckSupported";
        }
        if (ES6_MODULES.contains(this)) {
            return "es6";
        }
        if (ES7_MODULES.contains(this)) {
            return "es7";
        }
        if (ES8_MODULES.contains(this)) {
            return "es8";
        }
        if (ES2018_MODULES.contains(this)) {
            return "es9";
        }
        if (ES_NEXT.contains(this)) {
            return "es_next";
        }
        if (TYPESCRIPT.contains(this)) {
            return "ts";
        }
        throw new IllegalStateException(this.toString());
    }

    public FeatureSet without(Feature featureToRemove, Feature ... moreFeaturesToRemove) {
        return new FeatureSet(FeatureSet.difference(this.features, EnumSet.of(featureToRemove, moreFeaturesToRemove)));
    }

    public FeatureSet without(FeatureSet other) {
        return new FeatureSet(FeatureSet.difference(this.features, other.features));
    }

    public FeatureSet withoutTypes() {
        return new FeatureSet(FeatureSet.difference(this.features, LangVersion.TYPESCRIPT.features()));
    }

    public FeatureSet union(FeatureSet other) {
        return new FeatureSet(FeatureSet.union(this.features, other.features));
    }

    public boolean contains(FeatureSet other) {
        return this.features.containsAll(other.features);
    }

    public boolean contains(Feature feature) {
        return this.features.containsAll(EnumSet.of(feature));
    }

    private static EnumSet<Feature> emptyEnumSet() {
        return EnumSet.noneOf(Feature.class);
    }

    private static EnumSet<Feature> enumSetOf(Set<Feature> set) {
        return set.isEmpty() ? FeatureSet.emptyEnumSet() : EnumSet.copyOf(set);
    }

    private static EnumSet<Feature> add(Set<Feature> features, Feature feature) {
        EnumSet<Feature> result = FeatureSet.enumSetOf(features);
        result.add(feature);
        return result;
    }

    private static EnumSet<Feature> union(Set<Feature> features, Set<Feature> newFeatures) {
        EnumSet<Feature> result = FeatureSet.enumSetOf(features);
        result.addAll(newFeatures);
        return result;
    }

    private static EnumSet<Feature> difference(Set<Feature> features, Set<Feature> removedFeatures) {
        EnumSet<Feature> result = FeatureSet.enumSetOf(features);
        result.removeAll(removedFeatures);
        return result;
    }

    public FeatureSet with(Feature feature) {
        if (this.features.contains((Object)feature)) {
            return this;
        }
        return new FeatureSet(FeatureSet.add(this.features, feature));
    }

    @VisibleForTesting
    public FeatureSet with(Feature ... newFeatures) {
        return new FeatureSet(FeatureSet.union(this.features, (Set<Feature>)ImmutableSet.copyOf((Object[])newFeatures)));
    }

    @VisibleForTesting
    public FeatureSet with(Set<Feature> newFeatures) {
        return new FeatureSet(FeatureSet.union(this.features, newFeatures));
    }

    @VisibleForTesting
    public FeatureSet with(FeatureSet newFeatures) {
        return new FeatureSet(FeatureSet.union(this.features, newFeatures.features));
    }

    public boolean has(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public ImmutableSet<Feature> getFeatures() {
        return this.features;
    }

    public boolean equals(Object other) {
        return other instanceof FeatureSet && ((FeatureSet)other).features.equals(this.features);
    }

    public int hashCode() {
        return this.features.hashCode();
    }

    public String toString() {
        return this.features.toString();
    }

    public static FeatureSet valueOf(String name) {
        switch (name) {
            case "es3": {
                return ES3;
            }
            case "es5": {
                return ES5;
            }
            case "es6-impl": 
            case "es6": {
                return ES6;
            }
            case "typeCheckSupported": {
                return TYPE_CHECK_SUPPORTED;
            }
            case "es7": {
                return ES7;
            }
            case "es8": {
                return ES8;
            }
            case "es2018": 
            case "es9": {
                return ES2018;
            }
            case "es_next": {
                return ES_NEXT;
            }
            case "ts": {
                return TYPESCRIPT;
            }
        }
        throw new IllegalArgumentException("No such FeatureSet: " + name);
    }

    public static FeatureSet latest() {
        return TYPESCRIPT;
    }

    public static enum Feature {
        ES3_KEYWORDS_AS_IDENTIFIERS("ES3 keywords as identifiers", LangVersion.ES5),
        GETTER("getters", LangVersion.ES5),
        KEYWORDS_AS_PROPERTIES("reserved words as properties", LangVersion.ES5),
        SETTER("setters", LangVersion.ES5),
        STRING_CONTINUATION("string continuation", LangVersion.ES5),
        TRAILING_COMMA("trailing comma", LangVersion.ES5),
        ARRAY_PATTERN_REST("array pattern rest", LangVersion.ES6),
        ARROW_FUNCTIONS("arrow function", LangVersion.ES6),
        BINARY_LITERALS("binary literal", LangVersion.ES6),
        BLOCK_SCOPED_FUNCTION_DECLARATION("block-scoped function declaration", LangVersion.ES6),
        CLASSES("class", LangVersion.ES6),
        CLASS_EXTENDS("class extends", LangVersion.ES6),
        CLASS_GETTER_SETTER("class getters/setters", LangVersion.ES6),
        COMPUTED_PROPERTIES("computed property", LangVersion.ES6),
        CONST_DECLARATIONS("const declaration", LangVersion.ES6),
        DEFAULT_PARAMETERS("default parameter", LangVersion.ES6),
        DESTRUCTURING("destructuring", LangVersion.ES6),
        EXTENDED_OBJECT_LITERALS("extended object literal", LangVersion.ES6),
        FOR_OF("for-of loop", LangVersion.ES6),
        GENERATORS("generator", LangVersion.ES6),
        LET_DECLARATIONS("let declaration", LangVersion.ES6),
        MEMBER_DECLARATIONS("member declaration", LangVersion.ES6),
        NEW_TARGET("new.target", LangVersion.ES6),
        OCTAL_LITERALS("octal literal", LangVersion.ES6),
        REGEXP_FLAG_U("RegExp flag 'u'", LangVersion.ES6),
        REGEXP_FLAG_Y("RegExp flag 'y'", LangVersion.ES6),
        REST_PARAMETERS("rest parameter", LangVersion.ES6),
        SPREAD_EXPRESSIONS("spread expression", LangVersion.ES6),
        SUPER("super", LangVersion.ES6),
        TEMPLATE_LITERALS("template literal", LangVersion.ES6),
        MODULES("modules", LangVersion.ES6),
        EXPONENT_OP("exponent operator (**)", LangVersion.ES7),
        ASYNC_FUNCTIONS("async function", LangVersion.ES8),
        TRAILING_COMMA_IN_PARAM_LIST("trailing comma in param list", LangVersion.ES8),
        OBJECT_LITERALS_WITH_SPREAD("object literals with spread", LangVersion.ES2018),
        OBJECT_PATTERN_REST("object pattern rest", LangVersion.ES2018),
        ASYNC_GENERATORS("async generator functions", LangVersion.ES_NEXT),
        FOR_AWAIT_OF("for-await-of loop", LangVersion.ES_NEXT),
        ACCESSIBILITY_MODIFIER("accessibility modifier", LangVersion.TYPESCRIPT),
        AMBIENT_DECLARATION("ambient declaration", LangVersion.TYPESCRIPT),
        CALL_SIGNATURE("call signature", LangVersion.TYPESCRIPT),
        CONSTRUCTOR_SIGNATURE("constructor signature", LangVersion.TYPESCRIPT),
        ENUM("enum", LangVersion.TYPESCRIPT),
        GENERICS("generics", LangVersion.TYPESCRIPT),
        IMPLEMENTS("implements", LangVersion.TYPESCRIPT),
        INDEX_SIGNATURE("index signature", LangVersion.TYPESCRIPT),
        INTERFACE("interface", LangVersion.TYPESCRIPT),
        MEMBER_VARIABLE_IN_CLASS("member variable in class", LangVersion.TYPESCRIPT),
        NAMESPACE_DECLARATION("namespace declaration", LangVersion.TYPESCRIPT),
        OPTIONAL_PARAMETER("optional parameter", LangVersion.TYPESCRIPT),
        TYPE_ALIAS("type alias", LangVersion.TYPESCRIPT),
        TYPE_ANNOTATION("type annotation", LangVersion.TYPESCRIPT);

        private final String name;
        private final LangVersion version;

        private Feature(String name, LangVersion version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum LangVersion {
        ES3,
        ES5,
        ES6,
        ES7,
        ES8,
        ES2018,
        ES_NEXT,
        TYPESCRIPT;


        private EnumSet<Feature> features() {
            EnumSet<Feature> set = EnumSet.noneOf(Feature.class);
            for (Feature feature : Feature.values()) {
                if (feature.version != this) continue;
                set.add(feature);
            }
            return set;
        }
    }
}

