/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.Keywords;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.Scanner;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.AmbientDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.AwaitExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EnumDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForAwaitOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.GenericTypeListTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.IndexSignatureTree;
import com.google.javascript.jscomp.parsing.parser.trees.InterfaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberVariableTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NamespaceDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.NamespaceNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewTargetExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.OptionalParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParameterizedTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RecordTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeAliasTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeNameTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypeQueryTree;
import com.google.javascript.jscomp.parsing.parser.trees.TypedParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnionTypeTree;
import com.google.javascript.jscomp.parsing.parser.trees.UpdateExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.LookaheadErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class Parser {
    private final Scanner scanner;
    private final ErrorReporter errorReporter;
    private final Config config;
    private final CommentRecorder commentRecorder = new CommentRecorder();
    private final ArrayDeque<FunctionFlavor> functionContextStack = new ArrayDeque();
    private FeatureSet features = FeatureSet.BARE_MINIMUM;
    private SourcePosition lastSourcePosition;
    @Nullable
    private String sourceMapURL;
    private static final String SOURCE_MAPPING_URL_PREFIX = "//# sourceMappingURL=";
    private static final String AWAIT = "await";
    private static final String ASYNC = "async";

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source, int offset, boolean initialGeneratorContext) {
        this.config = config;
        this.errorReporter = errorReporter;
        this.scanner = new Scanner(config.parseTypeSyntax, errorReporter, this.commentRecorder, source, offset);
        this.functionContextStack.addLast(initialGeneratorContext ? FunctionFlavor.GENERATOR : FunctionFlavor.NORMAL);
        this.lastSourcePosition = this.scanner.getPosition();
    }

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source, int offset) {
        this(config, errorReporter, source, offset, false);
    }

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source) {
        this(config, errorReporter, source, 0);
    }

    public List<Comment> getComments() {
        return this.commentRecorder.getComments();
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    @Nullable
    public String getSourceMapURL() {
        return this.sourceMapURL;
    }

    private boolean isKeyword(String value) {
        return Keywords.isKeyword(value, this.config.parseTypeSyntax);
    }

    public ProgramTree parseProgram() {
        try {
            SourcePosition start = this.getTreeStartLocation();
            ImmutableList<ParseTree> sourceElements = this.parseGlobalSourceElements();
            this.eat(TokenType.END_OF_FILE);
            return new ProgramTree(this.getTreeLocation(start), sourceElements, (ImmutableList<Comment>)this.commentRecorder.getComments());
        }
        catch (StackOverflowError e) {
            this.reportError("Too deep recursion while parsing", new Object[0]);
            return null;
        }
    }

    private ImmutableList<ParseTree> parseGlobalSourceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!this.peek(TokenType.END_OF_FILE)) {
            result.add((Object)this.parseScriptElement());
        }
        return result.build();
    }

    private ImmutableList<ParseTree> parseNamespaceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!this.peek(TokenType.CLOSE_CURLY) && !this.peek(TokenType.END_OF_FILE)) {
            result.add((Object)this.parseScriptElement());
        }
        return result.build();
    }

    private ImmutableList<ParseTree> parseAmbientNamespaceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekAmbientNamespaceElement()) {
            result.add((Object)this.parseAmbientNamespaceElement());
        }
        return result.build();
    }

    private ParseTree parseScriptElement() {
        if (this.peekImportDeclaration()) {
            return this.parseImportDeclaration();
        }
        if (this.peekExportDeclaration()) {
            return this.parseExportDeclaration(false);
        }
        if (this.peekInterfaceDeclaration()) {
            return this.parseInterfaceDeclaration();
        }
        if (this.peekEnumDeclaration()) {
            return this.parseEnumDeclaration();
        }
        if (this.peekTypeAlias()) {
            return this.parseTypeAlias();
        }
        if (this.peekAmbientDeclaration()) {
            return this.parseAmbientDeclaration();
        }
        if (this.peekNamespaceDeclaration()) {
            return this.parseNamespaceDeclaration(false);
        }
        return this.parseSourceElement();
    }

    private ParseTree parseAmbientNamespaceElement() {
        if (this.peekInterfaceDeclaration()) {
            return this.parseInterfaceDeclaration();
        }
        if (this.peekExportDeclaration()) {
            return this.parseExportDeclaration(true);
        }
        return this.parseAmbientDeclarationHelper();
    }

    private boolean peekImportDeclaration() {
        return this.peek(TokenType.IMPORT);
    }

    private ParseTree parseImportDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IMPORT);
        if (this.peek(TokenType.STRING)) {
            LiteralToken moduleSpecifier = this.eat(TokenType.STRING).asLiteral();
            this.eatPossibleImplicitSemiColon();
            return new ImportDeclarationTree(this.getTreeLocation(start), null, null, null, moduleSpecifier);
        }
        IdentifierToken defaultBindingIdentifier = null;
        IdentifierToken nameSpaceImportIdentifier = null;
        ImmutableList<ParseTree> identifierSet = null;
        boolean parseExplicitNames = true;
        if (this.peekId()) {
            defaultBindingIdentifier = this.eatId();
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
            } else {
                parseExplicitNames = false;
            }
        } else if (Keywords.isKeyword(this.peekType())) {
            Token keyword = this.nextToken();
            this.reportError(keyword, "cannot use keyword '%s' here.", keyword);
        }
        if (parseExplicitNames) {
            if (this.peek(TokenType.STAR)) {
                this.eat(TokenType.STAR);
                this.eatPredefinedString("as");
                nameSpaceImportIdentifier = this.eatId();
            } else {
                identifierSet = this.parseImportSpecifierSet();
            }
        }
        this.eatPredefinedString("from");
        Token moduleStr = this.eat(TokenType.STRING);
        LiteralToken moduleSpecifier = moduleStr == null ? null : moduleStr.asLiteral();
        this.eatPossibleImplicitSemiColon();
        return new ImportDeclarationTree(this.getTreeLocation(start), defaultBindingIdentifier, identifierSet, nameSpaceImportIdentifier, moduleSpecifier);
    }

    private ImmutableList<ParseTree> parseImportSpecifierSet() {
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekIdOrKeyword()) {
            elements.add((Object)this.parseImportSpecifier());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return elements.build();
    }

    private ParseTree parseImportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatIdOrKeywordAsId();
        IdentifierToken destinationName = null;
        if (this.peekPredefinedString("as")) {
            this.eatPredefinedString("as");
            destinationName = this.eatId();
        } else if (this.isKeyword(importedName.value)) {
            this.reportExpectedError(null, "as");
        }
        return new ImportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekExportDeclaration() {
        return this.peek(TokenType.EXPORT);
    }

    private ParseTree parseExportDeclaration(boolean isAmbient) {
        SourcePosition start = this.getTreeStartLocation();
        boolean isDefault = false;
        boolean isExportAll = false;
        boolean isExportSpecifier = false;
        boolean needsSemiColon = true;
        this.eat(TokenType.EXPORT);
        ParseTree export = null;
        ImmutableList<ParseTree> exportSpecifierList = null;
        switch (this.peekType()) {
            case STAR: {
                isExportAll = true;
                this.nextToken();
                break;
            }
            case IDENTIFIER: {
                export = this.parseAsyncFunctionDeclaration();
                break;
            }
            case FUNCTION: {
                export = isAmbient ? this.parseAmbientFunctionDeclaration() : this.parseFunctionDeclaration();
                needsSemiColon = isAmbient;
                break;
            }
            case CLASS: {
                export = this.parseClassDeclaration(isAmbient);
                needsSemiColon = false;
                break;
            }
            case INTERFACE: {
                export = this.parseInterfaceDeclaration();
                needsSemiColon = false;
                break;
            }
            case ENUM: {
                export = this.parseEnumDeclaration();
                needsSemiColon = false;
                break;
            }
            case MODULE: 
            case NAMESPACE: {
                export = this.parseNamespaceDeclaration(isAmbient);
                needsSemiColon = false;
                break;
            }
            case DECLARE: {
                export = this.parseAmbientDeclaration();
                needsSemiColon = false;
                break;
            }
            case DEFAULT: {
                isDefault = true;
                this.nextToken();
                export = this.parseExpression();
                needsSemiColon = false;
                break;
            }
            case OPEN_CURLY: {
                isExportSpecifier = true;
                exportSpecifierList = this.parseExportSpecifierSet();
                break;
            }
            case TYPE: {
                export = this.parseTypeAlias();
                break;
            }
            default: {
                export = isAmbient ? this.parseAmbientVariableDeclarationList() : this.parseVariableDeclarationList();
            }
        }
        LiteralToken moduleSpecifier = null;
        if (isExportAll || isExportSpecifier && this.peekPredefinedString("from")) {
            this.eatPredefinedString("from");
            moduleSpecifier = (LiteralToken)this.eat(TokenType.STRING);
        } else if (isExportSpecifier) {
            for (ParseTree tree : exportSpecifierList) {
                IdentifierToken importedName = tree.asExportSpecifier().importedName;
                if (!this.isKeyword(importedName.value)) continue;
                this.reportError(importedName, "cannot use keyword '%s' here.", importedName.value);
            }
        }
        if (needsSemiColon || this.peekImplicitSemiColon()) {
            this.eatPossibleImplicitSemiColon();
        }
        return new ExportDeclarationTree(this.getTreeLocation(start), isDefault, isExportAll, export, exportSpecifierList, moduleSpecifier);
    }

    private ImmutableList<ParseTree> parseExportSpecifierSet() {
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekIdOrKeyword()) {
            elements.add((Object)this.parseExportSpecifier());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return elements.build();
    }

    private ParseTree parseExportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatIdOrKeywordAsId();
        IdentifierToken destinationName = null;
        if (this.peekPredefinedString("as")) {
            this.eatPredefinedString("as");
            destinationName = this.eatIdOrKeywordAsId();
        }
        return new ExportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekClassDeclaration() {
        return this.peek(TokenType.CLASS);
    }

    private boolean peekInterfaceDeclaration() {
        return this.peek(TokenType.INTERFACE);
    }

    private boolean peekEnumDeclaration() {
        return this.peek(TokenType.ENUM);
    }

    private boolean peekNamespaceDeclaration() {
        return (this.peek(TokenType.MODULE) || this.peek(TokenType.NAMESPACE)) && !this.peekImplicitSemiColon(1) && this.peek(1, TokenType.IDENTIFIER);
    }

    private ParseTree parseClassDeclaration(boolean isAmbient) {
        return this.parseClass(false, isAmbient);
    }

    private ParseTree parseClassExpression() {
        return this.parseClass(true, false);
    }

    private ParseTree parseInterfaceDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.INTERFACE);
        IdentifierToken name = this.eatId();
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        ImmutableList.Builder superTypes = ImmutableList.builder();
        if (this.peek(TokenType.EXTENDS)) {
            this.eat(TokenType.EXTENDS);
            ParseTree type = this.parseType();
            superTypes.add((Object)type);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                type = this.parseType();
                if (type == null) continue;
                superTypes.add((Object)type);
            }
        }
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseInterfaceElements();
        this.eat(TokenType.CLOSE_CURLY);
        return new InterfaceDeclarationTree(this.getTreeLocation(start), name, generics, (ImmutableList<ParseTree>)superTypes.build(), elements);
    }

    private ImmutableList<ParseTree> parseInterfaceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekInterfaceElement()) {
            result.add((Object)this.parseInterfaceElement());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            if (this.peekImplicitSemiColon()) {
                this.eatPossibleImplicitSemiColon();
                continue;
            }
            this.eat(TokenType.COMMA);
        }
        return result.build();
    }

    private boolean peekInterfaceElement() {
        Token token = this.peekToken();
        switch (token.type) {
            case STAR: 
            case IDENTIFIER: 
            case NEW: 
            case OPEN_SQUARE: 
            case OPEN_ANGLE: 
            case OPEN_PAREN: {
                return true;
            }
        }
        return Keywords.isKeyword(token.type);
    }

    private ParseTree parseInterfaceElement() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = null;
        TokenType type = this.peekType();
        if (type == TokenType.NEW) {
            return this.parseCallSignature(true);
        }
        if (type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            name = this.eatIdOrKeywordAsId();
        } else {
            if (type == TokenType.OPEN_SQUARE) {
                return this.parseIndexSignature();
            }
            if (type == TokenType.OPEN_ANGLE || type == TokenType.OPEN_PAREN) {
                return this.parseCallSignature(false);
            }
        }
        boolean isOptional = false;
        if (this.peek(TokenType.QUESTION)) {
            this.eat(TokenType.QUESTION);
            isOptional = true;
        }
        if (this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_ANGLE)) {
            FunctionDeclarationTree function = this.parseMethodSignature(start, name, false, isGenerator, isOptional, null);
            return function;
        }
        ParseTree declaredType = this.maybeParseColonType();
        return new MemberVariableTree(this.getTreeLocation(start), name, false, isOptional, null, declaredType);
    }

    private ParseTree parseEnumDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.ENUM);
        IdentifierToken name = this.eatId();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> members = this.parseEnumMembers();
        this.eat(TokenType.CLOSE_CURLY);
        return new EnumDeclarationTree(this.getTreeLocation(start), name, members);
    }

    private ImmutableList<ParseTree> parseEnumMembers() {
        SourceRange range = this.getTreeLocation(this.getTreeStartLocation());
        PropertyNameAssignmentTree member = null;
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekId()) {
            IdentifierToken propertyName = this.parseIdentifierExpression().identifierToken;
            member = new PropertyNameAssignmentTree(range, propertyName, null);
            result.add((Object)member);
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        return result.build();
    }

    private ParseTree parseClass(boolean isExpression, boolean isAmbient) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CLASS);
        IdentifierToken name = null;
        if (!isExpression || this.peekId()) {
            name = this.eatId();
        }
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        ParseTree superClass = null;
        if (this.peek(TokenType.EXTENDS)) {
            this.eat(TokenType.EXTENDS);
            superClass = this.parseExpression();
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (this.config.parseTypeSyntax && this.peek(TokenType.IMPLEMENTS)) {
            this.eat(TokenType.IMPLEMENTS);
            ParseTree type = this.parseType();
            interfaces.add((Object)type);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                type = this.parseType();
                if (type == null) continue;
                interfaces.add((Object)type);
            }
        }
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseClassElements(isAmbient);
        this.eat(TokenType.CLOSE_CURLY);
        return new ClassDeclarationTree(this.getTreeLocation(start), name, generics, superClass, (ImmutableList<ParseTree>)interfaces.build(), elements);
    }

    private ImmutableList<ParseTree> parseClassElements(boolean isAmbient) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekClassElement()) {
            result.add((Object)this.parseClassElement(isAmbient));
        }
        return result.build();
    }

    private boolean peekClassElement() {
        Token token = this.peekToken();
        switch (token.type) {
            case STAR: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case NUMBER: 
            case STATIC: 
            case STRING: 
            case SEMI_COLON: {
                return true;
            }
        }
        return Keywords.isKeyword(token.type);
    }

    private PartialClassElement getClassElementDefaults() {
        return new PartialClassElement(this.getTreeStartLocation());
    }

    private ParseTree parseClassElement(boolean isAmbient) {
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseEmptyStatement();
        }
        PartialClassElement partialElement = this.getClassElementDefaults();
        partialElement.isAmbient = isAmbient;
        partialElement.accessModifier = this.maybeParseAccessibilityModifier();
        partialElement.isStatic = this.eatOpt(TokenType.STATIC) != null;
        return this.parseClassElement(partialElement);
    }

    private ParseTree parseClassElement(PartialClassElement partialElement) {
        if (this.peekGetAccessor()) {
            return this.parseGetAccessor(partialElement);
        }
        if (this.peekSetAccessor()) {
            return this.parseSetAccessor(partialElement);
        }
        if (this.peekAsyncMethod()) {
            return this.parseAsyncMethod(partialElement);
        }
        return this.parseClassMemberDeclaration(partialElement);
    }

    private boolean peekAsyncMethod() {
        return this.peekPredefinedString(ASYNC) && !this.peekImplicitSemiColon(1) && (this.peekPropertyNameOrComputedProp(1) || this.peek(1, TokenType.STAR) && this.peekPropertyNameOrComputedProp(2));
    }

    private ParseTree parseClassMemberDeclaration() {
        return this.parseClassMemberDeclaration(this.getClassElementDefaults());
    }

    private ParseTree parseClassMemberDeclaration(PartialClassElement partial) {
        IdentifierToken name;
        ParseTree nameExpr;
        boolean isGenerator;
        boolean bl = isGenerator = this.eatOpt(TokenType.STAR) != null;
        if (this.peekPropertyName(0)) {
            if (this.peekIdOrKeyword()) {
                nameExpr = null;
                name = this.eatIdOrKeywordAsId();
                if (Keywords.isKeyword(name.value, false)) {
                    this.recordFeatureUsed(FeatureSet.Feature.KEYWORDS_AS_PROPERTIES);
                }
            } else {
                name = null;
                nameExpr = this.parseLiteralExpression();
            }
        } else {
            if (this.config.parseTypeSyntax && this.peekIndexSignature()) {
                IndexSignatureTree indexSignature = this.parseIndexSignature();
                this.eatPossibleImplicitSemiColon();
                return indexSignature;
            }
            nameExpr = this.parseComputedPropertyName();
            name = null;
        }
        if (!this.config.parseTypeSyntax || this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_ANGLE)) {
            FunctionDeclarationTree function;
            TokenType accessOnFunction;
            FunctionDeclarationTree.Kind kind;
            if (nameExpr == null) {
                kind = FunctionDeclarationTree.Kind.MEMBER;
                accessOnFunction = partial.accessModifier;
            } else {
                kind = FunctionDeclarationTree.Kind.EXPRESSION;
                accessOnFunction = null;
            }
            if (partial.isAmbient) {
                function = this.parseMethodSignature(partial, name, isGenerator, false);
                this.eatPossibleImplicitSemiColon();
            } else {
                FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(kind).setName(name).setStatic(partial.isStatic).setAccess(accessOnFunction);
                this.parseFunctionTail(builder, isGenerator ? FunctionFlavor.GENERATOR : FunctionFlavor.NORMAL);
                function = builder.build(this.getTreeLocation(partial.start));
            }
            if (kind == FunctionDeclarationTree.Kind.MEMBER) {
                return function;
            }
            return new ComputedPropertyMethodTree(this.getTreeLocation(partial.start), partial.accessModifier, nameExpr, function);
        }
        if (isGenerator) {
            this.reportError("Member variable cannot be prefixed by '*' (generator function)", new Object[0]);
        }
        ParseTree declaredType = this.maybeParseColonType();
        if (this.peek(TokenType.EQUAL)) {
            this.reportError("Member variable initializers ('=') are not supported", new Object[0]);
        }
        this.eatPossibleImplicitSemiColon();
        if (nameExpr == null) {
            return new MemberVariableTree(this.getTreeLocation(partial.start), name, partial.isStatic, false, partial.accessModifier, declaredType);
        }
        return new ComputedPropertyMemberVariableTree(this.getTreeLocation(partial.start), nameExpr, partial.isStatic, partial.accessModifier, declaredType);
    }

    private ParseTree parseAsyncMethod() {
        return this.parseAsyncMethod(this.getClassElementDefaults());
    }

    private ParseTree parseAsyncMethod(PartialClassElement partial) {
        this.eatPredefinedString(ASYNC);
        boolean generator = this.peek(TokenType.STAR);
        if (generator) {
            this.eat(TokenType.STAR);
        }
        if (this.peekPropertyName(0)) {
            if (this.peekIdOrKeyword()) {
                IdentifierToken name = this.eatIdOrKeywordAsId();
                FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.MEMBER).setAsync(true).setGenerator(generator).setStatic(partial.isStatic).setName(name).setAccess(partial.accessModifier);
                if (partial.isAmbient) {
                    builder.setGenerics(this.maybeParseGenericTypes()).setFormalParameterList(this.parseFormalParameterList(ParamContext.SIGNATURE)).setReturnType(this.maybeParseColonType()).setFunctionBody(new EmptyStatementTree(this.getTreeLocation(partial.start)));
                    this.eatPossibleImplicitSemiColon();
                } else {
                    this.parseFunctionTail(builder, generator ? FunctionFlavor.ASYNCHRONOUS_GENERATOR : FunctionFlavor.ASYNCHRONOUS);
                }
                return builder.build(this.getTreeLocation(name.getStart()));
            }
            LiteralExpressionTree nameExpr = this.parseLiteralExpression();
            FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.EXPRESSION).setAsync(true).setGenerator(generator).setStatic(partial.isStatic);
            this.parseFunctionTail(builder, generator ? FunctionFlavor.ASYNCHRONOUS_GENERATOR : FunctionFlavor.ASYNCHRONOUS);
            FunctionDeclarationTree function = builder.build(this.getTreeLocation(nameExpr.getStart()));
            return new ComputedPropertyMethodTree(this.getTreeLocation(nameExpr.getStart()), partial.accessModifier, nameExpr, function);
        }
        if (this.config.parseTypeSyntax && this.peekIndexSignature()) {
            IndexSignatureTree indexSignature = this.parseIndexSignature();
            this.eatPossibleImplicitSemiColon();
            return indexSignature;
        }
        ParseTree nameExpr = this.parseComputedPropertyName();
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.EXPRESSION).setAsync(true).setGenerator(generator).setStatic(partial.isStatic);
        this.parseFunctionTail(builder, generator ? FunctionFlavor.ASYNCHRONOUS_GENERATOR : FunctionFlavor.ASYNCHRONOUS);
        FunctionDeclarationTree function = builder.build(this.getTreeLocation(nameExpr.getStart()));
        return new ComputedPropertyMethodTree(this.getTreeLocation(nameExpr.getStart()), partial.accessModifier, nameExpr, function);
    }

    private FunctionDeclarationTree parseMethodSignature(PartialClassElement partial, IdentifierToken name, boolean isGenerator, boolean isOptional) {
        return this.parseMethodSignature(partial.start, name, partial.isStatic, isGenerator, isOptional, partial.accessModifier);
    }

    private FunctionDeclarationTree parseMethodSignature(SourcePosition start, IdentifierToken name, boolean isStatic, boolean isGenerator, boolean isOptional, TokenType access) {
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.MEMBER).setName(name).setStatic(isStatic).setGenerator(isGenerator).setOptional(isOptional).setAccess(access).setGenerics(this.maybeParseGenericTypes()).setFormalParameterList(this.parseFormalParameterList(ParamContext.SIGNATURE)).setReturnType(this.maybeParseColonType()).setFunctionBody(new EmptyStatementTree(this.getTreeLocation(start)));
        return builder.build(this.getTreeLocation(start));
    }

    private FunctionDeclarationTree parseAmbientFunctionDeclaration(SourcePosition start, IdentifierToken name, boolean isGenerator) {
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.DECLARATION).setName(name).setGenerator(isGenerator).setGenerics(this.maybeParseGenericTypes()).setFormalParameterList(this.parseFormalParameterList(ParamContext.SIGNATURE)).setReturnType(this.maybeParseColonType()).setFunctionBody(new EmptyStatementTree(this.getTreeLocation(start)));
        return builder.build(this.getTreeLocation(start));
    }

    private void parseFunctionTail(FunctionDeclarationTree.Builder builder, FunctionFlavor functionFlavor) {
        this.functionContextStack.addLast(functionFlavor);
        builder.setGenerator(functionFlavor.isGenerator).setGenerics(this.maybeParseGenericTypes()).setFormalParameterList(this.parseFormalParameterList(ParamContext.IMPLEMENTATION)).setReturnType(this.maybeParseColonType()).setFunctionBody(this.parseFunctionBody());
        this.functionContextStack.removeLast();
    }

    private NamespaceDeclarationTree parseNamespaceDeclaration(boolean isAmbient) {
        SourcePosition start = this.getTreeStartLocation();
        if (this.eatOpt(TokenType.MODULE) == null) {
            this.eat(TokenType.NAMESPACE);
        }
        NamespaceNameTree name = this.parseNamespaceName();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = isAmbient ? this.parseAmbientNamespaceElements() : this.parseNamespaceElements();
        this.eat(TokenType.CLOSE_CURLY);
        return new NamespaceDeclarationTree(this.getTreeLocation(start), name, elements);
    }

    private NamespaceNameTree parseNamespaceName() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken token = this.eatId();
        return new NamespaceNameTree(this.getTreeLocation(start), this.buildIdentifierPath(token));
    }

    private ParseTree parseSourceElement() {
        if (this.peekAsyncFunctionStart()) {
            return this.parseAsyncFunctionDeclaration();
        }
        if (this.peekFunction()) {
            return this.parseFunctionDeclaration();
        }
        if (this.peekClassDeclaration()) {
            return this.parseClassDeclaration(false);
        }
        if (this.peek(TokenType.LET)) {
            return this.parseVariableStatement();
        }
        return this.parseStatementStandard();
    }

    private boolean peekSourceElement() {
        return this.peekFunction() || this.peekStatementStandard() || this.peekDeclaration();
    }

    private boolean peekAsyncFunctionStart() {
        return this.peekPredefinedString(ASYNC) && !this.peekImplicitSemiColon(1) && this.peekFunction(1);
    }

    private void eatAsyncFunctionStart() {
        this.eatPredefinedString(ASYNC);
        this.eat(TokenType.FUNCTION);
    }

    private boolean peekFunction() {
        return this.peekFunction(0);
    }

    private boolean peekDeclaration() {
        return this.peek(TokenType.LET) || this.peekClassDeclaration();
    }

    private boolean peekTypeAlias() {
        return this.peek(TokenType.TYPE) && !this.peekImplicitSemiColon(1) && this.peek(1, TokenType.IDENTIFIER) && this.peek(2, TokenType.EQUAL);
    }

    private boolean peekIndexSignature() {
        return this.peek(TokenType.OPEN_SQUARE) && this.peek(1, TokenType.IDENTIFIER) && this.peek(2, TokenType.COLON);
    }

    private IndexSignatureTree parseIndexSignature() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_SQUARE);
        IdentifierToken name = this.eatIdOrKeywordAsId();
        this.eat(TokenType.COLON);
        TypeNameTree indexType = this.parseTypeName();
        this.eat(TokenType.CLOSE_SQUARE);
        this.eat(TokenType.COLON);
        ParseTree declaredType = this.parseType();
        MemberVariableTree nameTree = new MemberVariableTree(this.getTreeLocation(start), name, false, false, null, indexType);
        return new IndexSignatureTree(this.getTreeLocation(start), nameTree, declaredType);
    }

    private CallSignatureTree parseCallSignature(boolean isNew) {
        SourcePosition start = this.getTreeStartLocation();
        if (isNew) {
            this.eat(TokenType.NEW);
        }
        GenericTypeListTree generics = this.maybeParseGenericTypes();
        FormalParameterListTree params = this.parseFormalParameterList(ParamContext.SIGNATURE);
        ParseTree returnType = this.maybeParseColonType();
        return new CallSignatureTree(this.getTreeLocation(start), isNew, generics, params, returnType);
    }

    private boolean peekAmbientDeclaration() {
        return this.peek(TokenType.DECLARE) && !this.peekImplicitSemiColon(1) && (this.peek(1, TokenType.VAR) || this.peek(1, TokenType.LET) || this.peek(1, TokenType.CONST) || this.peek(1, TokenType.FUNCTION) || this.peek(1, TokenType.CLASS) || this.peek(1, TokenType.ENUM) || this.peek(1, TokenType.MODULE) || this.peek(1, TokenType.NAMESPACE));
    }

    private boolean peekAmbientNamespaceElement() {
        return this.peek(TokenType.VAR) || this.peek(TokenType.LET) || this.peek(TokenType.CONST) || this.peek(TokenType.FUNCTION) || this.peek(TokenType.CLASS) || this.peek(TokenType.INTERFACE) || this.peek(TokenType.ENUM) || this.peek(TokenType.MODULE) || this.peek(TokenType.NAMESPACE) || this.peek(TokenType.EXPORT);
    }

    private boolean peekFunction(int index) {
        return this.peek(index, TokenType.FUNCTION);
    }

    private boolean peekFunctionTypeExpression() {
        if (this.config.parseTypeSyntax && this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_ANGLE)) {
            Parser p = this.createLookaheadParser();
            try {
                p.maybeParseGenericTypes();
                p.parseFormalParameterList(ParamContext.TYPE_EXPRESSION);
                if (p.peek(TokenType.COLON)) {
                    p.parseTypeAnnotation();
                }
                return p.peek(TokenType.ARROW);
            }
            catch (LookaheadErrorReporter.ParseException e) {
                return false;
            }
        }
        return false;
    }

    private ParseTree parseFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.DECLARATION).setName(this.eatId());
        this.parseFunctionTail(builder, isGenerator ? FunctionFlavor.GENERATOR : FunctionFlavor.NORMAL);
        return builder.build(this.getTreeLocation(start));
    }

    private ParseTree parseFunctionExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.EXPRESSION).setName(this.eatIdOpt());
        this.parseFunctionTail(builder, isGenerator ? FunctionFlavor.GENERATOR : FunctionFlavor.NORMAL);
        return builder.build(this.getTreeLocation(start));
    }

    private ParseTree parseAsyncFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eatAsyncFunctionStart();
        boolean generator = this.peek(TokenType.STAR);
        if (generator) {
            this.eat(TokenType.STAR);
        }
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.DECLARATION).setName(this.eatId()).setAsync(true);
        this.parseFunctionTail(builder, generator ? FunctionFlavor.ASYNCHRONOUS_GENERATOR : FunctionFlavor.ASYNCHRONOUS);
        return builder.build(this.getTreeLocation(start));
    }

    private ParseTree parseAsyncFunctionExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eatAsyncFunctionStart();
        boolean generator = this.peek(TokenType.STAR);
        if (generator) {
            this.eat(TokenType.STAR);
        }
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.EXPRESSION).setName(this.eatIdOpt()).setAsync(true);
        this.parseFunctionTail(builder, generator ? FunctionFlavor.ASYNCHRONOUS_GENERATOR : FunctionFlavor.ASYNCHRONOUS);
        return builder.build(this.getTreeLocation(start));
    }

    private ParseTree parseAmbientFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = this.eatId();
        return this.parseAmbientFunctionDeclaration(start, name, isGenerator);
    }

    private boolean peekParameter(ParamContext context) {
        if (this.peekId() || this.peek(TokenType.SPREAD)) {
            return true;
        }
        if (context != ParamContext.TYPE_EXPRESSION) {
            return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.OPEN_CURLY);
        }
        return false;
    }

    private ParseTree parseParameter(ParamContext context) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree parameter = null;
        if (this.peek(TokenType.SPREAD)) {
            parameter = this.parseRestParameter();
        } else if (this.peekId()) {
            parameter = this.parseIdentifierExpression();
            if (this.peek(TokenType.QUESTION)) {
                this.eat(TokenType.QUESTION);
                parameter = new OptionalParameterTree(this.getTreeLocation(start), parameter);
            }
        } else if (context != ParamContext.TYPE_EXPRESSION && this.peekPatternStart()) {
            parameter = this.parsePattern(PatternKind.INITIALIZER);
        } else {
            throw new IllegalStateException("parseParameterCalled() without confirming a parameter exists.");
        }
        ParseTree typeAnnotation = null;
        SourceRange typeLocation = null;
        if (this.peek(TokenType.COLON)) {
            if (this.peek(1, TokenType.STRING)) {
                this.eat(TokenType.COLON);
                typeAnnotation = this.parseLiteralExpression();
            } else {
                typeAnnotation = this.parseTypeAnnotation();
            }
            typeLocation = this.getTreeLocation(this.getTreeStartLocation());
        }
        if (context == ParamContext.IMPLEMENTATION && !parameter.isRestParameter() && this.peek(TokenType.EQUAL)) {
            this.eat(TokenType.EQUAL);
            ParseTree defaultValue = this.parseAssignmentExpression();
            parameter = new DefaultParameterTree(this.getTreeLocation(start), parameter, defaultValue);
        }
        if (typeAnnotation != null) {
            parameter = new TypedParameterTree(typeLocation, parameter, typeAnnotation);
        }
        return parameter;
    }

    private ParseTree parseRestParameter() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SPREAD);
        return new RestParameterTree(this.getTreeLocation(start), this.parseRestAssignmentTarget(PatternKind.INITIALIZER));
    }

    private FormalParameterListTree parseFormalParameterList(ParamContext context) {
        SourcePosition listStart = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekParameter(context)) {
            result.add((Object)this.parseParameter(context));
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            Token comma = this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_PAREN)) continue;
            this.recordFeatureUsed(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST);
            if (this.config.atLeast8) continue;
            this.reportError(comma, "Invalid trailing comma in formal parameter list", new Object[0]);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new FormalParameterListTree(this.getTreeLocation(listStart), (ImmutableList<ParseTree>)result.build());
    }

    private FormalParameterListTree parseSetterParameterList() {
        ParseTree parameter;
        FormalParameterListTree parameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
        if (parameterList.parameters.size() != 1) {
            this.reportError(parameterList, "Setter must have exactly 1 parameter, found %d", parameterList.parameters.size());
        }
        if (parameterList.parameters.size() >= 1 && (parameter = (ParseTree)parameterList.parameters.get(0)).isRestParameter()) {
            this.reportError(parameter, "Setter must not have a rest parameter", new Object[0]);
        }
        return parameterList;
    }

    private ParseTree parseTypeAnnotation() {
        this.eat(TokenType.COLON);
        return this.parseType();
    }

    private ParseTree parseType() {
        SourcePosition start = this.getTreeStartLocation();
        if (!this.peekId() && !EnumSet.of(TokenType.VOID, TokenType.OPEN_PAREN, TokenType.OPEN_CURLY, TokenType.TYPEOF).contains((Object)this.peekType())) {
            this.reportError("Unexpected token '%s' in type expression", new Object[]{this.peekType()});
            return new TypeNameTree(this.getTreeLocation(start), (ImmutableList<String>)ImmutableList.of((Object)"error"));
        }
        ParseTree typeExpression = this.parseFunctionTypeExpression();
        if (!this.peek(TokenType.BAR)) {
            return typeExpression;
        }
        ImmutableList.Builder unionType = ImmutableList.builder();
        unionType.add((Object)typeExpression);
        do {
            this.eat(TokenType.BAR);
            unionType.add((Object)this.parseArrayTypeExpression());
        } while (this.peek(TokenType.BAR));
        return new UnionTypeTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)unionType.build());
    }

    private ParseTree parseFunctionTypeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree typeExpression = null;
        if (this.peekFunctionTypeExpression()) {
            FormalParameterListTree formalParameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
            this.eat(TokenType.ARROW);
            ParseTree returnType = this.parseType();
            typeExpression = new FunctionTypeTree(this.getTreeLocation(start), formalParameterList, returnType);
        } else {
            typeExpression = this.parseArrayTypeExpression();
        }
        return typeExpression;
    }

    private ParseTree parseArrayTypeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree typeExpression = this.parseParenTypeExpression();
        while (!this.peekImplicitSemiColon() && this.peek(TokenType.OPEN_SQUARE)) {
            this.eat(TokenType.OPEN_SQUARE);
            this.eat(TokenType.CLOSE_SQUARE);
            typeExpression = new ArrayTypeTree(this.getTreeLocation(start), typeExpression);
        }
        return typeExpression;
    }

    private ParseTree parseParenTypeExpression() {
        ParseTree typeExpression;
        if (this.peek(TokenType.OPEN_PAREN)) {
            this.eat(TokenType.OPEN_PAREN);
            typeExpression = this.parseType();
            this.eat(TokenType.CLOSE_PAREN);
        } else {
            typeExpression = this.parseRecordTypeExpression();
        }
        return typeExpression;
    }

    private ParseTree parseRecordTypeExpression() {
        ParseTree typeExpression;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peek(TokenType.OPEN_CURLY)) {
            this.eat(TokenType.OPEN_CURLY);
            typeExpression = new RecordTypeTree(this.getTreeLocation(start), this.parseInterfaceElements());
            this.eat(TokenType.CLOSE_CURLY);
        } else {
            typeExpression = this.parseTypeQuery();
        }
        return typeExpression;
    }

    private ParseTree parseTypeQuery() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peek(TokenType.TYPEOF)) {
            this.eat(TokenType.TYPEOF);
            IdentifierToken token = this.eatId();
            ImmutableList.Builder identifiers = ImmutableList.builder();
            if (token != null) {
                identifiers.add((Object)token.value);
            }
            while (this.peek(TokenType.PERIOD)) {
                this.eat(TokenType.PERIOD);
                token = this.eatId();
                if (token == null) break;
                identifiers.add((Object)token.value);
            }
            return new TypeQueryTree(this.getTreeLocation(start), (ImmutableList<String>)identifiers.build());
        }
        return this.parseTypeReference();
    }

    private ParseTree parseTypeReference() {
        SourcePosition start = this.getTreeStartLocation();
        TypeNameTree typeName = this.parseTypeName();
        if (!this.peek(TokenType.OPEN_ANGLE)) {
            return typeName;
        }
        return this.parseTypeArgumentList(start, typeName);
    }

    private ParseTree parseTypeArgumentList(SourcePosition start, TypeNameTree typeName) {
        this.eat(TokenType.OPEN_ANGLE);
        this.scanner.incTypeParameterLevel();
        ImmutableList.Builder typeArguments = ImmutableList.builder();
        ParseTree type = this.parseType();
        typeArguments.add((Object)type);
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            type = this.parseType();
            if (type == null) continue;
            typeArguments.add((Object)type);
        }
        this.eat(TokenType.CLOSE_ANGLE);
        this.scanner.decTypeParameterLevel();
        return new ParameterizedTypeTree(this.getTreeLocation(start), typeName, (ImmutableList<ParseTree>)typeArguments.build());
    }

    private TypeNameTree parseTypeName() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken token = this.eatIdOrKeywordAsId();
        return new TypeNameTree(this.getTreeLocation(start), this.buildIdentifierPath(token));
    }

    private ImmutableList<String> buildIdentifierPath(IdentifierToken token) {
        ImmutableList.Builder identifiers = ImmutableList.builder();
        identifiers.add((Object)(token != null ? token.value : ""));
        while (this.peek(TokenType.PERIOD)) {
            this.eat(TokenType.PERIOD);
            token = this.eatId();
            if (token == null) break;
            identifiers.add((Object)token.value);
        }
        return identifiers.build();
    }

    private BlockTree parseFunctionBody() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseSourceElementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekSourceElement()) {
            result.add((Object)this.parseSourceElement());
        }
        return result.build();
    }

    private SpreadExpressionTree parseSpreadExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SPREAD);
        ParseTree operand = this.parseAssignmentExpression();
        return new SpreadExpressionTree(this.getTreeLocation(start), operand);
    }

    private ParseTree parseStatement() {
        return this.parseSourceElement();
    }

    private ParseTree parseStatementStandard() {
        switch (this.peekType()) {
            case OPEN_CURLY: {
                return this.parseBlock();
            }
            case VAR: 
            case CONST: {
                return this.parseVariableStatement();
            }
            case SEMI_COLON: {
                return this.parseEmptyStatement();
            }
            case IF: {
                return this.parseIfStatement();
            }
            case DO: {
                return this.parseDoWhileStatement();
            }
            case WHILE: {
                return this.parseWhileStatement();
            }
            case FOR: {
                return this.parseForStatement();
            }
            case CONTINUE: {
                return this.parseContinueStatement();
            }
            case BREAK: {
                return this.parseBreakStatement();
            }
            case RETURN: {
                return this.parseReturnStatement();
            }
            case WITH: {
                return this.parseWithStatement();
            }
            case SWITCH: {
                return this.parseSwitchStatement();
            }
            case THROW: {
                return this.parseThrowStatement();
            }
            case TRY: {
                return this.parseTryStatement();
            }
            case DEBUGGER: {
                return this.parseDebuggerStatement();
            }
        }
        if (this.peekLabelledStatement()) {
            return this.parseLabelledStatement();
        }
        return this.parseExpressionStatement();
    }

    private boolean peekStatement() {
        return this.peekSourceElement();
    }

    private boolean peekStatementStandard() {
        switch (this.peekType()) {
            case IDENTIFIER: 
            case CLASS: 
            case MODULE: 
            case NAMESPACE: 
            case DECLARE: 
            case OPEN_CURLY: 
            case TYPE: 
            case VAR: 
            case CONST: 
            case NEW: 
            case OPEN_SQUARE: 
            case OPEN_PAREN: 
            case NUMBER: 
            case STRING: 
            case SEMI_COLON: 
            case IF: 
            case DO: 
            case WHILE: 
            case FOR: 
            case CONTINUE: 
            case BREAK: 
            case RETURN: 
            case WITH: 
            case SWITCH: 
            case THROW: 
            case TRY: 
            case DEBUGGER: 
            case YIELD: 
            case THIS: 
            case SUPER: 
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: 
            case NULL: 
            case TRUE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case FALSE: 
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private BlockTree parseBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseStatementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekStatement()) {
            result.add((Object)this.parseStatement());
        }
        return result.build();
    }

    private VariableStatementTree parseVariableStatement() {
        SourcePosition start = this.getTreeStartLocation();
        VariableDeclarationListTree declarations = this.parseVariableDeclarationList();
        this.eatPossibleImplicitSemiColon();
        return new VariableStatementTree(this.getTreeLocation(start), declarations);
    }

    private VariableDeclarationListTree parseVariableDeclarationList() {
        return this.parseVariableDeclarationList(Expression.NORMAL);
    }

    private VariableDeclarationListTree parseVariableDeclarationListNoIn() {
        return this.parseVariableDeclarationList(Expression.NO_IN);
    }

    private VariableDeclarationListTree parseAmbientVariableDeclarationList() {
        VariableDeclarationListTree declare = this.parseVariableDeclarationList(Expression.NO_IN);
        for (VariableDeclarationTree tree : declare.asVariableDeclarationList().declarations) {
            if (tree.initializer == null) continue;
            this.reportError("Ambient variable declaration may not have initializer", new Object[0]);
        }
        return declare;
    }

    private VariableDeclarationListTree parseVariableDeclarationList(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        TokenType token = this.peekType();
        switch (token) {
            case VAR: 
            case LET: 
            case CONST: {
                this.eat(token);
                break;
            }
            default: {
                this.reportError(this.peekToken(), "expected declaration", new Object[0]);
                return null;
            }
        }
        ImmutableList.Builder declarations = ImmutableList.builder();
        declarations.add((Object)this.parseVariableDeclaration(token, expressionIn));
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            declarations.add((Object)this.parseVariableDeclaration(token, expressionIn));
        }
        return new VariableDeclarationListTree(this.getTreeLocation(start), token, (ImmutableList<VariableDeclarationTree>)declarations.build());
    }

    private VariableDeclarationTree parseVariableDeclaration(TokenType binding, Expression expressionIn) {
        ParseTree lvalue;
        SourcePosition start = this.getTreeStartLocation();
        ParseTree typeAnnotation = null;
        if (this.peekPatternStart()) {
            lvalue = this.parsePattern(PatternKind.INITIALIZER);
        } else {
            lvalue = this.parseIdentifierExpression();
            if (this.peek(TokenType.COLON)) {
                typeAnnotation = this.parseTypeAnnotation();
            }
        }
        ParseTree initializer = null;
        if (this.peek(TokenType.EQUAL)) {
            initializer = this.parseInitializer(expressionIn);
        } else if (expressionIn != Expression.NO_IN) {
            this.maybeReportNoInitializer(binding, lvalue);
        }
        return new VariableDeclarationTree(this.getTreeLocation(start), lvalue, typeAnnotation, initializer);
    }

    private ParseTree parseInitializer(Expression expressionIn) {
        this.eat(TokenType.EQUAL);
        return this.parseAssignment(expressionIn);
    }

    private EmptyStatementTree parseEmptyStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SEMI_COLON);
        return new EmptyStatementTree(this.getTreeLocation(start));
    }

    private ExpressionStatementTree parseExpressionStatement() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree expression = this.parseExpression();
        this.eatPossibleImplicitSemiColon();
        return new ExpressionStatementTree(this.getTreeLocation(start), expression);
    }

    private IfStatementTree parseIfStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree ifClause = this.parseStatement();
        ParseTree elseClause = null;
        if (this.peek(TokenType.ELSE)) {
            this.eat(TokenType.ELSE);
            elseClause = this.parseStatement();
        }
        return new IfStatementTree(this.getTreeLocation(start), condition, ifClause, elseClause);
    }

    private ParseTree parseDoWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DO);
        ParseTree body = this.parseStatement();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        if (this.peek(TokenType.SEMI_COLON)) {
            this.eat(TokenType.SEMI_COLON);
        }
        return new DoWhileStatementTree(this.getTreeLocation(start), body, condition);
    }

    private ParseTree parseWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WhileStatementTree(this.getTreeLocation(start), condition, body);
    }

    private ParseTree parseForStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        boolean awaited = this.peekPredefinedString(AWAIT);
        if (awaited) {
            this.eatPredefinedString(AWAIT);
        }
        this.eat(TokenType.OPEN_PAREN);
        if (this.peekVariableDeclarationList()) {
            VariableDeclarationListTree variables = this.parseVariableDeclarationListNoIn();
            if (this.peek(TokenType.IN)) {
                if (awaited) {
                    this.reportError("for-await-of is the only allowed asynchronous iteration", new Object[0]);
                }
                if (variables.declarations.size() > 1) {
                    this.reportError("for-in statement may not have more than one variable declaration", new Object[0]);
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    if (this.config.atLeast6) {
                        this.reportError("for-in statement may not have initializer", new Object[0]);
                    } else {
                        this.errorReporter.reportWarning(declaration.location.start, "for-in statement should not have initializer", new Object[0]);
                    }
                }
                return this.parseForInStatement(start, variables);
            }
            if (this.peekPredefinedString("of")) {
                if (variables.declarations.size() > 1) {
                    if (awaited) {
                        this.reportError("for-await-of statement may not have more than one variable declaration", new Object[0]);
                    } else {
                        this.reportError("for-of statement may not have more than one variable declaration", new Object[0]);
                    }
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    if (awaited) {
                        this.reportError("for-await-of statement may not have initializer", new Object[0]);
                    } else {
                        this.reportError("for-of statement may not have initializer", new Object[0]);
                    }
                }
                if (awaited) {
                    return this.parseForAwaitOfStatement(start, variables);
                }
                return this.parseForOfStatement(start, variables);
            }
            this.checkVanillaForInitializers(variables);
            return this.parseForStatement(start, variables);
        }
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseForStatement(start, null);
        }
        ParseTree initializer = this.parseExpressionNoIn();
        if ((this.peek(TokenType.IN) || this.peek(TokenType.EQUAL) || this.peekPredefinedString("of")) && !(initializer = this.transformLeftHandSideExpression(initializer)).isValidAssignmentTarget()) {
            this.reportError("invalid assignment target", new Object[0]);
        }
        if ((this.peek(TokenType.IN) || this.peekPredefinedString("of")) && initializer.type != ParseTreeType.BINARY_OPERATOR && initializer.type != ParseTreeType.COMMA_EXPRESSION) {
            if (this.peek(TokenType.IN)) {
                return this.parseForInStatement(start, initializer);
            }
            if (awaited) {
                return this.parseForAwaitOfStatement(start, initializer);
            }
            return this.parseForOfStatement(start, initializer);
        }
        return this.parseForStatement(start, initializer);
    }

    private ParseTree parseForOfStatement(SourcePosition start, ParseTree initializer) {
        this.eatPredefinedString("of");
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForOfStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private ParseTree parseForAwaitOfStatement(SourcePosition start, ParseTree initializer) {
        this.eatPredefinedString("of");
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForAwaitOfStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private void checkVanillaForInitializers(VariableDeclarationListTree variables) {
        for (VariableDeclarationTree declaration : variables.declarations) {
            if (declaration.initializer != null) continue;
            this.maybeReportNoInitializer(variables.declarationType, declaration.lvalue);
        }
    }

    private void maybeReportNoInitializer(TokenType token, ParseTree lvalue) {
        if (token == TokenType.CONST) {
            this.reportError("const variables must have an initializer", new Object[0]);
        } else if (lvalue.isPattern()) {
            this.reportError("destructuring must have an initializer", new Object[0]);
        }
    }

    private boolean peekVariableDeclarationList() {
        switch (this.peekType()) {
            case VAR: 
            case LET: 
            case CONST: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseForStatement(SourcePosition start, ParseTree initializer) {
        if (initializer == null) {
            initializer = new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        }
        this.eat(TokenType.SEMI_COLON);
        ParseTree condition = !this.peek(TokenType.SEMI_COLON) ? this.parseExpression() : new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        this.eat(TokenType.SEMI_COLON);
        ParseTree increment = !this.peek(TokenType.CLOSE_PAREN) ? this.parseExpression() : new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForStatementTree(this.getTreeLocation(start), initializer, condition, increment, body);
    }

    private ParseTree parseForInStatement(SourcePosition start, ParseTree initializer) {
        this.eat(TokenType.IN);
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForInStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private ParseTree parseContinueStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CONTINUE);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new ContinueStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseBreakStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.BREAK);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new BreakStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseReturnStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.RETURN);
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            expression = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ReturnStatementTree(this.getTreeLocation(start), expression);
    }

    private ParseTree parseWithStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WITH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WithStatementTree(this.getTreeLocation(start), expression, body);
    }

    private ParseTree parseSwitchStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SWITCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> caseClauses = this.parseCaseClauses();
        this.eat(TokenType.CLOSE_CURLY);
        return new SwitchStatementTree(this.getTreeLocation(start), expression, caseClauses);
    }

    private ImmutableList<ParseTree> parseCaseClauses() {
        boolean foundDefaultClause = false;
        ImmutableList.Builder result = ImmutableList.builder();
        block4: while (true) {
            SourcePosition start = this.getTreeStartLocation();
            switch (this.peekType()) {
                case CASE: {
                    this.eat(TokenType.CASE);
                    ParseTree expression = this.parseExpression();
                    this.eat(TokenType.COLON);
                    ImmutableList<ParseTree> statements = this.parseCaseStatementsOpt();
                    result.add((Object)new CaseClauseTree(this.getTreeLocation(start), expression, statements));
                    continue block4;
                }
                case DEFAULT: {
                    if (foundDefaultClause) {
                        this.reportError("Switch statements may have at most one default clause", new Object[0]);
                    } else {
                        foundDefaultClause = true;
                    }
                    this.eat(TokenType.DEFAULT);
                    this.eat(TokenType.COLON);
                    result.add((Object)new DefaultClauseTree(this.getTreeLocation(start), this.parseCaseStatementsOpt()));
                    continue block4;
                }
            }
            break;
        }
        return result.build();
    }

    private ImmutableList<ParseTree> parseCaseStatementsOpt() {
        return this.parseStatementList();
    }

    private ParseTree parseLabelledStatement() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.COLON);
        return new LabelledStatementTree(this.getTreeLocation(start), name, this.parseStatement());
    }

    private boolean peekLabelledStatement() {
        return this.peekId() && this.peek(1, TokenType.COLON);
    }

    private ParseTree parseThrowStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THROW);
        ParseTree value = null;
        if (this.peekImplicitSemiColon()) {
            this.reportError("semicolon/newline not allowed after 'throw'", new Object[0]);
        } else {
            value = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ThrowStatementTree(this.getTreeLocation(start), value);
    }

    private ParseTree parseTryStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.TRY);
        BlockTree body = this.parseBlock();
        CatchTree catchBlock = null;
        if (this.peek(TokenType.CATCH)) {
            catchBlock = this.parseCatch();
        }
        FinallyTree finallyBlock = null;
        if (this.peek(TokenType.FINALLY)) {
            finallyBlock = this.parseFinallyBlock();
        }
        if (catchBlock == null && finallyBlock == null) {
            this.reportError("'catch' or 'finally' expected.", new Object[0]);
        }
        return new TryStatementTree(this.getTreeLocation(start), body, catchBlock, finallyBlock);
    }

    private CatchTree parseCatch() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CATCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree exception = this.peekPatternStart() ? this.parsePattern(PatternKind.INITIALIZER) : this.parseIdentifierExpression();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree catchBody = this.parseBlock();
        CatchTree catchBlock = new CatchTree(this.getTreeLocation(start), exception, catchBody);
        return catchBlock;
    }

    private FinallyTree parseFinallyBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FINALLY);
        BlockTree finallyBlock = this.parseBlock();
        return new FinallyTree(this.getTreeLocation(start), finallyBlock);
    }

    private ParseTree parseDebuggerStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DEBUGGER);
        this.eatPossibleImplicitSemiColon();
        return new DebuggerStatementTree(this.getTreeLocation(start));
    }

    private ParseTree parsePrimaryExpression() {
        switch (this.peekType()) {
            case CLASS: {
                return this.parseClassExpression();
            }
            case SUPER: {
                return this.parseSuperExpression();
            }
            case THIS: {
                return this.parseThisExpression();
            }
            case IDENTIFIER: 
            case MODULE: 
            case NAMESPACE: 
            case DECLARE: 
            case TYPE: {
                return this.parseIdentifierExpression();
            }
            case NUMBER: 
            case STRING: 
            case NULL: 
            case TRUE: 
            case FALSE: {
                return this.parseLiteralExpression();
            }
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: {
                return this.parseTemplateLiteral(null);
            }
            case OPEN_SQUARE: {
                return this.parseArrayInitializer();
            }
            case OPEN_CURLY: {
                return this.parseObjectLiteral();
            }
            case OPEN_PAREN: {
                return this.parseCoverParenthesizedExpressionAndArrowParameterList();
            }
            case SLASH: 
            case SLASH_EQUAL: {
                return this.parseRegularExpressionLiteral();
            }
        }
        return this.parseMissingPrimaryExpression();
    }

    private SuperExpressionTree parseSuperExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SUPER);
        return new SuperExpressionTree(this.getTreeLocation(start));
    }

    private ThisExpressionTree parseThisExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THIS);
        return new ThisExpressionTree(this.getTreeLocation(start));
    }

    private IdentifierExpressionTree parseIdentifierExpression() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken identifier = this.eatId();
        return new IdentifierExpressionTree(this.getTreeLocation(start), identifier);
    }

    private LiteralExpressionTree parseLiteralExpression() {
        SourcePosition start = this.getTreeStartLocation();
        Token literal = this.nextLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private TemplateLiteralExpressionTree parseTemplateLiteral(ParseTree operand) {
        SourcePosition start = operand == null ? this.getTreeStartLocation() : operand.location.start;
        Token token = this.nextToken();
        ImmutableList.Builder elements = ImmutableList.builder();
        elements.add((Object)new TemplateLiteralPortionTree(token.location, token));
        if (token.type == TokenType.NO_SUBSTITUTION_TEMPLATE) {
            return new TemplateLiteralExpressionTree(this.getTreeLocation(start), operand, (ImmutableList<ParseTree>)elements.build());
        }
        ParseTree expression = this.parseExpression();
        elements.add((Object)new TemplateSubstitutionTree(expression.location, expression));
        while (!this.errorReporter.hadError()) {
            token = this.nextTemplateLiteralToken();
            if (token.type == TokenType.ERROR || token.type == TokenType.END_OF_FILE) break;
            elements.add((Object)new TemplateLiteralPortionTree(token.location, token));
            if (token.type == TokenType.TEMPLATE_TAIL) break;
            expression = this.parseExpression();
            elements.add((Object)new TemplateSubstitutionTree(expression.location, expression));
        }
        return new TemplateLiteralExpressionTree(this.getTreeLocation(start), operand, (ImmutableList<ParseTree>)elements.build());
    }

    private Token nextLiteralToken() {
        return this.nextToken();
    }

    private ParseTree parseRegularExpressionLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        LiteralToken literal = this.nextRegularExpressionLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private ParseTree parseArrayInitializer() {
        if (this.peekType(1) == TokenType.FOR) {
            return this.parseArrayComprehension();
        }
        return this.parseArrayLiteral();
    }

    private ParseTree parseGeneratorComprehension() {
        return this.parseComprehension(ComprehensionTree.ComprehensionType.GENERATOR, TokenType.OPEN_PAREN, TokenType.CLOSE_PAREN);
    }

    private ParseTree parseArrayComprehension() {
        return this.parseComprehension(ComprehensionTree.ComprehensionType.ARRAY, TokenType.OPEN_SQUARE, TokenType.CLOSE_SQUARE);
    }

    private ParseTree parseComprehension(ComprehensionTree.ComprehensionType type, TokenType startToken, TokenType endToken) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(startToken);
        ImmutableList.Builder children = ImmutableList.builder();
        while (this.peek(TokenType.FOR) || this.peek(TokenType.IF)) {
            if (this.peek(TokenType.FOR)) {
                children.add((Object)this.parseComprehensionFor());
                continue;
            }
            children.add((Object)this.parseComprehensionIf());
        }
        ParseTree tailExpression = this.parseAssignmentExpression();
        this.eat(endToken);
        return new ComprehensionTree(this.getTreeLocation(start), type, (ImmutableList<ParseTree>)children.build(), tailExpression);
    }

    private ParseTree parseComprehensionFor() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree initializer = this.peekId() ? this.parseIdentifierExpression() : this.parsePattern(PatternKind.ANY);
        this.eatPredefinedString("of");
        ParseTree collection = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ComprehensionForTree(this.getTreeLocation(start), initializer, collection);
    }

    private ParseTree parseComprehensionIf() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree initializer = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ComprehensionIfTree(this.getTreeLocation(start), initializer);
    }

    private ParseTree parseArrayLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        Token trailingCommaToken = null;
        while (this.peek(TokenType.COMMA) || this.peek(TokenType.SPREAD) || this.peekAssignmentExpression()) {
            trailingCommaToken = null;
            if (this.peek(TokenType.COMMA)) {
                elements.add((Object)new NullTree(this.getTreeLocation(this.getTreeStartLocation())));
            } else if (this.peek(TokenType.SPREAD)) {
                this.recordFeatureUsed(FeatureSet.Feature.SPREAD_EXPRESSIONS);
                elements.add((Object)this.parseSpreadExpression());
            } else {
                elements.add((Object)this.parseAssignmentExpression());
            }
            if (this.peek(TokenType.CLOSE_SQUARE)) continue;
            trailingCommaToken = this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_SQUARE);
        this.maybeReportTrailingComma(trailingCommaToken);
        return new ArrayLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder result = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        Token commaToken = null;
        while (this.peek(TokenType.SPREAD) || this.peekPropertyNameOrComputedProp(0) || this.peek(TokenType.STAR) || this.peekAccessibilityModifier()) {
            commaToken = null;
            result.add((Object)this.parsePropertyAssignment());
            commaToken = this.eatOpt(TokenType.COMMA);
            if (commaToken != null) continue;
        }
        this.eat(TokenType.CLOSE_CURLY);
        this.maybeReportTrailingComma(commaToken);
        return new ObjectLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)result.build());
    }

    void maybeReportTrailingComma(Token commaToken) {
        if (commaToken != null) {
            this.recordFeatureUsed(FeatureSet.Feature.TRAILING_COMMA);
            if (this.config.warnTrailingCommas) {
                this.errorReporter.reportWarning(commaToken.location.start, "Trailing comma is not legal in an ECMA-262 object initializer", new Object[0]);
            }
        }
    }

    private boolean peekPropertyNameOrComputedProp(int tokenIndex) {
        return this.peekPropertyName(tokenIndex) || this.peekType(tokenIndex) == TokenType.OPEN_SQUARE;
    }

    private boolean peekPropertyName(int tokenIndex) {
        TokenType type = this.peekType(tokenIndex);
        switch (type) {
            case IDENTIFIER: 
            case NUMBER: 
            case STRING: {
                return true;
            }
        }
        return Keywords.isKeyword(type);
    }

    private ParseTree parsePropertyAssignment() {
        TokenType type = this.peekType();
        if (type == TokenType.STAR) {
            return this.parsePropertyAssignmentGenerator();
        }
        if (this.peek(TokenType.SPREAD)) {
            this.recordFeatureUsed(FeatureSet.Feature.OBJECT_LITERALS_WITH_SPREAD);
            return this.parseSpreadExpression();
        }
        if (type == TokenType.STRING || type == TokenType.NUMBER || type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            if (this.peekGetAccessor()) {
                return this.parseGetAccessor();
            }
            if (this.peekSetAccessor()) {
                return this.parseSetAccessor();
            }
            if (this.peekAsyncMethod()) {
                return this.parseAsyncMethod();
            }
            if (this.peekType(1) == TokenType.OPEN_PAREN) {
                return this.parseClassMemberDeclaration();
            }
            return this.parsePropertyNameAssignment();
        }
        if (type == TokenType.OPEN_SQUARE) {
            SourcePosition start = this.getTreeStartLocation();
            ParseTree name = this.parseComputedPropertyName();
            if (this.peek(TokenType.COLON)) {
                this.eat(TokenType.COLON);
                ParseTree value = this.parseAssignmentExpression();
                return new ComputedPropertyDefinitionTree(this.getTreeLocation(start), name, value);
            }
            FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.EXPRESSION);
            this.parseFunctionTail(builder, FunctionFlavor.NORMAL);
            FunctionDeclarationTree value = builder.build(this.getTreeLocation(start));
            return new ComputedPropertyMethodTree(this.getTreeLocation(start), null, name, value);
        }
        throw new RuntimeException("unreachable");
    }

    private ParseTree parsePropertyAssignmentGenerator() {
        TokenType type = this.peekType(1);
        if (type == TokenType.STRING || type == TokenType.NUMBER || type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            return this.parseClassMemberDeclaration();
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.STAR);
        ParseTree name = this.parseComputedPropertyName();
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.EXPRESSION);
        this.parseFunctionTail(builder, FunctionFlavor.GENERATOR);
        FunctionDeclarationTree value = builder.build(this.getTreeLocation(start));
        return new ComputedPropertyMethodTree(this.getTreeLocation(start), null, name, value);
    }

    private ParseTree parseComputedPropertyName() {
        this.eat(TokenType.OPEN_SQUARE);
        ParseTree assign = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_SQUARE);
        return assign;
    }

    private boolean peekGetAccessor() {
        return this.peekPredefinedString("get") && this.peekPropertyNameOrComputedProp(1);
    }

    private boolean peekPredefinedString(String string) {
        return this.peekPredefinedString(0, string);
    }

    private Token eatPredefinedString(String string) {
        IdentifierToken token = this.eatId();
        if (token == null || !token.asIdentifier().value.equals(string)) {
            this.reportExpectedError(token, string);
            return null;
        }
        return token;
    }

    private boolean peekPredefinedString(int index, String string) {
        return this.peek(index, TokenType.IDENTIFIER) && ((IdentifierToken)this.peekToken((int)index)).value.equals(string);
    }

    private ParseTree parseGetAccessor() {
        return this.parseGetAccessor(this.getClassElementDefaults());
    }

    private ParseTree parseGetAccessor(PartialClassElement partial) {
        this.eatPredefinedString("get");
        if (this.peekPropertyName(0)) {
            Token propertyName = this.eatObjectLiteralPropertyName();
            this.eat(TokenType.OPEN_PAREN);
            this.eat(TokenType.CLOSE_PAREN);
            ParseTree returnType = this.maybeParseColonType();
            BlockTree body = this.parseFunctionBody();
            this.recordFeatureUsed(FeatureSet.Feature.GETTER);
            return new GetAccessorTree(this.getTreeLocation(partial.start), propertyName, partial.isStatic, returnType, body);
        }
        ParseTree property = this.parseComputedPropertyName();
        this.eat(TokenType.OPEN_PAREN);
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree returnType = this.maybeParseColonType();
        BlockTree body = this.parseFunctionBody();
        this.recordFeatureUsed(FeatureSet.Feature.GETTER);
        return new ComputedPropertyGetterTree(this.getTreeLocation(partial.start), property, partial.isStatic, partial.accessModifier, returnType, body);
    }

    private boolean peekSetAccessor() {
        return this.peekPredefinedString("set") && this.peekPropertyNameOrComputedProp(1);
    }

    private ParseTree parseSetAccessor() {
        return this.parseSetAccessor(this.getClassElementDefaults());
    }

    private ParseTree parseSetAccessor(PartialClassElement partial) {
        this.eatPredefinedString("set");
        if (this.peekPropertyName(0)) {
            Token propertyName = this.eatObjectLiteralPropertyName();
            FormalParameterListTree parameter = this.parseSetterParameterList();
            ParseTree returnType = this.maybeParseColonType();
            if (returnType != null) {
                this.reportError(this.scanner.peekToken(), "setter should not have any returns", new Object[0]);
            }
            BlockTree body = this.parseFunctionBody();
            this.recordFeatureUsed(FeatureSet.Feature.SETTER);
            return new SetAccessorTree(this.getTreeLocation(partial.start), propertyName, partial.isStatic, parameter, body);
        }
        ParseTree property = this.parseComputedPropertyName();
        FormalParameterListTree parameter = this.parseSetterParameterList();
        BlockTree body = this.parseFunctionBody();
        this.recordFeatureUsed(FeatureSet.Feature.SETTER);
        return new ComputedPropertySetterTree(this.getTreeLocation(partial.start), property, partial.isStatic, partial.accessModifier, parameter, body);
    }

    private ParseTree parsePropertyNameAssignment() {
        SourcePosition start = this.getTreeStartLocation();
        Token name = this.eatObjectLiteralPropertyName();
        Token colon = this.eatOpt(TokenType.COLON);
        if (colon == null) {
            if (name.type != TokenType.IDENTIFIER) {
                this.reportExpectedError(this.peekToken(), (Object)TokenType.COLON);
            } else if (Keywords.isKeyword(name.asIdentifier().value, false)) {
                this.reportError(name, "Cannot use keyword in short object literal", new Object[0]);
            } else if (this.peek(TokenType.EQUAL)) {
                IdentifierExpressionTree idTree = new IdentifierExpressionTree(this.getTreeLocation(start), (IdentifierToken)name);
                this.eat(TokenType.EQUAL);
                ParseTree defaultValue = this.parseAssignmentExpression();
                return new DefaultParameterTree(this.getTreeLocation(start), idTree, defaultValue);
            }
        }
        ParseTree value = colon == null ? null : this.parseAssignmentExpression();
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseCoverParenthesizedExpressionAndArrowParameterList() {
        if (this.peekType(1) == TokenType.FOR) {
            return this.parseGeneratorComprehension();
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        if (this.peek(TokenType.CLOSE_PAREN)) {
            this.eat(TokenType.CLOSE_PAREN);
            if (this.peek(TokenType.ARROW)) {
                return new FormalParameterListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)ImmutableList.of());
            }
            this.reportError("invalid parenthesized expression", new Object[0]);
            return new MissingPrimaryExpressionTree(this.getTreeLocation(start));
        }
        if (this.peek(TokenType.SPREAD)) {
            ImmutableList params = ImmutableList.of((Object)this.parseParameter(ParamContext.IMPLEMENTATION));
            this.eat(TokenType.CLOSE_PAREN);
            if (this.peek(TokenType.ARROW)) {
                return new FormalParameterListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)params);
            }
            this.reportError("invalid parenthesized expression", new Object[0]);
            return new MissingPrimaryExpressionTree(this.getTreeLocation(start));
        }
        ParseTree result = this.parseExpression();
        if (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            result = new CommaExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)ImmutableList.of((Object)result, (Object)this.parseParameter(ParamContext.IMPLEMENTATION)));
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new ParenExpressionTree(this.getTreeLocation(start), result);
    }

    private ParseTree parseMissingPrimaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.nextToken();
        this.reportError("primary expression expected", new Object[0]);
        return new MissingPrimaryExpressionTree(this.getTreeLocation(start));
    }

    private GenericTypeListTree maybeParseGenericTypes() {
        if (!this.peek(TokenType.OPEN_ANGLE)) {
            return null;
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_ANGLE);
        this.scanner.incTypeParameterLevel();
        LinkedHashMap<IdentifierToken, ParseTree> types = new LinkedHashMap<IdentifierToken, ParseTree>();
        do {
            IdentifierToken name = this.eatId();
            ParseTree bound = null;
            if (this.peek(TokenType.EXTENDS)) {
                this.eat(TokenType.EXTENDS);
                bound = this.parseType();
            }
            types.put(name, bound);
            if (!this.peek(TokenType.COMMA)) continue;
            this.eat(TokenType.COMMA);
        } while (this.peekId());
        this.eat(TokenType.CLOSE_ANGLE);
        this.scanner.decTypeParameterLevel();
        return new GenericTypeListTree(this.getTreeLocation(start), types);
    }

    private ParseTree maybeParseColonType() {
        ParseTree type = null;
        if (this.peek(TokenType.COLON)) {
            type = this.parseTypeAnnotation();
        }
        return type;
    }

    private ParseTree parseExpressionNoIn() {
        return this.parse(Expression.NO_IN);
    }

    private ParseTree parseExpression() {
        return this.parse(Expression.NORMAL);
    }

    private boolean peekExpression() {
        switch (this.peekType()) {
            case IDENTIFIER: 
            case FUNCTION: 
            case CLASS: 
            case MODULE: 
            case NAMESPACE: 
            case DECLARE: 
            case OPEN_CURLY: 
            case TYPE: 
            case NEW: 
            case OPEN_SQUARE: 
            case OPEN_PAREN: 
            case NUMBER: 
            case STRING: 
            case YIELD: 
            case THIS: 
            case SUPER: 
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: 
            case NULL: 
            case TRUE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case FALSE: 
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parse(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree result = this.parseAssignment(expressionIn);
        if (this.peek(TokenType.COMMA) && !this.peek(1, TokenType.SPREAD)) {
            ImmutableList.Builder exprs = ImmutableList.builder();
            exprs.add((Object)result);
            while (this.peek(TokenType.COMMA) && !this.peek(1, TokenType.SPREAD)) {
                this.eat(TokenType.COMMA);
                exprs.add((Object)this.parseAssignment(expressionIn));
            }
            return new CommaExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)exprs.build());
        }
        return result;
    }

    private ParseTree parseAssignmentExpression() {
        return this.parseAssignment(Expression.NORMAL);
    }

    private boolean peekAssignmentExpression() {
        return this.peekExpression();
    }

    private ParseTree parseAssignment(Expression expressionIn) {
        if (this.peek(TokenType.YIELD) && this.inGeneratorContext()) {
            return this.parseYield(expressionIn);
        }
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseConditional(expressionIn);
        if (this.isStartOfAsyncArrowFunction(left)) {
            this.resetScanner(left);
            return this.parseAsyncArrowFunction(expressionIn);
        }
        if (this.peek(TokenType.ARROW)) {
            return this.completeAssignmentExpressionParseAtArrow(left, expressionIn);
        }
        if (this.peekAssignmentOperator()) {
            if (!(left = this.transformLeftHandSideExpression(left)).isValidAssignmentTarget()) {
                this.reportError("invalid assignment target", new Object[0]);
            }
            Token operator = this.nextToken();
            ParseTree right = this.parseAssignment(expressionIn);
            return new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean isStartOfAsyncArrowFunction(ParseTree partialExpression) {
        if (partialExpression.type == ParseTreeType.IDENTIFIER_EXPRESSION) {
            IdentifierToken identifierToken = partialExpression.asIdentifierExpression().identifierToken;
            return identifierToken.value.equals(ASYNC) && !this.peekImplicitSemiColon(0) && this.peekId() && !this.peekImplicitSemiColon(1) && this.peek(1, TokenType.ARROW);
        }
        if (partialExpression.type == ParseTreeType.CALL_EXPRESSION) {
            CallExpressionTree callExpression = partialExpression.asCallExpression();
            ParseTree callee = callExpression.operand;
            ArgumentListTree arguments = callExpression.arguments;
            return callee.type == ParseTreeType.IDENTIFIER_EXPRESSION && callee.asIdentifierExpression().identifierToken.value.equals(ASYNC) && callee.location.end.line == arguments.location.start.line && !this.peekImplicitSemiColon() && this.peek(TokenType.ARROW);
        }
        return false;
    }

    private ParseTree completeAssignmentExpressionParseAtArrow(ParseTree leftOfArrow, Expression expressionIn) {
        if (leftOfArrow.type == ParseTreeType.CALL_EXPRESSION) {
            return this.completeAssignmentExpressionParseAtArrow(leftOfArrow.asCallExpression());
        }
        return this.completeArrowFunctionParseAtArrow(leftOfArrow, expressionIn);
    }

    private ParseTree completeArrowFunctionParseAtArrow(ParseTree leftOfArrow, Expression expressionIn) {
        FormalParameterListTree arrowFormalParameters = this.transformToArrowFormalParameters(leftOfArrow);
        if (this.peekImplicitSemiColon()) {
            this.reportError("No newline allowed before '=>'", new Object[0]);
        }
        this.eat(TokenType.ARROW);
        ParseTree arrowFunctionBody = this.parseArrowFunctionBody(expressionIn, FunctionFlavor.NORMAL);
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.ARROW).setFormalParameterList(arrowFormalParameters).setFunctionBody(arrowFunctionBody);
        return builder.build(this.getTreeLocation(arrowFormalParameters.location.start));
    }

    private FormalParameterListTree transformToArrowFormalParameters(ParseTree leftOfArrow) {
        FormalParameterListTree arrowParameterList;
        switch (leftOfArrow.type) {
            case FORMAL_PARAMETER_LIST: {
                arrowParameterList = leftOfArrow.asFormalParameterList();
                break;
            }
            case IDENTIFIER_EXPRESSION: {
                arrowParameterList = new FormalParameterListTree(leftOfArrow.location, (ImmutableList<ParseTree>)ImmutableList.of((Object)leftOfArrow));
                break;
            }
            case ARGUMENT_LIST: 
            case PAREN_EXPRESSION: {
                this.resetScanner(leftOfArrow);
                arrowParameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
                break;
            }
            default: {
                this.reportError(leftOfArrow, "invalid arrow function parameters", new Object[0]);
                arrowParameterList = Parser.newEmptyFormalParameterList(leftOfArrow.location);
            }
        }
        return arrowParameterList;
    }

    private ParseTree completeAssignmentExpressionParseAtArrow(CallExpressionTree callExpression) {
        ParseTree result;
        ParseTree operand = callExpression.operand;
        ArgumentListTree arguments = callExpression.arguments;
        if (operand.location.end.line < arguments.location.start.line) {
            this.resetScannerAfter(operand);
            result = operand;
        } else {
            this.reportError("'=>' unexpected", new Object[0]);
            result = callExpression;
        }
        return result;
    }

    private ParseTree parseAsyncArrowFunction(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        this.eatPredefinedString(ASYNC);
        if (this.peekImplicitSemiColon()) {
            this.reportError("No newline allowed between `async` and arrow function parameter list", new Object[0]);
        }
        FormalParameterListTree arrowParameterList = null;
        if (this.peek(TokenType.OPEN_PAREN)) {
            arrowParameterList = this.parseFormalParameterList(ParamContext.IMPLEMENTATION);
        } else {
            IdentifierExpressionTree singleParameter = this.parseIdentifierExpression();
            arrowParameterList = new FormalParameterListTree(singleParameter.location, (ImmutableList<ParseTree>)ImmutableList.of((Object)singleParameter));
        }
        if (this.peekImplicitSemiColon()) {
            this.reportError("No newline allowed before '=>'", new Object[0]);
        }
        this.eat(TokenType.ARROW);
        ParseTree arrowFunctionBody = this.parseArrowFunctionBody(expressionIn, FunctionFlavor.ASYNCHRONOUS);
        FunctionDeclarationTree.Builder builder = FunctionDeclarationTree.builder(FunctionDeclarationTree.Kind.ARROW).setAsync(true).setFormalParameterList(arrowParameterList).setFunctionBody(arrowFunctionBody);
        return builder.build(this.getTreeLocation(start));
    }

    private ParseTree parseArrowFunctionBody(Expression expressionIn, FunctionFlavor functionFlavor) {
        this.functionContextStack.addLast(functionFlavor);
        ParseTree arrowFunctionBody = this.peek(TokenType.OPEN_CURLY) ? this.parseFunctionBody() : this.parseAssignment(expressionIn);
        this.functionContextStack.removeLast();
        return arrowFunctionBody;
    }

    private static FormalParameterListTree newEmptyFormalParameterList(SourceRange location) {
        return new FormalParameterListTree(location, (ImmutableList<ParseTree>)ImmutableList.of());
    }

    private ParseTree transformLeftHandSideExpression(ParseTree tree) {
        switch (tree.type) {
            case ARRAY_LITERAL_EXPRESSION: 
            case OBJECT_LITERAL_EXPRESSION: {
                this.resetScanner(tree);
                return this.parseLeftHandSidePattern();
            }
        }
        return tree;
    }

    private ParseTree parseLeftHandSidePattern() {
        return this.parsePattern(PatternKind.ANY);
    }

    private void resetScanner(ParseTree tree) {
        this.lastSourcePosition = tree.location.start;
        this.scanner.setOffset(this.lastSourcePosition.offset);
    }

    private void resetScannerAfter(ParseTree parseTree) {
        this.lastSourcePosition = parseTree.location.end;
        this.scanner.setOffset(this.lastSourcePosition.offset);
    }

    private boolean peekAssignmentOperator() {
        switch (this.peekType()) {
            case SLASH_EQUAL: 
            case EQUAL: 
            case STAR_EQUAL: 
            case STAR_STAR_EQUAL: 
            case PERCENT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case LEFT_SHIFT_EQUAL: 
            case RIGHT_SHIFT_EQUAL: 
            case UNSIGNED_RIGHT_SHIFT_EQUAL: 
            case AMPERSAND_EQUAL: 
            case CARET_EQUAL: 
            case BAR_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private boolean inGeneratorContext() {
        return this.functionContextStack.peekLast().isGenerator;
    }

    private ParseTree parseYield(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.YIELD);
        boolean isYieldAll = false;
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            boolean bl = isYieldAll = this.eatOpt(TokenType.STAR) != null;
            if (this.peekAssignmentExpression()) {
                expression = this.parseAssignment(expressionIn);
            } else if (isYieldAll) {
                this.reportError("yield* requires an expression", new Object[0]);
            }
        }
        return new YieldExpressionTree(this.getTreeLocation(start), isYieldAll, expression);
    }

    private ParseTree parseConditional(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree condition = this.parseLogicalOR(expressionIn);
        if (this.peek(TokenType.QUESTION)) {
            this.eat(TokenType.QUESTION);
            ParseTree left = this.parseAssignment(expressionIn);
            this.eat(TokenType.COLON);
            ParseTree right = this.parseAssignment(expressionIn);
            return new ConditionalExpressionTree(this.getTreeLocation(start), condition, left, right);
        }
        return condition;
    }

    private ParseTree parseLogicalOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseLogicalAND(expressionIn);
        while (this.peek(TokenType.OR)) {
            Token operator = this.eat(TokenType.OR);
            ParseTree right = this.parseLogicalAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseLogicalAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseOR(expressionIn);
        while (this.peek(TokenType.AND)) {
            Token operator = this.eat(TokenType.AND);
            ParseTree right = this.parseBitwiseOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseXOR(expressionIn);
        while (this.peek(TokenType.BAR)) {
            Token operator = this.eat(TokenType.BAR);
            ParseTree right = this.parseBitwiseXOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseXOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseAND(expressionIn);
        while (this.peek(TokenType.CARET)) {
            Token operator = this.eat(TokenType.CARET);
            ParseTree right = this.parseBitwiseAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseEquality(expressionIn);
        while (this.peek(TokenType.AMPERSAND)) {
            Token operator = this.eat(TokenType.AMPERSAND);
            ParseTree right = this.parseEquality(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseEquality(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseRelational(expressionIn);
        while (this.peekEqualityOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseRelational(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekEqualityOperator() {
        switch (this.peekType()) {
            case EQUAL_EQUAL: 
            case NOT_EQUAL: 
            case EQUAL_EQUAL_EQUAL: 
            case NOT_EQUAL_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseRelational(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseShiftExpression();
        while (this.peekRelationalOperator(expressionIn)) {
            Token operator = this.nextToken();
            ParseTree right = this.parseShiftExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekRelationalOperator(Expression expressionIn) {
        switch (this.peekType()) {
            case OPEN_ANGLE: 
            case CLOSE_ANGLE: 
            case GREATER_EQUAL: 
            case LESS_EQUAL: 
            case INSTANCEOF: {
                return true;
            }
            case IN: {
                return expressionIn == Expression.NORMAL;
            }
        }
        return false;
    }

    private ParseTree parseShiftExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseAdditiveExpression();
        while (this.peekShiftOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseAdditiveExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekShiftOperator() {
        switch (this.peekType()) {
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseAdditiveExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseMultiplicativeExpression();
        while (this.peekAdditiveOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseMultiplicativeExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAdditiveOperator() {
        switch (this.peekType()) {
            case PLUS: 
            case MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseMultiplicativeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseExponentiationExpression();
        while (this.peekMultiplicativeOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseExponentiationExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekMultiplicativeOperator() {
        switch (this.peekType()) {
            case STAR: 
            case SLASH: 
            case PERCENT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseExponentiationExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseUnaryExpression();
        if (this.peek(TokenType.STAR_STAR)) {
            if (left.type == ParseTreeType.UNARY_EXPRESSION) {
                this.reportError("Unary operator '%s' requires parentheses before '**'", left.asUnaryExpression().operator);
            }
            Token operator = this.nextToken();
            ParseTree right = this.parseExponentiationExpression();
            return new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseUnaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekUnaryOperator()) {
            Token operator = this.nextToken();
            ParseTree operand = this.parseUnaryExpression();
            return new UnaryExpressionTree(this.getTreeLocation(start), operator, operand);
        }
        if (this.peekAwaitExpression()) {
            return this.parseAwaitExpression();
        }
        return this.parseUpdateExpression();
    }

    private boolean peekUnaryOperator() {
        switch (this.peekType()) {
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private boolean peekAwaitExpression() {
        return this.peekPredefinedString(AWAIT);
    }

    private ParseTree parseAwaitExpression() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.functionContextStack.isEmpty() || !this.functionContextStack.peekLast().isAsynchronous) {
            this.reportError("'await' used in a non-async function context", new Object[0]);
        }
        this.eatPredefinedString(AWAIT);
        ParseTree expression = this.parseUnaryExpression();
        return new AwaitExpressionTree(this.getTreeLocation(start), expression);
    }

    private ParseTree parseUpdateExpression() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekUpdateOperator()) {
            Token operator = this.nextToken();
            ParseTree operand = this.parseUnaryExpression();
            return UpdateExpressionTree.prefix(this.getTreeLocation(start), operator, operand);
        }
        ParseTree lhs = this.parseLeftHandSideExpression();
        if (this.peekUpdateOperator() && !this.peekImplicitSemiColon()) {
            Token operator = this.nextToken();
            return UpdateExpressionTree.postfix(this.getTreeLocation(start), operator, lhs);
        }
        return lhs;
    }

    private boolean peekUpdateOperator() {
        switch (this.peekType()) {
            case PLUS_PLUS: 
            case MINUS_MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseLeftHandSideExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseNewExpression();
        if (!(operand instanceof NewExpressionTree) || ((NewExpressionTree)operand).arguments != null) {
            block6: while (this.peekCallSuffix()) {
                switch (this.peekType()) {
                    case OPEN_PAREN: {
                        ArgumentListTree arguments = this.parseArguments();
                        operand = new CallExpressionTree(this.getTreeLocation(start), operand, arguments);
                        continue block6;
                    }
                    case OPEN_SQUARE: {
                        this.eat(TokenType.OPEN_SQUARE);
                        ParseTree member = this.parseExpression();
                        this.eat(TokenType.CLOSE_SQUARE);
                        operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                        continue block6;
                    }
                    case PERIOD: {
                        this.eat(TokenType.PERIOD);
                        IdentifierToken id = this.eatIdOrKeywordAsId();
                        operand = new MemberExpressionTree(this.getTreeLocation(start), operand, id);
                        continue block6;
                    }
                    case NO_SUBSTITUTION_TEMPLATE: 
                    case TEMPLATE_HEAD: {
                        operand = this.parseTemplateLiteral(operand);
                        continue block6;
                    }
                }
                throw new AssertionError((Object)("unexpected case: " + (Object)((Object)this.peekType())));
            }
        }
        return operand;
    }

    private boolean peekCallSuffix() {
        return this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD) || this.peek(TokenType.NO_SUBSTITUTION_TEMPLATE) || this.peek(TokenType.TEMPLATE_HEAD);
    }

    private ParseTree parseMemberExpressionNoNew() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.peekAsyncFunctionStart() ? this.parseAsyncFunctionExpression() : (this.peekFunction() ? this.parseFunctionExpression() : this.parsePrimaryExpression());
        block5: while (this.peekMemberExpressionSuffix()) {
            switch (this.peekType()) {
                case OPEN_SQUARE: {
                    this.eat(TokenType.OPEN_SQUARE);
                    ParseTree member = this.parseExpression();
                    this.eat(TokenType.CLOSE_SQUARE);
                    operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                    continue block5;
                }
                case PERIOD: {
                    this.eat(TokenType.PERIOD);
                    IdentifierToken id = this.eatIdOrKeywordAsId();
                    operand = new MemberExpressionTree(this.getTreeLocation(start), operand, id);
                    continue block5;
                }
                case NO_SUBSTITUTION_TEMPLATE: 
                case TEMPLATE_HEAD: {
                    operand = this.parseTemplateLiteral(operand);
                    continue block5;
                }
            }
            throw new RuntimeException("unreachable");
        }
        return operand;
    }

    private boolean peekMemberExpressionSuffix() {
        return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD) || this.peek(TokenType.NO_SUBSTITUTION_TEMPLATE) || this.peek(TokenType.TEMPLATE_HEAD);
    }

    private ParseTree parseNewExpression() {
        if (!this.peek(TokenType.NEW)) {
            return this.parseMemberExpressionNoNew();
        }
        if (this.peek(1, TokenType.PERIOD)) {
            return this.parseNewDotSomething();
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.NEW);
        ParseTree operand = this.parseNewExpression();
        ArgumentListTree arguments = null;
        if (this.peek(TokenType.OPEN_PAREN)) {
            arguments = this.parseArguments();
        }
        return new NewExpressionTree(this.getTreeLocation(start), operand, arguments);
    }

    private ParseTree parseNewDotSomething() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.NEW);
        this.eat(TokenType.PERIOD);
        this.eatPredefinedString("target");
        return new NewTargetExpressionTree(this.getTreeLocation(start));
    }

    private ArgumentListTree parseArguments() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.eat(TokenType.OPEN_PAREN);
        while (this.peekAssignmentOrSpread()) {
            arguments.add((Object)this.parseAssignmentOrSpread());
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            Token comma = this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_PAREN)) continue;
            this.recordFeatureUsed(FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST);
            if (this.config.atLeast8) continue;
            this.reportError(comma, "Invalid trailing comma in arguments list", new Object[0]);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new ArgumentListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)arguments.build());
    }

    private boolean peekAssignmentOrSpread() {
        return this.peek(TokenType.SPREAD) || this.peekAssignmentExpression();
    }

    private ParseTree parseAssignmentOrSpread() {
        if (this.peek(TokenType.SPREAD)) {
            return this.parseSpreadExpression();
        }
        return this.parseAssignmentExpression();
    }

    private boolean peekPatternStart() {
        return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.OPEN_CURLY);
    }

    private ParseTree parsePattern(PatternKind kind) {
        switch (this.peekType()) {
            case OPEN_SQUARE: {
                return this.parseArrayPattern(kind);
            }
        }
        return this.parseObjectPattern(kind);
    }

    private boolean peekArrayPatternElement() {
        return this.peekExpression();
    }

    private ParseTree parsePatternRest(PatternKind patternKind) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SPREAD);
        ParseTree patternAssignmentTarget = this.parseRestAssignmentTarget(patternKind);
        return new AssignmentRestElementTree(this.getTreeLocation(start), patternAssignmentTarget);
    }

    private ParseTree parseRestAssignmentTarget(PatternKind patternKind) {
        ParseTree patternAssignmentTarget = this.parsePatternAssignmentTargetNoDefault(patternKind);
        if (this.peek(TokenType.EQUAL)) {
            this.reportError("A default value cannot be specified after '...'", new Object[0]);
        }
        return patternAssignmentTarget;
    }

    private ParseTree parseArrayPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        while (this.peek(TokenType.COMMA) || this.peekArrayPatternElement()) {
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                elements.add((Object)new NullTree(this.getTreeLocation(this.getTreeStartLocation())));
                continue;
            }
            elements.add((Object)this.parsePatternAssignmentTarget(kind));
            if (!this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
        }
        if (this.peek(TokenType.SPREAD)) {
            this.recordFeatureUsed(FeatureSet.Feature.ARRAY_PATTERN_REST);
            elements.add((Object)this.parsePatternRest(kind));
        }
        this.eat(TokenType.CLOSE_SQUARE);
        return new ArrayPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder fields = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekObjectPatternField()) {
            fields.add((Object)this.parseObjectPatternField(kind));
            if (!this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
        }
        if (this.peek(TokenType.SPREAD)) {
            this.recordFeatureUsed(FeatureSet.Feature.OBJECT_PATTERN_REST);
            fields.add((Object)this.parsePatternRest(kind));
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new ObjectPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)fields.build());
    }

    private boolean peekObjectPatternField() {
        return this.peekPropertyNameOrComputedProp(0);
    }

    private ParseTree parseObjectPatternField(PatternKind kind) {
        Token name;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekType() == TokenType.OPEN_SQUARE) {
            ParseTree key = this.parseComputedPropertyName();
            this.eat(TokenType.COLON);
            ParseTree value = this.parsePatternAssignmentTarget(kind);
            return new ComputedPropertyDefinitionTree(this.getTreeLocation(start), key, value);
        }
        if (this.peekIdOrKeyword()) {
            name = this.eatIdOrKeywordAsId();
            if (!this.peek(TokenType.COLON)) {
                Token idToken = name;
                if (Keywords.isKeyword(idToken.value, false)) {
                    this.reportError("cannot use keyword '%s' here.", name);
                }
                if (this.peek(TokenType.EQUAL)) {
                    IdentifierExpressionTree idTree = new IdentifierExpressionTree(this.getTreeLocation(start), (IdentifierToken)idToken);
                    this.eat(TokenType.EQUAL);
                    ParseTree defaultValue = this.parseAssignmentExpression();
                    return new DefaultParameterTree(this.getTreeLocation(start), idTree, defaultValue);
                }
                return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, null);
            }
        } else {
            name = this.parseLiteralExpression().literalToken;
        }
        this.eat(TokenType.COLON);
        ParseTree value = this.parsePatternAssignmentTarget(kind);
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parsePatternAssignmentTarget(PatternKind patternKind) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree assignmentTarget = this.parsePatternAssignmentTargetNoDefault(patternKind);
        if (this.peek(TokenType.EQUAL)) {
            this.eat(TokenType.EQUAL);
            ParseTree defaultValue = this.parseAssignmentExpression();
            assignmentTarget = new DefaultParameterTree(this.getTreeLocation(start), assignmentTarget, defaultValue);
        }
        return assignmentTarget;
    }

    private ParseTree parsePatternAssignmentTargetNoDefault(PatternKind kind) {
        ParseTree assignmentTarget;
        if (this.peekPatternStart()) {
            assignmentTarget = this.parsePattern(kind);
        } else {
            assignmentTarget = this.parseLeftHandSideExpression();
            if (!assignmentTarget.isValidAssignmentTarget()) {
                this.reportError("invalid assignment target", new Object[0]);
            }
            if (kind == PatternKind.INITIALIZER && assignmentTarget.type != ParseTreeType.IDENTIFIER_EXPRESSION) {
                this.reportError("Only an identifier or destructuring pattern is allowed here.", new Object[0]);
            }
        }
        return assignmentTarget;
    }

    private ParseTree parseTypeAlias() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.TYPE);
        IdentifierToken alias = this.eatId();
        this.eat(TokenType.EQUAL);
        ParseTree original = this.parseType();
        this.eatPossibleImplicitSemiColon();
        return new TypeAliasTree(this.getTreeLocation(start), alias, original);
    }

    private ParseTree parseAmbientDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DECLARE);
        ParseTree declare = this.parseAmbientDeclarationHelper();
        return new AmbientDeclarationTree(this.getTreeLocation(start), declare);
    }

    private ParseTree parseAmbientDeclarationHelper() {
        ParseTree declare;
        switch (this.peekType()) {
            case FUNCTION: {
                declare = this.parseAmbientFunctionDeclaration();
                this.eatPossibleImplicitSemiColon();
                break;
            }
            case CLASS: {
                declare = this.parseClassDeclaration(true);
                break;
            }
            case ENUM: {
                declare = this.parseEnumDeclaration();
                break;
            }
            case MODULE: 
            case NAMESPACE: {
                declare = this.parseNamespaceDeclaration(true);
                break;
            }
            default: {
                declare = this.parseAmbientVariableDeclarationList();
                this.eatPossibleImplicitSemiColon();
            }
        }
        return declare;
    }

    private void eatPossibleImplicitSemiColon() {
        if (this.peek(TokenType.SEMI_COLON) && this.peekToken().location.start.line == this.getLastLine()) {
            this.eat(TokenType.SEMI_COLON);
            return;
        }
        if (this.peekImplicitSemiColon()) {
            return;
        }
        this.reportError("Semi-colon expected", new Object[0]);
    }

    private boolean peekImplicitSemiColon() {
        return this.peekImplicitSemiColon(0);
    }

    private boolean peekImplicitSemiColon(int index) {
        boolean lineAdvanced = index == 0 ? this.getNextLine() > this.getLastLine() : this.peekToken((int)index).location.start.line > this.peekToken((int)(index - 1)).location.end.line;
        return lineAdvanced || this.peek(index, TokenType.SEMI_COLON) || this.peek(index, TokenType.CLOSE_CURLY) || this.peek(index, TokenType.END_OF_FILE);
    }

    private int getLastLine() {
        return this.lastSourcePosition.line;
    }

    private int getNextLine() {
        return this.peekToken().location.start.line;
    }

    private Token eatOpt(TokenType expectedTokenType) {
        if (this.peek(expectedTokenType)) {
            return this.eat(expectedTokenType);
        }
        return null;
    }

    private boolean inStrictContext() {
        return this.config.isStrictMode;
    }

    private boolean peekId() {
        return this.peekId(0);
    }

    private boolean peekId(int index) {
        TokenType type = this.peekType(index);
        return TokenType.IDENTIFIER == type || this.config.parseTypeSyntax && Keywords.isTypeScriptSpecificKeyword(type) || !this.inStrictContext() && Keywords.isStrictKeyword(type);
    }

    private boolean peekIdOrKeyword() {
        TokenType type = this.peekType();
        return TokenType.IDENTIFIER == type || Keywords.isKeyword(type);
    }

    private boolean peekAccessibilityModifier() {
        return EnumSet.of(TokenType.PUBLIC, TokenType.PROTECTED, TokenType.PRIVATE).contains((Object)this.peekType());
    }

    private TokenType maybeParseAccessibilityModifier() {
        if (this.config.parseTypeSyntax && this.peekAccessibilityModifier()) {
            return this.nextToken().type;
        }
        return null;
    }

    private IdentifierToken eatIdOpt() {
        return this.peekId() ? this.eatIdOrKeywordAsId() : null;
    }

    private IdentifierToken eatId() {
        if (this.peekId()) {
            return this.eatIdOrKeywordAsId();
        }
        this.reportExpectedError(this.peekToken(), (Object)TokenType.IDENTIFIER);
        if (this.peekIdOrKeyword()) {
            return this.eatIdOrKeywordAsId();
        }
        return null;
    }

    private Token eatObjectLiteralPropertyName() {
        Token token = this.peekToken();
        switch (token.type) {
            case NUMBER: 
            case STRING: {
                return this.nextToken();
            }
        }
        return this.eatIdOrKeywordAsId();
    }

    private IdentifierToken eatIdOrKeywordAsId() {
        Token token = this.nextToken();
        if (token.type == TokenType.IDENTIFIER) {
            return (IdentifierToken)token;
        }
        if (Keywords.isKeyword(token.type)) {
            return new IdentifierToken(token.location, Keywords.get(token.type).toString());
        }
        this.reportExpectedError(token, (Object)TokenType.IDENTIFIER);
        return null;
    }

    private Token eat(TokenType expectedTokenType) {
        Token token = this.nextToken();
        if (token.type != expectedTokenType) {
            this.reportExpectedError(token, (Object)expectedTokenType);
            return null;
        }
        return token;
    }

    private void reportExpectedError(Token token, Object expected) {
        this.reportError(token, "'%s' expected", expected);
    }

    private SourcePosition getTreeStartLocation() {
        return this.peekToken().location.start;
    }

    private SourcePosition getTreeEndLocation() {
        return this.lastSourcePosition;
    }

    private SourceRange getTreeLocation(SourcePosition start) {
        return new SourceRange(start, this.getTreeEndLocation());
    }

    private Token nextToken() {
        Token token = this.scanner.nextToken();
        this.lastSourcePosition = token.location.end;
        return token;
    }

    private LiteralToken nextRegularExpressionLiteralToken() {
        LiteralToken token = this.scanner.nextRegularExpressionLiteralToken();
        this.lastSourcePosition = token.location.end;
        return token;
    }

    private LiteralToken nextTemplateLiteralToken() {
        LiteralToken token = this.scanner.nextTemplateLiteralToken();
        this.lastSourcePosition = token.location.end;
        return token;
    }

    private boolean peek(TokenType expectedType) {
        return this.peek(0, expectedType);
    }

    private boolean peek(int index, TokenType expectedType) {
        return this.peekType(index) == expectedType;
    }

    private TokenType peekType() {
        return this.peekType(0);
    }

    private TokenType peekType(int index) {
        return this.peekToken((int)index).type;
    }

    private Token peekToken() {
        return this.peekToken(0);
    }

    private Token peekToken(int index) {
        return this.scanner.peekToken(index);
    }

    @Deprecated
    private Parser createLookaheadParser() {
        return new Parser(this.config, new LookaheadErrorReporter(), this.scanner.getFile(), this.scanner.getOffset(), this.inGeneratorContext());
    }

    @FormatMethod
    private void reportError(Token token, @FormatString String message, Object ... arguments) {
        if (token == null) {
            this.reportError(message, arguments);
        } else {
            this.errorReporter.reportError(token.getStart(), message, arguments);
        }
    }

    @FormatMethod
    private void reportError(ParseTree parseTree, @FormatString String message, Object ... arguments) {
        if (parseTree == null) {
            this.reportError(message, arguments);
        } else {
            this.errorReporter.reportError(parseTree.location.start, message, arguments);
        }
    }

    @FormatMethod
    private void reportError(@FormatString String message, Object ... arguments) {
        this.errorReporter.reportError(this.scanner.getPosition(), message, arguments);
    }

    private Parser recordFeatureUsed(FeatureSet.Feature feature) {
        this.features = this.features.with(feature);
        return this;
    }

    private static enum PatternKind {
        INITIALIZER,
        ANY;

    }

    private static enum Expression {
        NO_IN,
        NORMAL;

    }

    private static enum ParamContext {
        IMPLEMENTATION,
        SIGNATURE,
        TYPE_EXPRESSION;

    }

    private static class PartialClassElement {
        final SourcePosition start;
        boolean isAmbient = false;
        boolean isStatic = false;
        TokenType accessModifier = null;

        PartialClassElement(SourcePosition start) {
            this.start = start;
        }
    }

    private class CommentRecorder
    implements Scanner.CommentRecorder {
        private final ImmutableList.Builder<Comment> comments = ImmutableList.builder();

        private CommentRecorder() {
        }

        @Override
        public void recordComment(Comment.Type type, SourceRange range, String value) {
            if ((value = value.trim()).startsWith(Parser.SOURCE_MAPPING_URL_PREFIX)) {
                Parser.this.sourceMapURL = value.substring(Parser.SOURCE_MAPPING_URL_PREFIX.length());
            }
            this.comments.add((Object)new Comment(value, range, type));
        }

        private ImmutableList<Comment> getComments() {
            return this.comments.build();
        }
    }

    public static class Config {
        private final boolean parseTypeSyntax;
        private final boolean atLeast6;
        private final boolean atLeast8;
        private final boolean isStrictMode;
        private final boolean warnTrailingCommas;

        public Config() {
            this(Mode.ES8_OR_GREATER, false);
        }

        public Config(Mode mode, boolean isStrictMode) {
            this.parseTypeSyntax = mode == Mode.TYPESCRIPT;
            this.atLeast6 = mode != Mode.ES3 && mode != Mode.ES5;
            this.atLeast8 = mode == Mode.ES8_OR_GREATER || mode == Mode.ES_NEXT;
            this.isStrictMode = isStrictMode;
            this.warnTrailingCommas = mode == Mode.ES3;
        }

        public static enum Mode {
            ES3,
            ES5,
            ES6_OR_ES7,
            ES8_OR_GREATER,
            ES_NEXT,
            TYPESCRIPT;

        }
    }

    private static enum FunctionFlavor {
        NORMAL(false, false),
        GENERATOR(true, false),
        ASYNCHRONOUS(false, true),
        ASYNCHRONOUS_GENERATOR(true, true);

        final boolean isGenerator;
        final boolean isAsynchronous;

        private FunctionFlavor(boolean isGenerator, boolean isAsynchronous) {
            this.isGenerator = isGenerator;
            this.isAsynchronous = isAsynchronous;
        }
    }
}

