package com.google.javascript.jscomp.serialization;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SerializationOptions extends SerializationOptions {

  private final boolean includeDebugInfo;

  private final boolean runValidation;

  private final ImmutableList<String> runtimeLibraries;

  private AutoValue_SerializationOptions(
      boolean includeDebugInfo,
      boolean runValidation,
      ImmutableList<String> runtimeLibraries) {
    this.includeDebugInfo = includeDebugInfo;
    this.runValidation = runValidation;
    this.runtimeLibraries = runtimeLibraries;
  }

  @Override
  public boolean getIncludeDebugInfo() {
    return includeDebugInfo;
  }

  @Override
  public boolean getRunValidation() {
    return runValidation;
  }

  @Override
  public ImmutableList<String> getRuntimeLibraries() {
    return runtimeLibraries;
  }

  @Override
  public String toString() {
    return "SerializationOptions{"
        + "includeDebugInfo=" + includeDebugInfo + ", "
        + "runValidation=" + runValidation + ", "
        + "runtimeLibraries=" + runtimeLibraries
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SerializationOptions) {
      SerializationOptions that = (SerializationOptions) o;
      return this.includeDebugInfo == that.getIncludeDebugInfo()
          && this.runValidation == that.getRunValidation()
          && this.runtimeLibraries.equals(that.getRuntimeLibraries());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= includeDebugInfo ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= runValidation ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= runtimeLibraries.hashCode();
    return h$;
  }

  static final class Builder extends SerializationOptions.Builder {
    private boolean includeDebugInfo;
    private boolean runValidation;
    private ImmutableList<String> runtimeLibraries;
    private byte set$0;
    Builder() {
    }
    @Override
    public SerializationOptions.Builder setIncludeDebugInfo(boolean includeDebugInfo) {
      this.includeDebugInfo = includeDebugInfo;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public SerializationOptions.Builder setRunValidation(boolean runValidation) {
      this.runValidation = runValidation;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public SerializationOptions.Builder setRuntimeLibraries(ImmutableList<String> runtimeLibraries) {
      if (runtimeLibraries == null) {
        throw new NullPointerException("Null runtimeLibraries");
      }
      this.runtimeLibraries = runtimeLibraries;
      return this;
    }
    @Override
    public SerializationOptions build() {
      if (set$0 != 3
          || this.runtimeLibraries == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" includeDebugInfo");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" runValidation");
        }
        if (this.runtimeLibraries == null) {
          missing.append(" runtimeLibraries");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SerializationOptions(
          this.includeDebugInfo,
          this.runValidation,
          this.runtimeLibraries);
    }
  }

}
