/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.inversoft.rest.RESTClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class FormDataBodyHandler
implements RESTClient.BodyHandler {
    public Map<String, String> request;
    private byte[] body;

    public FormDataBodyHandler(Map<String, String> request) {
        this.request = request;
    }

    @Override
    public void accept(OutputStream os) throws IOException {
        if (this.body != null && os != null) {
            os.write(this.body);
        }
    }

    @Override
    public byte[] getBody() {
        if (this.request != null) {
            this.serializeRequest();
        }
        return this.body;
    }

    @Override
    public Object getBodyObject() {
        return this.request;
    }

    @Override
    public void setHeaders(HttpURLConnection huc) {
        if (this.request != null) {
            this.serializeRequest();
            huc.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    private void serializeRequest() {
        if (this.body == null) {
            StringBuilder build = new StringBuilder();
            this.request.forEach((key, value) -> {
                if (build.length() > 0) {
                    build.append("&");
                }
                try {
                    build.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            });
            this.body = build.toString().getBytes(StandardCharsets.UTF_8);
        }
    }
}

