/*
 * Decompiled with CFR 0.152.
 */
package com.inversoft.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.inversoft.json.JacksonModule;
import com.inversoft.rest.JSONException;
import com.inversoft.rest.RESTClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class JSONBodyHandler
implements RESTClient.BodyHandler {
    public static final ObjectMapper defaultObjectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false).registerModule((Module)new JacksonModule());
    private final ObjectMapper instanceObjectMapper;
    public Object request;
    private byte[] body;

    public JSONBodyHandler(Object request) {
        this.request = request;
        this.instanceObjectMapper = defaultObjectMapper;
    }

    public JSONBodyHandler(Object request, ObjectMapper objectMapper) {
        this.request = request;
        this.instanceObjectMapper = objectMapper;
    }

    @Override
    public void accept(OutputStream os) throws IOException {
        if (this.body != null && os != null) {
            os.write(this.body);
        }
    }

    @Override
    public byte[] getBody() {
        this.serializeRequest();
        return this.body;
    }

    @Override
    public Object getBodyObject() {
        return this.request;
    }

    @Override
    public void setHeaders(HttpURLConnection huc) {
        if (this.request != null) {
            this.serializeRequest();
            huc.addRequestProperty("Content-Type", "application/json");
            huc.addRequestProperty("Content-Length", "" + this.body.length);
        }
    }

    private void serializeRequest() {
        if (this.request != null && this.body == null) {
            try {
                this.body = this.instanceObjectMapper.writeValueAsBytes(this.request);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
    }
}

