/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramDescriptor;
import com.itextpdf.io.font.FontProgramDescriptorFactory;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.TrueTypeCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FontRegisterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontRegisterProvider.class);
    private final Map<String, String> fontNames = new HashMap<String, String>();
    private final Map<String, List<String>> fontFamilies = new HashMap<String, List<String>>();

    FontRegisterProvider() {
        this.registerStandardFonts();
        this.registerStandardFontFamilies();
    }

    FontProgram getFont(String fontName, int style) throws IOException {
        return this.getFont(fontName, style, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FontProgram getFont(String fontName, int style, boolean cached) throws IOException {
        List<String> family;
        if (fontName == null) {
            return null;
        }
        String lowerCaseFontName = fontName.toLowerCase();
        List<String> list = family = !lowerCaseFontName.equalsIgnoreCase("Times-Roman") ? this.fontFamilies.get(lowerCaseFontName) : this.fontFamilies.get("Times".toLowerCase());
        if (family != null) {
            List<String> list2 = family;
            synchronized (list2) {
                int s = style == -1 ? 0 : style;
                for (String f : family) {
                    String lcf = f.toLowerCase();
                    int fs = 0;
                    if (lcf.contains("bold")) {
                        fs |= 1;
                    }
                    if (lcf.contains("italic") || lcf.contains("oblique")) {
                        fs |= 2;
                    }
                    if ((s & 3) != fs) continue;
                    fontName = f;
                    break;
                }
            }
        }
        return this.getFontProgram(fontName, cached);
    }

    protected void registerStandardFonts() {
        this.fontNames.put("Courier".toLowerCase(), "Courier");
        this.fontNames.put("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.fontNames.put("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.fontNames.put("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.fontNames.put("Helvetica".toLowerCase(), "Helvetica");
        this.fontNames.put("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.fontNames.put("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.fontNames.put("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.fontNames.put("Symbol".toLowerCase(), "Symbol");
        this.fontNames.put("Times-Roman".toLowerCase(), "Times-Roman");
        this.fontNames.put("Times-Bold".toLowerCase(), "Times-Bold");
        this.fontNames.put("Times-Italic".toLowerCase(), "Times-Italic");
        this.fontNames.put("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.fontNames.put("ZapfDingbats".toLowerCase(), "ZapfDingbats");
    }

    protected void registerStandardFontFamilies() {
        ArrayList<String> family = new ArrayList<String>();
        family.add("Courier");
        family.add("Courier-Bold");
        family.add("Courier-Oblique");
        family.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), family);
        family = new ArrayList();
        family.add("Helvetica");
        family.add("Helvetica-Bold");
        family.add("Helvetica-Oblique");
        family.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), family);
        family = new ArrayList();
        family.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), family);
        family = new ArrayList();
        family.add("Times-Roman");
        family.add("Times-Bold");
        family.add("Times-Italic");
        family.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), family);
        family = new ArrayList();
        family.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), family);
    }

    protected FontProgram getFontProgram(String fontName, boolean cached) throws IOException {
        FontProgram fontProgram = null;
        if ((fontName = this.fontNames.get(fontName.toLowerCase())) != null) {
            fontProgram = FontProgramFactory.createFont(fontName, cached);
        }
        return fontProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerFontFamily(String familyName, String fullName, String path) {
        List<String> family;
        if (path != null) {
            this.fontNames.put(fullName, path);
        }
        Object object = this.fontFamilies;
        synchronized (object) {
            family = this.fontFamilies.get(familyName);
            if (family == null) {
                family = new ArrayList<String>();
                this.fontFamilies.put(familyName, family);
            }
        }
        object = family;
        synchronized (object) {
            if (!family.contains(fullName)) {
                int fullNameLength = fullName.length();
                boolean inserted = false;
                for (int j = 0; j < family.size(); ++j) {
                    if (family.get(j).length() < fullNameLength) continue;
                    family.add(j, fullName);
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    family.add(fullName);
                    String newFullName = fullName.toLowerCase();
                    if (newFullName.endsWith("regular")) {
                        newFullName = newFullName.substring(0, newFullName.length() - 7).trim();
                        family.add(0, fullName.substring(0, newFullName.length()));
                    }
                }
            }
        }
    }

    void registerFont(String path) {
        this.registerFont(path, null);
    }

    void registerFont(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                FontProgramDescriptor descriptor = FontProgramDescriptorFactory.fetchDescriptor(path);
                this.fontNames.put(descriptor.getFontNameLowerCase(), path);
                if (alias != null) {
                    Iterator<String> lcAlias = alias.toLowerCase();
                    this.fontNames.put((String)((Object)lcAlias), path);
                    if (((String)((Object)lcAlias)).endsWith("regular")) {
                        this.saveCopyOfRegularFont((String)((Object)lcAlias), path);
                    }
                }
                for (String name : descriptor.getFullNameAllLangs()) {
                    this.fontNames.put(name, path);
                    if (!name.endsWith("regular")) continue;
                    this.saveCopyOfRegularFont(name, path);
                }
                if (descriptor.getFamilyNameEnglishOpenType() != null) {
                    for (String fullName : descriptor.getFullNamesEnglishOpenType()) {
                        this.registerFontFamily(descriptor.getFamilyNameEnglishOpenType(), fullName, null);
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(path);
                for (int i = 0; i < ttc.getTTCSize(); ++i) {
                    String fullPath = path + "," + i;
                    if (alias != null) {
                        this.registerFont(fullPath, alias + "," + i);
                        continue;
                    }
                    this.registerFont(fullPath);
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                FontProgramDescriptor descriptor = FontProgramDescriptorFactory.fetchDescriptor(path);
                this.registerFontFamily(descriptor.getFamilyNameLowerCase(), descriptor.getFullNameLowerCase(), null);
                this.fontNames.put(descriptor.getFontNameLowerCase(), path);
                this.fontNames.put(descriptor.getFullNameLowerCase(), path);
            }
            LOGGER.trace(MessageFormatUtil.format((String)"Registered {0}", (Object[])new Object[]{path}));
        }
        catch (IOException e) {
            throw new com.itextpdf.io.exceptions.IOException(e);
        }
    }

    boolean saveCopyOfRegularFont(String regularFontName, String path) {
        String alias = regularFontName.substring(0, regularFontName.length() - 7).trim();
        if (!this.fontNames.containsKey(alias)) {
            this.fontNames.put(alias, path);
            return true;
        }
        return false;
    }

    int registerFontDirectory(String dir) {
        return this.registerFontDirectory(dir, false);
    }

    int registerFontDirectory(String dir, boolean scanSubdirectories) {
        LOGGER.debug(MessageFormatUtil.format((String)"Registering directory {0}, looking for fonts", (Object[])new Object[]{dir}));
        int count = 0;
        try {
            String[] files = FileUtil.listFilesInDirectory((String)dir, (boolean)scanSubdirectories);
            if (files == null) {
                return 0;
            }
            for (String file : files) {
                try {
                    String suffix;
                    String string = suffix = file.length() < 4 ? null : file.substring(file.length() - 4).toLowerCase();
                    if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                        String pfb = file.substring(0, file.length() - 4) + ".pfb";
                        if (!FileUtil.fileExists((String)pfb)) continue;
                        this.registerFont(file, null);
                        ++count;
                        continue;
                    }
                    if (!".ttf".equals(suffix) && !".otf".equals(suffix) && !".ttc".equals(suffix)) continue;
                    this.registerFont(file, null);
                    ++count;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    int registerSystemFontDirectories() {
        String[] withoutSubDirs;
        String[] withSubDirs;
        int count = 0;
        for (String directory : withSubDirs = new String[]{FileUtil.getFontsDir(), "/usr/share/X11/fonts", "/usr/X/lib/X11/fonts", "/usr/openwin/lib/X11/fonts", "/usr/share/fonts", "/usr/X11R6/lib/X11/fonts"}) {
            count += this.registerFontDirectory(directory, true);
        }
        for (String directory : withoutSubDirs = new String[]{"/Library/Fonts", "/System/Library/Fonts"}) {
            count += this.registerFontDirectory(directory, false);
        }
        return count;
    }

    Set<String> getRegisteredFonts() {
        return this.fontNames.keySet();
    }

    Set<String> getRegisteredFontFamilies() {
        return this.fontFamilies.keySet();
    }

    boolean isRegisteredFont(String fontname) {
        return this.fontNames.containsKey(fontname.toLowerCase());
    }

    public void clearRegisteredFonts() {
        this.fontNames.clear();
        this.registerStandardFonts();
    }

    public void clearRegisteredFontFamilies() {
        this.fontFamilies.clear();
        this.registerStandardFontFamilies();
    }
}

