/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey;

import com.itextpdf.kernel.counter.data.IEventDataCache;
import com.itextpdf.kernel.counter.data.IEventDataFactory;
import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.kinesis.IKinesisClientProvider;
import com.itextpdf.licensekey.kinesis.KinesisEventDataHandler;
import com.itextpdf.licensekey.volume.VolumeData;
import com.itextpdf.licensekey.volume.VolumeDataSignature;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;

public class VolumeDataHandler
extends KinesisEventDataHandler<VolumeDataSignature, VolumeData> {
    private final int strictErrorLimit;
    private final String strictErrorExceptionMessage;
    private final AtomicLong strictErrors = new AtomicLong(0L);

    public VolumeDataHandler(IEventDataCache<VolumeDataSignature, VolumeData> cache, IEventDataFactory<VolumeDataSignature, VolumeData> factory, IKinesisClientProvider provider, String streamName) {
        this(cache, factory, provider, streamName, "iText was unable to record your usage information as required by the Capacity Rental License. Please make sure this machine is able to connect to the iText Volume Server. If you keep seeing this warning message, contact our support team: https://itextpdf.com/support.", 70, "Unable to send strict volume event", 5);
    }

    public VolumeDataHandler(IEventDataCache<VolumeDataSignature, VolumeData> cache, IEventDataFactory<VolumeDataSignature, VolumeData> factory, IKinesisClientProvider provider, String streamName, String errorLogMessage, int errorLimit, String strictErrorExceptionMessage, int strictErrorLimit) {
        super(cache, factory, provider, streamName, errorLogMessage, errorLimit);
        this.strictErrorLimit = strictErrorLimit;
        this.strictErrorExceptionMessage = strictErrorExceptionMessage;
    }

    @Override
    protected void onSuccess(VolumeData data) {
        super.onSuccess(data);
        if (((VolumeDataSignature)data.getSignature()).isStrict()) {
            this.strictErrors.set(0L);
        }
    }

    @Override
    protected void onFailure(VolumeData data) {
        super.onFailure(data);
        if (((VolumeDataSignature)data.getSignature()).isStrict() && this.strictErrors.incrementAndGet() > (long)this.strictErrorLimit) {
            throw new LicenseKeyException(this.strictErrorExceptionMessage);
        }
    }

    @Override
    public byte[] toBytes(VolumeData data) {
        return ("{" + data.asJson() + "}").getBytes(StandardCharsets.UTF_8);
    }
}

