/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.volume;

import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.licensekey.PortingUtils;
import com.itextpdf.licensekey.volume.VolumeDataSignature;
import com.itextpdf.licensekey.volume.VolumeUtils;

public class VolumeData
extends EventData<VolumeDataSignature> {
    private long time;

    public VolumeData(VolumeDataSignature signature, long time, long count) {
        super((Object)signature, count);
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public String asJson() {
        return ((VolumeDataSignature)this.getSignature()).asJson() + ", \"event_time\": \"" + VolumeUtils.escapeJson(PortingUtils.getUtcTimestamp(this.time)) + '\"' + ", \"count\": " + String.valueOf(this.getCount());
    }

    public String toString() {
        return this.asJson();
    }

    protected void mergeWith(EventData<VolumeDataSignature> data) {
        super.mergeWith(data);
        this.time = Math.max(this.time, ((VolumeData)data).time);
    }
}

