/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.volume;

import com.itextpdf.io.util.SystemUtil;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.counter.data.IEventDataFactory;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.counter.event.IGenericEvent;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import com.itextpdf.licensekey.LicenseKeyTags;
import com.itextpdf.licensekey.counter.EventConstant;
import com.itextpdf.licensekey.volume.VolumeData;
import com.itextpdf.licensekey.volume.VolumeDataSignature;
import com.itextpdf.licensekey.volume.VolumeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VolumeDataFactory
implements IEventDataFactory<VolumeDataSignature, VolumeData> {
    private static final Map<String, String> EVENT_ORIGIN_ID_TO_NAME;
    private static final String CORE_NAME = "core";
    private final String iTextVersion;
    private final String systemInfo;
    private final CacheBuffer buffer = new CacheBuffer(null, null, false);
    private final Map<CacheBuffer, VolumeDataSignature> cache = new HashMap<CacheBuffer, VolumeDataSignature>();
    private final int CACHE_CAPACITY = 20;
    private volatile CachedLicenseInfo licenseInfo;

    public VolumeDataFactory(String iTextVersion, String systemInfo) {
        this.iTextVersion = iTextVersion;
        this.systemInfo = systemInfo;
    }

    public static boolean isEligible(String licenseKey, String productType) {
        return licenseKey != null && LicenseKeyTags.VOLUME_TYPES.contains(productType);
    }

    public String getITextVersion() {
        return this.iTextVersion;
    }

    public String getSystemInfo() {
        return this.systemInfo;
    }

    public void updateLicenseInfo(String key, String type, Map<String, String> productTypes) {
        this.licenseInfo = new CachedLicenseInfo(key, type, productTypes);
    }

    public void unloadLicenseInfo() {
        this.licenseInfo = null;
    }

    public VolumeData create(IEvent event, IMetaInfo metaInfo) {
        if (event instanceof IGenericEvent) {
            IGenericEvent generic = (IGenericEvent)event;
            CachedLicenseInfo local = this.licenseInfo;
            if (local != null && !Version.isAGPLVersion() && VolumeDataFactory.isEligible(local.getKey(), local.getType(EVENT_ORIGIN_ID_TO_NAME.get(generic.getOriginId())))) {
                return new VolumeData(this.createSignature(local.getKey(), event.getEventType()), SystemUtil.getRelativeTimeMillis(), 1L);
            }
        }
        return null;
    }

    private VolumeDataSignature createSignature(String key, String type) {
        this.buffer.key = VolumeUtils.ensureNotNull(key);
        this.buffer.type = VolumeUtils.ensureNotNull(type);
        this.buffer.strict = false;
        for (String prefix : EventConstant.STRICT_EVENTS_PREFIX) {
            if (!this.buffer.type.startsWith(prefix)) continue;
            this.buffer.strict = true;
        }
        VolumeDataSignature result = this.cache.get(this.buffer);
        if (result == null) {
            result = new VolumeDataSignature(this.iTextVersion, this.buffer.key, this.buffer.type, this.systemInfo, this.buffer.strict);
            if (this.cache.size() < 20) {
                this.cache.put(new CacheBuffer(this.buffer), result);
            }
        }
        return result;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.itextpdf.pdfcleanup", "pdfSweep");
        map.put("com.itextpdf.html2pdf", "pdfHtml");
        map.put("com.itextpdf.zugferd", "pdfInvoice");
        map.put("com.duallab.pdf2data", "pdf2Data");
        map.put("com.itextpdf.typography", "pdfCalligraph");
        map.put("com.itextpdf", CORE_NAME);
        map.put("com.itextpdf.search", "pdfSearch");
        map.put("com.itextpdf.ocr", "pdfOCR");
        map.put("com.itextpdf.ocrplus", "pdfOCRPlus");
        EVENT_ORIGIN_ID_TO_NAME = Collections.unmodifiableMap(map);
    }

    private static class CacheBuffer {
        String key;
        String type;
        boolean strict;

        public CacheBuffer(String key, String type, boolean strict) {
            this.key = key;
            this.type = type;
            this.strict = strict;
        }

        public CacheBuffer(CacheBuffer other) {
            this(other.key, other.type, other.strict);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                CacheBuffer buff = (CacheBuffer)obj;
                return this.key.equals(buff.key) && this.type.equals(buff.type) && this.strict == buff.strict;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.key.hashCode();
            hashCode = 31 * hashCode + this.type.hashCode();
            return 31 * hashCode + (this.strict ? 31 : 0);
        }
    }

    private static class CachedLicenseInfo {
        private final String key;
        private final Map<String, String> types = new HashMap<String, String>();

        public CachedLicenseInfo(String key, String type, Map<String, String> productTypes) {
            this.key = key;
            this.types.put(VolumeDataFactory.CORE_NAME, type);
            for (Map.Entry<String, String> entry : productTypes.entrySet()) {
                this.types.put(entry.getKey(), entry.getValue());
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.types.get(VolumeDataFactory.CORE_NAME);
        }

        public String getType(String name) {
            return name != null ? this.types.get(name) : null;
        }
    }
}

