/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.volume;

import com.itextpdf.licensekey.volume.VolumeUtils;

public class VolumeDataSignature {
    private final String version;
    private final String key;
    private final String type;
    private final String info;
    private final boolean strict;
    private final int hash;
    private final String json;

    public VolumeDataSignature(String version, String key, String type, String info, boolean strict) {
        this.version = version;
        this.key = key;
        this.type = type;
        this.info = info;
        this.strict = strict;
        int hashCode = version.hashCode();
        hashCode = 31 * hashCode + key.hashCode();
        hashCode = 31 * hashCode + type.hashCode();
        hashCode = 31 * hashCode + info.hashCode();
        this.hash = 31 * hashCode + (strict ? 31 : 0);
        this.json = "\"version\": \"" + VolumeUtils.escapeJson(version) + '\"' + ", \"license_key\": \"" + VolumeUtils.escapeJson(key) + '\"' + ", \"event_type\": \"" + VolumeUtils.escapeJson(type) + '\"' + ", \"info\": \"" + VolumeUtils.escapeJson(info) + '\"';
    }

    public String getVersion() {
        return this.version;
    }

    public String getKey() {
        return this.key;
    }

    public String getEventType() {
        return this.type;
    }

    public String getInfo() {
        return this.info;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            VolumeDataSignature sig = (VolumeDataSignature)obj;
            return this.version.equals(sig.version) && this.key.equals(sig.key) && this.type.equals(sig.type) && this.info.equals(sig.info) && this.strict == sig.strict;
        }
        return false;
    }

    public String toString() {
        return this.asJson() + ", \"strict\": " + this.strict;
    }

    public String asJson() {
        return this.json;
    }
}

