/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.util;

import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.util.Base64;
import com.itextpdf.licensekey.util.ResourceUtil;
import com.itextpdf.licensekey.util.UTF8;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateWorker {
    private PublicKey publicKey;
    private String description;

    private CertificateWorker(PublicKey publicKey, String description) {
        this.publicKey = publicKey;
        this.description = description;
    }

    public static CertificateWorker createCertificateWorker(String certPath, String description) {
        return CertificateWorker.createCertificateWorker(ResourceUtil.getResourceStream(certPath), description);
    }

    public static CertificateWorker createCertificateWorker(InputStream certInputStream, String description) {
        PublicKey publicKey = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (certInputStream == null) {
                throw new LicenseKeyException("Certificate not found.");
            }
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(certInputStream);
            publicKey = certificate.getPublicKey();
        }
        catch (LicenseKeyException lex) {
            throw lex;
        }
        catch (Exception ex) {
            throw new LicenseKeyException("Invalid public key. " + description + " " + ex.getMessage());
        }
        finally {
            try {
                certInputStream.close();
            }
            catch (IOException e) {
                throw new LicenseKeyException(e.getMessage());
            }
        }
        if (publicKey == null) {
            throw new LicenseKeyException("Certificate not found.");
        }
        return new CertificateWorker(publicKey, description);
    }

    public boolean verify(String decodedString, String encodedSignature) throws GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(this.publicKey);
        signature.update(UTF8.getBytes(decodedString));
        return signature.verify(Base64.decode(encodedSignature));
    }
}

