/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.util;

import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.util.MessageFormatUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class InfoExtraction {
    private InfoExtraction() {
    }

    public static String getLicenseElementTagValue(Element licenseElement, String tagName) {
        return InfoExtraction.getLicenseElementTagValue(licenseElement, tagName, false);
    }

    public static String getLicenseElementTagValue(Element licenseElement, String tagName, boolean required) {
        return InfoExtraction.getTagValue(licenseElement, tagName, required, "Licensee element does not contain element with tag: {0}.");
    }

    public static String getLicenseAttribute(Element licenseElement, String attributeName) {
        return InfoExtraction.getLicenseAttribute(licenseElement, attributeName, false);
    }

    public static String getLicenseAttribute(Element licenseElement, String attributeName, boolean required) {
        return InfoExtraction.getAttribute(licenseElement, attributeName, required, "Licensee element does not contain attribute with name: {0}.");
    }

    public static String getProductElementTagValue(Element product, String tagName) {
        return InfoExtraction.getProductElementTagValue(product, tagName, false);
    }

    public static String getProductElementTagValue(Element product, String tagName, boolean required) {
        return InfoExtraction.getTagValue(product, tagName, required, "Product element doesn't contain element with tag: {0}.");
    }

    public static String getProductAttribute(Element productElement, String attributeName) {
        return InfoExtraction.getProductAttribute(productElement, attributeName, false);
    }

    public static String getProductAttribute(Element productElement, String attributeName, boolean required) {
        return InfoExtraction.getAttribute(productElement, attributeName, required, "Product element doesn't contain attribute with name: {0}.");
    }

    private static String getTagValue(Element element, String tagName, boolean required, String errorMessageBase) {
        NodeList temp = element.getElementsByTagName(tagName);
        if (temp != null && temp.getLength() == 1) {
            return temp.item(0).getTextContent();
        }
        if (!required) {
            return "";
        }
        throw new LicenseKeyException(MessageFormatUtil.format(errorMessageBase, tagName));
    }

    private static String getAttribute(Element element, String attributeName, boolean required, String errorMessageBase) {
        Node attribute = element.getAttributes().getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        if (!required) {
            return "";
        }
        throw new LicenseKeyException(MessageFormatUtil.format(errorMessageBase, attributeName));
    }
}

