/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.validators;

import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.LicenseKeyLicensee;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.LicenseKeyProductFeature;
import com.itextpdf.licensekey.util.Base64;
import com.itextpdf.licensekey.util.CertificateWorker;
import com.itextpdf.licensekey.util.InfoExtraction;
import com.itextpdf.licensekey.util.UTF8;
import com.itextpdf.licensekey.validators.AbstractLicenseKeyValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseKey5Validator
extends AbstractLicenseKeyValidator {
    public LicenseKey5Validator(CertificateWorker certificateWorker) {
        super(certificateWorker);
    }

    @Override
    protected LicenseKeyLicensee extractLicensee(Element licenseeElement) {
        return new LicenseKeyLicensee(InfoExtraction.getLicenseElementTagValue(licenseeElement, "name"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "email", true), InfoExtraction.getLicenseElementTagValue(licenseeElement, "company"), null, InfoExtraction.getLicenseAttribute(licenseeElement, "expire", true), InfoExtraction.getLicenseElementTagValue(licenseeElement, "key"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "producer"));
    }

    @Override
    protected String[] getLicenseeInfo(LicenseKeyLicensee loadedLicensee, boolean validLicenseeWasLoaded, boolean loadedLicenseExpired) {
        if (validLicenseeWasLoaded || loadedLicenseExpired) {
            String b = null;
            if (loadedLicensee.getEmail() != null && loadedLicensee.getEmail().trim().length() > 0) {
                b = loadedLicensee.getEmail().substring(0, 1) + Base64.encodeBytes(UTF8.getBytes(loadedLicensee.getEmail()));
            }
            String[] result = new String[]{loadedLicensee.getName(), loadedLicensee.getEmail(), loadedLicensee.getCompany(), loadedLicensee.getKey(), loadedLicensee.getProducerLine(), b};
            return result;
        }
        throw new LicenseKeyException("Loaded License has expired.");
    }

    @Override
    protected void compareLicenseeInfo(LicenseKeyLicensee loadingLicensee, LicenseKeyLicensee loadedLicensee) {
        this.compareLicenseInfoEntry(loadingLicensee.getName(), loadedLicensee.getName());
        this.compareLicenseInfoEntry(loadingLicensee.getEmail(), loadedLicensee.getEmail());
        this.compareLicenseInfoEntry(loadingLicensee.getCompany(), loadedLicensee.getCompany());
        this.compareLicenseInfoEntry(loadingLicensee.getProducerLine(), loadedLicensee.getProducerLine());
    }

    @Override
    protected String[] getProductInfo(LicenseKeyProduct product) {
        return new String[]{product.getProductName(), product.getMajor(), product.getMinor(), product.getType(), product.getExpireDate(), product.getPlatform()};
    }

    @Override
    protected String formLicenseeSignatureString(LicenseKeyLicensee licensee) {
        return "iTextRulez" + licensee.getName() + licensee.getEmail() + licensee.getCompany() + licensee.getExpireDate() + licensee.getKey() + licensee.getProducerLine();
    }

    @Override
    protected String formProductSignature(LicenseKeyProduct product, LicenseKeyLicensee licensee) {
        String signatureString = "iTextRulez" + licensee.getEmail() + product.getProductName() + product.getMajor() + product.getMinor() + product.getType() + product.getExpireDate() + product.getPlatform();
        for (LicenseKeyProductFeature feature : product.getProductFeatures()) {
            signatureString = signatureString + feature.getName();
        }
        return signatureString;
    }

    @Override
    protected void beforeValidLicenseLoaded() {
        this.resetKernelVersion();
    }

    @Override
    protected void afterValidLicenseLoaded(LicenseKeyLicensee licenseKeyLicensee, Collection<? extends LicenseKeyProduct> licenseKeyProducts) {
    }

    @Override
    protected void checkProductCompatibility(LicenseKeyProduct product, LicenseKeyLicensee licensee) {
    }

    private void resetKernelVersion() {
        block4: {
            String classPath = "com.itextpdf.text.Version";
            Class<?> versionClass = null;
            try {
                versionClass = Class.forName(classPath);
                Method atomicSetVersionMethod = versionClass.getDeclaredMethod("atomicSetVersion", versionClass);
                atomicSetVersionMethod.setAccessible(true);
                atomicSetVersionMethod.invoke(null, null);
            }
            catch (Exception any) {
                if (versionClass == null) break block4;
                try {
                    Field versionField = versionClass.getDeclaredField("version");
                    versionField.setAccessible(true);
                    versionField.set(null, null);
                    return;
                }
                catch (Exception exception) {
                    LoggerFactory.getLogger(this.getClass()).error("Unable to reset kernel version in iText 5. The information in it may not represent actual info of load license.");
                }
            }
        }
    }
}

