/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.validators;

import com.itextpdf.licensekey.LicenseKeyException;
import com.itextpdf.licensekey.LicenseKeyLicensee;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.LicenseKeyProductFeature;
import com.itextpdf.licensekey.LicenseKeyTags;
import com.itextpdf.licensekey.util.Base64;
import com.itextpdf.licensekey.util.CertificateWorker;
import com.itextpdf.licensekey.util.CollectionUtil;
import com.itextpdf.licensekey.util.InfoExtraction;
import com.itextpdf.licensekey.util.UTF8;
import com.itextpdf.licensekey.validators.AbstractLicenseKeyValidator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseKey7Validator
extends AbstractLicenseKeyValidator {
    public LicenseKey7Validator(CertificateWorker certificateWorker) {
        super(certificateWorker);
    }

    @Override
    public void checkLicense(LicenseKeyProduct product) throws LicenseKeyException {
        if (product != null && ("pdfCalligraph".equals(product.getProductName()) || "pdfHtml".equals(product.getProductName())) && LicenseKey7Validator.isCalledFromDito()) {
            return;
        }
        super.checkLicense(product);
    }

    @Override
    protected LicenseKeyLicensee extractLicensee(Element licenseeElement) {
        return new LicenseKeyLicensee(InfoExtraction.getLicenseElementTagValue(licenseeElement, "name"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "email", true), InfoExtraction.getLicenseElementTagValue(licenseeElement, "company"), null, InfoExtraction.getLicenseAttribute(licenseeElement, "expire", true), InfoExtraction.getLicenseElementTagValue(licenseeElement, "key"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "producer"), null, InfoExtraction.getLicenseElementTagValue(licenseeElement, "licensetype"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "deploymenttype"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "version"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "access"), InfoExtraction.getLicenseElementTagValue(licenseeElement, "secret"));
    }

    @Override
    protected String[] getLicenseeInfo(LicenseKeyLicensee loadedLicensee, boolean validLicenseeWasLoaded, boolean loadedLicenseExpired) {
        if (validLicenseeWasLoaded) {
            if ("standalone".equals(loadedLicensee.getType())) {
                throw new LicenseKeyException("This is a standalone license and an only be used in the standalone application.");
            }
            String b = null;
            if (loadedLicensee.getEmail() != null && loadedLicensee.getEmail().trim().length() > 0) {
                b = loadedLicensee.getEmail().substring(0, 1) + Base64.encodeBytes(UTF8.getBytes(loadedLicensee.getEmail()));
            }
            String version = loadedLicensee.getVersion().equals("") ? "7.0" : loadedLicensee.getVersion();
            String[] result = new String[]{loadedLicensee.getName(), loadedLicensee.getEmail(), loadedLicensee.getCompany(), loadedLicensee.getKey(), loadedLicensee.getProducerLine(), b, version, String.valueOf(loadedLicenseExpired).toLowerCase(), loadedLicensee.getType(), loadedLicensee.getAccess(), loadedLicensee.getSecret()};
            return result;
        }
        throw new LicenseKeyException(loadedLicenseExpired ? "Loaded License has expired." : "License file not loaded.");
    }

    @Override
    protected void compareLicenseeInfo(LicenseKeyLicensee loadingLicensee, LicenseKeyLicensee loadedLicensee) {
        this.compareLicenseInfoEntry(loadingLicensee.getName(), loadedLicensee.getName());
        this.compareLicenseInfoEntry(loadingLicensee.getEmail(), loadedLicensee.getEmail());
        this.compareLicenseInfoEntry(loadingLicensee.getCompany(), loadedLicensee.getCompany());
        this.compareLicenseInfoEntry(loadingLicensee.getType(), loadedLicensee.getType());
        this.compareLicenseInfoEntry(loadingLicensee.getDeploymentType(), loadedLicensee.getDeploymentType());
        this.compareLicenseInfoEntry(loadingLicensee.getVersion(), loadedLicensee.getVersion());
        this.compareLicenseInfoEntry(loadingLicensee.getProducerLine(), loadedLicensee.getProducerLine());
        this.compareLicenseInfoEntry(loadingLicensee.getAccess(), loadedLicensee.getAccess());
        this.compareLicenseInfoEntry(loadingLicensee.getSecret(), loadedLicensee.getSecret());
    }

    @Override
    protected String[] getProductInfo(LicenseKeyProduct product) {
        return new String[]{product.getProductName(), product.getMajor(), product.getMinor(), product.getType(), product.getExpireDate(), product.getPlatform()};
    }

    @Override
    protected String formLicenseeSignatureString(LicenseKeyLicensee licensee) {
        return "iTextRulez" + licensee.getName() + licensee.getEmail() + licensee.getCompany() + licensee.getExpireDate() + licensee.getKey() + licensee.getProducerLine() + licensee.getType() + licensee.getVersion() + licensee.getAccess() + licensee.getSecret();
    }

    @Override
    protected String formProductSignature(LicenseKeyProduct product, LicenseKeyLicensee licensee) {
        String signatureString = "iTextRulez" + licensee.getEmail() + product.getProductName() + product.getMajor() + product.getMinor() + product.getType() + product.getExpireDate() + product.getPlatform() + licensee.getType();
        for (LicenseKeyProductFeature feature : product.getProductFeatures()) {
            signatureString = signatureString + feature.getName();
        }
        return signatureString;
    }

    @Override
    protected void beforeValidLicenseLoaded() {
        this.resetKernelVersion();
    }

    @Override
    protected void afterValidLicenseLoaded(LicenseKeyLicensee licenseKeyLicensee, Collection<? extends LicenseKeyProduct> licenseKeyProducts) {
        boolean hasVolumeLicense = LicenseKeyTags.VOLUME_TYPES.contains(licenseKeyLicensee.getType());
        for (LicenseKeyProduct licenseKeyProduct : licenseKeyProducts) {
            hasVolumeLicense = LicenseKeyTags.VOLUME_TYPES.contains(licenseKeyProduct.getType()) || hasVolumeLicense;
        }
        if (hasVolumeLicense && !LicenseKey7Validator.updateVolumeCounter()) {
            throw new LicenseKeyException("The 'itext-licensekey-volume' library is required for your license type, but it is missing or outdated. Please add or update this library. If you have any questions, contact our support team: https://itextpdf.com/support.");
        }
    }

    @Override
    protected void checkProductCompatibility(LicenseKeyProduct product, LicenseKeyLicensee licensee) {
        if (product.getDeploymentType().length() > 0 && licensee.getDeploymentType().length() > 0 && !product.getDeploymentType().equals(licensee.getDeploymentType())) {
            throw new LicenseKeyException("The deployment types must be the same for every add-on and iText core license.");
        }
    }

    private static boolean updateVolumeCounter() {
        try {
            Class<?> eventCounter = Class.forName("com.itextpdf.kernel.counter.EventCounter");
            Class<?> volumeCounterLoaderClass = Class.forName("com.itextpdf.licensekey.VolumeCounterLoader");
            Method updateVolumeCounterMethod = volumeCounterLoaderClass.getDeclaredMethod("update", new Class[0]);
            updateVolumeCounterMethod.setAccessible(true);
            updateVolumeCounterMethod.invoke(null, new Object[0]);
            return updateVolumeCounterMethod != null;
        }
        catch (Exception any) {
            return false;
        }
    }

    private void resetKernelVersion() {
        block4: {
            String classPath = "com.itextpdf.kernel.Version";
            Class<?> versionClass = null;
            try {
                versionClass = Class.forName(classPath);
                Method atomicSetVersionMethod = versionClass.getDeclaredMethod("atomicSetVersion", versionClass);
                atomicSetVersionMethod.setAccessible(true);
                atomicSetVersionMethod.invoke(null, null);
            }
            catch (Exception any) {
                if (versionClass == null) break block4;
                try {
                    Field versionField = versionClass.getDeclaredField("version");
                    versionField.setAccessible(true);
                    versionField.set(null, null);
                    return;
                }
                catch (Exception exception) {
                    LoggerFactory.getLogger(this.getClass()).error("Unable to reset kernel version in iText 7. The information in it may not represent actual info of load license.");
                }
            }
        }
    }

    private static void registerEventContext(Collection<String> namespace, Collection<String> eventId) {
        block2: {
            Class<?> contextManager = null;
            try {
                contextManager = Class.forName("com.itextpdf.kernel.counter.ContextManager");
                Method getInstance = contextManager.getDeclaredMethod("getInstance", new Class[0]);
                Object instance = getInstance.invoke(null, new Object[0]);
                Method registerGenericContext = contextManager.getDeclaredMethod("registerGenericContext", Collection.class, Collection.class);
                registerGenericContext.setAccessible(true);
                registerGenericContext.invoke(instance, namespace, eventId);
            }
            catch (Exception any) {
                if (contextManager == null) break block2;
                LoggerFactory.getLogger(LicenseKey7Validator.class).error("Unable to register event context. Event counter may throw more events than expected.");
            }
        }
    }

    private static boolean isCalledFromDito() {
        Class<?> contextManager = null;
        try {
            contextManager = Class.forName("com.itextpdf.kernel.counter.ContextManager");
            Method getInstance = contextManager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = getInstance.invoke(null, new Object[0]);
            Method getRecognisedNamespace = contextManager.getDeclaredMethod("getRecognisedNamespace", String.class);
            getRecognisedNamespace.setAccessible(true);
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            for (int i = trace.length - 1; i >= 0; --i) {
                if (LicenseKey7Validator.class.getName().equals(trace[i].getClassName())) {
                    return false;
                }
                String namespace = (String)getRecognisedNamespace.invoke(instance, trace[i].getClassName());
                if (namespace == null) continue;
                return namespace.equals("com.itextpdf.dito");
            }
            return false;
        }
        catch (Exception any) {
            return false;
        }
    }

    static {
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.itextpdf.dito"), CollectionUtil.asList("com.itextpdf.dito"));
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.duallab.pdf2data"), CollectionUtil.asList("com.duallab.pdf2data"));
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.itextpdf.typography"), CollectionUtil.asList("com.itextpdf.typography"));
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.itextpdf.indexer", "com.itextpdf.ocr", "com.itextpdf.search", "com.itextpdf.ocrplus"), CollectionUtil.asList("com.itextpdf.indexer", "com.itextpdf.ocr", "com.itextpdf.search", "com.itextpdf.ocrplus"));
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.itextpdf.pdfrender"), CollectionUtil.asList("com.itextpdf.pdfrender"));
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.itextpdf.layout"), CollectionUtil.asList("com.itextpdf", "com.itextpdf.typography"));
        LicenseKey7Validator.registerEventContext(CollectionUtil.asList("com.itextpdf.html2pdf"), CollectionUtil.asList("com.itextpdf.html2pdf", "com.itextpdf.typography"));
    }
}

