/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.counter.data;

import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.kernel.counter.data.EventDataHandler;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public final class EventDataHandlerUtil {
    private static final ConcurrentHashMap<Object, Thread> shutdownHooks = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Object, Thread> scheduledTasks = new ConcurrentHashMap();

    private EventDataHandlerUtil() {
    }

    public static <T, V extends EventData<T>> void registerProcessAllShutdownHook(EventDataHandler<T, V> dataHandler) {
        if (shutdownHooks.containsKey(dataHandler)) {
            return;
        }
        Thread shutdownHook = new Thread(dataHandler::tryProcessRest);
        shutdownHooks.put(dataHandler, shutdownHook);
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (SecurityException security) {
            LoggerFactory.getLogger(EventDataHandlerUtil.class).error("Unable to register event data handler shutdown hook because of security reasons.");
            shutdownHooks.remove(dataHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T, V extends EventData<T>> void disableShutdownHooks(EventDataHandler<T, V> dataHandler) {
        Thread toDisable = shutdownHooks.remove(dataHandler);
        if (toDisable != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(toDisable);
            }
            catch (SecurityException security) {
                LoggerFactory.getLogger(EventDataHandlerUtil.class).error("Unable to unregister event data handler shutdown hook because of security permissions");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T, V extends EventData<T>> void registerTimedProcessing(EventDataHandler<T, V> dataHandler) {
        if (scheduledTasks.containsKey(dataHandler)) {
            return;
        }
        Thread thread = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(dataHandler.getWaitTime().getTime());
                    dataHandler.tryProcessNextAsync(false);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception any) {
                LoggerFactory.getLogger(EventDataHandlerUtil.class).error("Unexpected exception encountered in service thread. Shutting it down.", (Throwable)any);
            }
        });
        scheduledTasks.put(dataHandler, thread);
        thread.setDaemon(true);
        thread.start();
    }

    public static <T, V extends EventData<T>> void disableTimedProcessing(EventDataHandler<T, V> dataHandler) {
        Thread toDisable = scheduledTasks.remove(dataHandler);
        if (toDisable != null) {
            try {
                toDisable.interrupt();
            }
            catch (SecurityException security) {
                LoggerFactory.getLogger(EventDataHandlerUtil.class).error("Unable to interrupt a thread");
            }
        }
    }

    public static class BiggerCountComparator<T, V extends EventData<T>>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            return Long.compare(((EventData)o2).getCount(), ((EventData)o1).getCount());
        }
    }
}

