/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.actions;

import com.itextpdf.commons.actions.processors.ITextProductEventProcessor;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.actions.LicenseFileExpirationChecker;
import com.itextpdf.licensing.base.actions.LicenseITextProductEventProcessor;
import com.itextpdf.licensing.base.exceptions.LicenseFileExpiredException;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.OnExpirationStrategy;
import com.itextpdf.licensing.base.licensefile.Platform;
import com.itextpdf.licensing.base.licensefile.SendStatistics;
import com.itextpdf.licensing.base.reporting.AbstractLicenseConfigurationEvent;
import com.itextpdf.licensing.base.reporting.LicenseKeyReportingConfigurer;
import com.itextpdf.licensing.base.storage.LicenseFilesCache;
import com.itextpdf.licensing.base.storage.LicenseFilesCacheKeeper;
import com.itextpdf.licensing.base.util.LicenseFileUtil;
import com.itextpdf.licensing.base.util.SigningUtil;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadLicenseEvent
extends AbstractLicenseConfigurationEvent {
    private static final String PLATFORM = "java";
    private static final String EXPECTED_VERSION = "1.0.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadLicenseEvent.class);
    private final LicenseFile licenseFile;

    public LoadLicenseEvent(LicenseFile licenseFile) {
        this.licenseFile = LoadLicenseEvent.getProperLicenseFile(licenseFile);
    }

    @Override
    protected void doSynchronizedAction() {
        Map<String, LicenseITextProductEventProcessor> licenseProcessors = this.getLicenseProcessors();
        LicenseITextProductEventProcessor existingProcessor = licenseProcessors.get(this.licenseFile.getProduct());
        if (existingProcessor != null) {
            if (existingProcessor.getLicenseFile().equals(this.licenseFile)) {
                return;
            }
            LoadLicenseEvent.validateProcessorReplacement(this.licenseFile, existingProcessor.getLicenseFile());
        } else {
            LoadLicenseEvent.validateProcessorAdding(this.licenseFile, licenseProcessors);
        }
        ITextProductEventProcessor oldProcessor = this.addProcessor((ITextProductEventProcessor)new LicenseITextProductEventProcessor(this.licenseFile, this.getReportingHandler()));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(MessageFormatUtil.format((String)"A license for the product \"{0}\" was loaded successfully!", (Object[])new Object[]{this.licenseFile.getProduct()}));
        }
        try {
            this.getReportingHandler().updateReportingForProduct(this.licenseFile.getProduct());
            LicenseKeyReportingConfigurer.overrideStatisticsSendingForProduct(this.licenseFile.getProduct(), this.licenseFile.getSendStatistics() == SendStatistics.enabled);
        }
        catch (Exception e) {
            if (oldProcessor == null) {
                this.removeProcessor(this.licenseFile.getProduct());
            } else {
                this.addProcessor(oldProcessor);
            }
            this.getReportingHandler().updateReportingForProduct(this.licenseFile.getProduct());
            throw e;
        }
    }

    LicenseFile getLicenseFile() {
        return this.licenseFile;
    }

    private static LicenseFile getProperLicenseFile(LicenseFile originalLicenseFile) {
        try {
            LoadLicenseEvent.validateLicenceFile(originalLicenseFile);
            return originalLicenseFile;
        }
        catch (LicenseFileExpiredException ex) {
            LicenseFilesCache licenseFilesCache = LicenseFilesCacheKeeper.getLicenseFilesCache();
            LicenseFile upToDateLicenseFile = licenseFilesCache.retrieveUpToDateLicenseFile(originalLicenseFile);
            if (originalLicenseFile.equals(upToDateLicenseFile) || LicenseFileUtil.compareLicensesByCreationDate(upToDateLicenseFile, originalLicenseFile) < 0) {
                throw ex.getOriginalException();
            }
            LoadLicenseEvent.validateLicenceFile(upToDateLicenseFile);
            return upToDateLicenseFile;
        }
    }

    private static void validateLicenceFile(LicenseFile licenseFile) {
        SigningUtil.checkSignature(licenseFile);
        LoadLicenseEvent.checkLicenseFileVersion(licenseFile);
        LoadLicenseEvent.checkPlatform(licenseFile);
        LoadLicenseEvent.checkExpirationDate(licenseFile);
    }

    private static void checkLicenseFileVersion(LicenseFile licenseFile) {
        if (!EXPECTED_VERSION.equals(licenseFile.getLicenseVersion())) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"This version {0} of license file is not supported. Try to update your license-key library.", (Object[])new Object[]{licenseFile.getLicenseVersion()}));
        }
    }

    private static void checkPlatform(LicenseFile licenseFile) {
        if (Platform.any != licenseFile.getPlatform() && !licenseFile.getPlatform().toString().equals(PLATFORM)) {
            throw new LicenseKeyException("The license file is not compatible with your current platform.");
        }
    }

    private static void checkExpirationDate(LicenseFile licenseFile) {
        String productName = licenseFile.getProduct();
        LicenseFileExpirationChecker expirationChecker = new LicenseFileExpirationChecker(productName, OnExpirationStrategy.fail, licenseFile.getExpirationDate(), null);
        try {
            expirationChecker.checkExpiration();
        }
        catch (LicenseKeyException ex) {
            throw new LicenseFileExpiredException(ex);
        }
    }

    private static void validateProcessorReplacement(LicenseFile newerLicense, LicenseFile licenseToReplace) {
        if (LicenseFileUtil.compareLicensesByCreationDate(newerLicense, licenseToReplace) < 0) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Already set license for the product \"{0}\" was created later then the license you tried to load. Typically iText uses the latest license for its work. If required, please unload the existing license and then load a new one.", (Object[])new Object[]{newerLicense.getProduct()}));
        }
        if (!LoadLicenseEvent.areValidLicensesCompatible(newerLicense, licenseToReplace)) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"A license for the product \"{0}\" was not loaded as your license is not compatible with the already loaded license for this product. Compatible licenses should have same licensee info, the same deployment type and same event reporting set up.", (Object[])new Object[]{newerLicense.getProduct()}));
        }
    }

    private static void validateProcessorAdding(LicenseFile license, Map<String, LicenseITextProductEventProcessor> licenseProcessors) {
        LicenseITextProductEventProcessor anotherProcessor = null;
        Iterator<Map.Entry<String, LicenseITextProductEventProcessor>> iterator = licenseProcessors.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, LicenseITextProductEventProcessor> processorEntry = iterator.next();
            anotherProcessor = processorEntry.getValue();
        }
        if (anotherProcessor != null && !LoadLicenseEvent.areValidLicensesCompatible(license, anotherProcessor.getLicenseFile())) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"A license for the product \"{0}\" was not loaded as your license is not compatible with the already loaded license for the product \"{1}\". Compatible licenses should have same licensee info, the same deployment type and same event reporting set up.", (Object[])new Object[]{license.getProduct(), anotherProcessor.getProductName()}));
        }
    }

    private static boolean areValidLicensesCompatible(LicenseFile file1, LicenseFile file2) {
        return file1.getLicensee().equals(file2.getLicensee()) && (file1.getDeploymentType() == null ? file2.getDeploymentType() == null : file1.getDeploymentType().equals((Object)file2.getDeploymentType())) && (file1.getEventReporting() == null ? file2.getEventReporting() == null : file1.getEventReporting().equals(file2.getEventReporting()));
    }
}

