/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.IEventHandler;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.LicenseKeyProductData;
import com.itextpdf.licensing.base.actions.StatisticsHandlerUpdateEvent;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.reporting.LicenseKeyReportingConfigurer;
import com.itextpdf.licensing.base.statistics.StatisticsEventHandlerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class StatisticsEventHandler
implements IEventHandler {
    private static final StatisticsEventHandler INSTANCE = new StatisticsEventHandler();
    private final Object lock = new Object();
    private boolean isEnabled = true;
    private Map<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> statisticsAggregators = new LinkedHashMap<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>>();

    private StatisticsEventHandler() {
    }

    public static void register() {
        EventManager.getInstance().register((IEventHandler)INSTANCE);
        StatisticsEventHandler.INSTANCE.isEnabled = true;
        StatisticsEventHandlerUtil.registerProcessAllShutdownHook();
        StatisticsEventHandlerUtil.registerTimedProcessing();
    }

    public void onEvent(IEvent event) {
        if (event instanceof StatisticsHandlerUpdateEvent && ((StatisticsHandlerUpdateEvent)event).isUnloadStatisticHandlerEvent()) {
            StatisticsEventHandler.reset();
        }
        if (!(event instanceof AbstractStatisticsEvent) || !this.isEnabled) {
            return;
        }
        AbstractStatisticsEvent statisticsEvent = (AbstractStatisticsEvent)event;
        String productName = statisticsEvent.getProductName();
        String licenseKey = null;
        if (LicenseKeyProductData.getInstance().getProductName().equals(productName)) {
            List<LicenseFile> licenseFiles = LicenseFileService.getLicenseFiles();
            if (!licenseFiles.stream().anyMatch(file -> LicenseKeyReportingConfigurer.isStatisticsEnabledForProduct(file.getProduct()))) {
                return;
            }
        } else {
            LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(productName);
            if (licenseFile == null || !LicenseKeyReportingConfigurer.isStatisticsEnabledForProduct(productName)) {
                return;
            }
            licenseKey = licenseFile.getKey();
        }
        this.aggregateDataFromStatisticsEvent(statisticsEvent, licenseKey, productName);
    }

    static StatisticsEventHandler getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        StatisticsEventHandlerUtil.disableShutdownHooks();
        StatisticsEventHandlerUtil.disableTimedProcessing();
        Object object = StatisticsEventHandler.INSTANCE.lock;
        synchronized (object) {
            StatisticsEventHandler.INSTANCE.isEnabled = false;
            StatisticsEventHandler.INSTANCE.statisticsAggregators.clear();
        }
    }

    Map<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> getStatisticsAggregators() {
        return Collections.unmodifiableMap(this.statisticsAggregators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> copyAndClearStatisticsAggregators() {
        LinkedHashMap<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> statisticsAggregatorsCopy;
        Object object = this.lock;
        synchronized (object) {
            statisticsAggregatorsCopy = new LinkedHashMap<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>>(this.statisticsAggregators);
            this.statisticsAggregators.clear();
        }
        return statisticsAggregatorsCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeStatisticsAggregators(Map<AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> source) {
        Object object = this.lock;
        synchronized (object) {
            MapUtil.merge(this.statisticsAggregators, source, (map1, map2) -> {
                MapUtil.merge((Map)map1, (Map)map2, (aggregator1, aggregator2) -> {
                    aggregator1.merge(aggregator2);
                    return aggregator1;
                });
                return map1;
            });
        }
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aggregateDataFromStatisticsEvent(AbstractStatisticsEvent statisticsEvent, String licenseKey, String moduleName) {
        List statisticsNames = statisticsEvent.getStatisticsNames();
        Object object = this.lock;
        synchronized (object) {
            AggregatorIdentifier identifier = new AggregatorIdentifier(licenseKey, moduleName);
            Map<String, AbstractStatisticsAggregator> aggregators = this.statisticsAggregators.get(identifier);
            if (aggregators == null) {
                aggregators = new LinkedHashMap<String, AbstractStatisticsAggregator>();
                this.statisticsAggregators.put(identifier, aggregators);
            }
            for (String statisticsName : statisticsNames) {
                AbstractStatisticsAggregator aggregator = aggregators.get(statisticsName);
                if (aggregator == null) {
                    aggregator = statisticsEvent.createStatisticsAggregatorFromName(statisticsName);
                    if (aggregator == null) continue;
                    aggregators.put(statisticsName, aggregator);
                }
                aggregator.aggregate(statisticsEvent);
            }
        }
    }

    static class AggregatorIdentifier {
        private final String licenseKey;
        private final String moduleName;

        public AggregatorIdentifier(String licenseKey, String moduleName) {
            this.licenseKey = licenseKey;
            this.moduleName = moduleName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregatorIdentifier that = (AggregatorIdentifier)o;
            return Objects.equals(this.licenseKey, that.licenseKey) && Objects.equals(this.moduleName, that.moduleName);
        }

        public int hashCode() {
            return Objects.hash(this.licenseKey, this.moduleName);
        }

        public String getLicenseKey() {
            return this.licenseKey;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }
}

