/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.reporting.volume.WaitTime;
import com.itextpdf.licensing.base.statistics.IStatisticsServer;
import com.itextpdf.licensing.base.statistics.ProductStatistics;
import com.itextpdf.licensing.base.statistics.StatisticsEventHandler;
import com.itextpdf.licensing.base.statistics.StatisticsServerFactory;
import com.itextpdf.licensing.base.util.PortingUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class StatisticsEventSender {
    private static final long SECS_IN_MINUTE = 60L;
    private static final long MILLIS_IN_SEC = 1000L;
    private static final long INITIAL_TIME = 300000L;
    private static final long MAX_TIME = 1800000L;
    private static WaitTime waitTime = new WaitTime(300000L, 1800000L);

    private StatisticsEventSender() {
    }

    static void trySendStatisticsAsync() {
        StatisticsEventSender.trySendStatisticsAsync(null);
    }

    static void trySendStatisticsAsync(Boolean daemon) {
        Thread thread = new Thread(() -> StatisticsEventSender.trySendStatistics());
        if (daemon != null) {
            thread.setDaemon(daemon);
        }
        thread.start();
    }

    static void sendStatisticsOnExit() {
        try {
            StatisticsEventSender.trySendStatistics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void trySendStatistics() {
        Map<StatisticsEventHandler.AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> statisticsAggregatorsCopy = StatisticsEventHandler.getInstance().copyAndClearStatisticsAggregators();
        List<ProductStatistics> productStatistics = StatisticsEventSender.createListFromMap(statisticsAggregatorsCopy);
        if (!productStatistics.isEmpty()) {
            boolean successful;
            try {
                successful = StatisticsEventSender.sendStatistics(productStatistics);
            }
            catch (Exception any) {
                successful = StatisticsEventSender.onProcessException(any);
            }
            if (successful) {
                StatisticsEventSender.onSuccess();
            } else {
                StatisticsEventSender.onFailure(statisticsAggregatorsCopy);
            }
        }
    }

    static WaitTime getWaitTime() {
        return waitTime;
    }

    static void setWaitTime(WaitTime waitTime) {
        StatisticsEventSender.waitTime = waitTime;
    }

    private static boolean sendStatistics(List<ProductStatistics> productStatistics) {
        IStatisticsServer server = StatisticsServerFactory.obtainConfiguredStatisticsServer();
        if (server == null) {
            return false;
        }
        return server.write(productStatistics);
    }

    private static List<ProductStatistics> createListFromMap(Map<StatisticsEventHandler.AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> statisticsAggregators) {
        String eventTime = PortingUtils.getUtcTimestamp(SystemUtil.getRelativeTimeMillis());
        return statisticsAggregators.entrySet().stream().map(identifierAndStatistics -> {
            LinkedHashMap<String, Object> statistics = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : ((Map)identifierAndStatistics.getValue()).entrySet()) {
                statistics.put((String)entry.getKey(), ((AbstractStatisticsAggregator)entry.getValue()).retrieveAggregation());
            }
            return new ProductStatistics(((StatisticsEventHandler.AggregatorIdentifier)identifierAndStatistics.getKey()).getLicenseKey(), ((StatisticsEventHandler.AggregatorIdentifier)identifierAndStatistics.getKey()).getModuleName(), statistics, eventTime);
        }).collect(Collectors.toList());
    }

    private static boolean onProcessException(Exception exception) {
        return false;
    }

    private static void onSuccess() {
        waitTime.resetTime();
    }

    private static void onFailure(Map<StatisticsEventHandler.AggregatorIdentifier, Map<String, AbstractStatisticsAggregator>> aggregators) {
        waitTime.increaseWaitTime();
        StatisticsEventHandler.getInstance().mergeStatisticsAggregators(aggregators);
    }
}

