/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.licensing.base.statistics.LicensingUsageStatisticsEvent;
import com.itextpdf.licensing.base.util.PortingUtils;

final class SystemInfoStatisticsAggregator
extends AbstractStatisticsAggregator {
    private static final int SYSTEM_INFO_MAX_ALLOWED_LENGTH = 128;
    private volatile String systemInfo = null;

    SystemInfoStatisticsAggregator() {
    }

    public void aggregate(AbstractStatisticsEvent event) {
        if (!(event instanceof LicensingUsageStatisticsEvent)) {
            return;
        }
        this.systemInfo = SystemInfoStatisticsAggregator.ensureSystemInfoBounded(PortingUtils.getSystemInfo());
    }

    public Object retrieveAggregation() {
        return this.systemInfo;
    }

    public void merge(AbstractStatisticsAggregator aggregator) {
        if (!(aggregator instanceof SystemInfoStatisticsAggregator)) {
            return;
        }
        this.systemInfo = ((SystemInfoStatisticsAggregator)aggregator).systemInfo;
    }

    static String ensureSystemInfoBounded(String originalValue) {
        return originalValue == null || originalValue.length() <= 128 ? originalValue : originalValue.substring(0, 128);
    }
}

