/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.strategy;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.licensefile.Limit;
import com.itextpdf.licensing.base.licensefile.LimitType;
import com.itextpdf.licensing.base.licensefile.OnExpirationStrategy;
import com.itextpdf.licensing.base.licensefile.UnavailabilityStrategy;
import com.itextpdf.licensing.base.strategy.AgplStrategy;
import com.itextpdf.licensing.base.strategy.DoNothingStrategy;
import com.itextpdf.licensing.base.strategy.FailStrategy;
import com.itextpdf.licensing.base.strategy.GraceFromLastSuccessStrategy;
import com.itextpdf.licensing.base.strategy.IStrategy;
import com.itextpdf.licensing.base.strategy.LogStrategy;
import com.itextpdf.licensing.base.util.LicenseFileUtil;

public final class StrategyFactory {
    private static final int DEFAULT_FAIL_STRATEGY_ERROR_LIMIT = 5;

    private StrategyFactory() {
    }

    public static IStrategy createLimitExceededStrategy(Limit limit, String productName, String eventType) {
        if (limit == null || Boolean.FALSE.equals(limit.getSendEvents()) || Boolean.FALSE.equals(limit.getCheckLimits()) || !LimitType.volume.equals((Object)limit.getLimitType())) {
            return null;
        }
        String exceptionMsg = MessageFormatUtil.format((String)"Limit \"{0}\" for product \"{1}\" has been exceeded.", (Object[])new Object[]{eventType, productName});
        switch (limit.getExceededStrategy()) {
            case log: {
                return new LogStrategy(MessageFormatUtil.format((String)"A \"{0}\" limit for product \"{1}\" has exceed.", (Object[])new Object[]{eventType, productName}));
            }
            case fail: {
                return new FailStrategy(exceptionMsg);
            }
            case agpl: {
                return new AgplStrategy(exceptionMsg, MessageFormatUtil.format((String)"A \"{0}\" limit for \"{1}\" product has exceed. Product \"{0}\" has been switched to AGPL version.", (Object[])new Object[]{eventType, productName}), productName);
            }
        }
        throw new IllegalArgumentException("Invalid reporting exceeded strategy.");
    }

    public static IStrategy createLicenseFileExpirationStrategy(String productName, OnExpirationStrategy strategy) {
        String exceptionMsg = MessageFormatUtil.format((String)"A license file which corresponds to \"{0}\" product has expired.", (Object[])new Object[]{productName});
        String logMsg = MessageFormatUtil.format((String)"A license file which corresponds to \"{0}\" product has expired.", (Object[])new Object[]{productName});
        String switchedMsg = MessageFormatUtil.format((String)"A license file which corresponds to \"{0}\" product has expired. Product \"{0}\" has been switched to AGPL version.", (Object[])new Object[]{productName});
        switch (strategy) {
            case grace: 
            case agpl: {
                return new AgplStrategy(exceptionMsg, switchedMsg, productName);
            }
            case log: {
                return new LogStrategy(logMsg);
            }
            case fail: {
                return new FailStrategy(exceptionMsg);
            }
        }
        throw new IllegalArgumentException("Invalid license file expiration strategy.");
    }

    public static IStrategy createEventReportingUnavailabilityStrategy(Limit limit, String productName, String eventType) {
        String logMessage = MessageFormatUtil.format((String)"Unable to connect to server during the event reporting. A \"{0}\" event for \"{1}\" product was not reported.", (Object[])new Object[]{eventType, productName});
        String exceptionMessage = MessageFormatUtil.format((String)"Unable to connect to server during the event reporting. A \"{0}\" event for \"{1}\" product was not reported.", (Object[])new Object[]{eventType, productName});
        return StrategyFactory.createUnavailabilityStrategy(limit, logMessage, exceptionMessage);
    }

    public static IStrategy createLimitUpdatingUnavailabilityStrategy(Limit limit, String productName, String eventType) {
        String logMessage = MessageFormatUtil.format((String)"Unable to connect to server during the limit updating. A \"{0}\" limit for \"{1}\" product was not updated.", (Object[])new Object[]{eventType, productName});
        String exceptionMessage = MessageFormatUtil.format((String)"Unable to connect to server during the limit updating. A \"{0}\" limit for \"{1}\" product was not updated.", (Object[])new Object[]{eventType, productName});
        return StrategyFactory.createUnavailabilityStrategy(limit, logMessage, exceptionMessage);
    }

    private static IStrategy createUnavailabilityStrategy(Limit limit, String logMessage, String exceptionMessage) {
        if (limit == null) {
            return new FailStrategy(exceptionMessage, 5L);
        }
        if (Boolean.FALSE.equals(limit.getSendEvents())) {
            return null;
        }
        UnavailabilityStrategy strategy = limit.getUnavailabilityStrategy();
        switch (strategy) {
            case log: {
                return new LogStrategy(logMessage);
            }
            case grace: {
                return new GraceFromLastSuccessStrategy(new LogStrategy(logMessage), new FailStrategy(exceptionMessage, 5L), LicenseFileUtil.parseGracePeriodStrToMilliseconds(limit.getGracePeriod()));
            }
            case proceed: {
                return new DoNothingStrategy();
            }
            case fail: {
                return new FailStrategy(exceptionMessage, 5L);
            }
        }
        throw new IllegalArgumentException("Invalid reporting unavailability strategy.");
    }
}

