/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.licensing.base.reporting.AwsResourcesCreator;
import com.itextpdf.licensing.base.statistics.IStatisticsServer;
import com.itextpdf.licensing.base.statistics.ProductStatistics;
import com.itextpdf.licensing.base.util.JsonMapperUtil;
import com.itextpdf.licensing.remote.kinesis.KinesisDataSender;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class AwsStatisticsServer
implements IStatisticsServer {
    private static final String AWS_KINESIS_STREAM_NAME = "StatisticsData";
    private static final int AWS_RECORD_MAX_SIZE = 0x100000;
    private static AwsStatisticsServer instance;
    private final KinesisDataSender kinesisDataSender = AwsResourcesCreator.createKinesisDataSender(0x100000, "StatisticsData");

    private AwsStatisticsServer() {
    }

    static AwsStatisticsServer getInstance() {
        if (instance == null) {
            instance = new AwsStatisticsServer();
        }
        return instance;
    }

    @Override
    public boolean write(List<ProductStatistics> usageList) {
        String usageArrayStr = JsonMapperUtil.serializeToMinimalString(usageList);
        if (usageArrayStr != null) {
            byte[] recordBytes = usageArrayStr.getBytes(StandardCharsets.UTF_8);
            return this.kinesisDataSender.sendRecord(recordBytes);
        }
        return false;
    }
}

