/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.statistics.LicensingUsageStatisticsEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class LicenseKeysStatisticsAggregator
extends AbstractStatisticsAggregator {
    private final Map<String, Set<String>> productsAndKeys = new LinkedHashMap<String, Set<String>>();
    private final Object lock = new Object();

    LicenseKeysStatisticsAggregator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(AbstractStatisticsEvent event) {
        if (!(event instanceof LicensingUsageStatisticsEvent)) {
            return;
        }
        List<LicenseFile> licenseFiles = LicenseFileService.getLicenseFiles();
        for (LicenseFile licenseFile : licenseFiles) {
            String licenseProduct = licenseFile.getProduct();
            String licenseKey = licenseFile.getKey();
            Object object = this.lock;
            synchronized (object) {
                Set<String> keys = this.productsAndKeys.get(licenseProduct);
                if (keys == null) {
                    keys = new LinkedHashSet<String>();
                    this.productsAndKeys.put(licenseProduct, keys);
                }
                keys.add(licenseKey);
            }
        }
    }

    public Object retrieveAggregation() {
        return Collections.unmodifiableMap(this.productsAndKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(AbstractStatisticsAggregator aggregator) {
        if (!(aggregator instanceof LicenseKeysStatisticsAggregator)) {
            return;
        }
        Map<String, Set<String>> productsAndKeys = ((LicenseKeysStatisticsAggregator)aggregator).productsAndKeys;
        Object object = this.lock;
        synchronized (object) {
            MapUtil.merge(this.productsAndKeys, productsAndKeys, (el1, el2) -> {
                el1.addAll(el2);
                return el1;
            });
        }
    }
}

