/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.licensing.base.statistics.StatisticsEventSender;
import com.itextpdf.licensing.base.util.InterruptibleThread;
import org.slf4j.LoggerFactory;

final class StatisticsEventHandlerUtil {
    private static volatile Thread shutdownHook = null;
    private static volatile InterruptibleThread scheduledTask = null;
    private static final Object SHUTDOWN_HOOK_LOCK = new Object();
    private static final Object SCHEDULED_TASK_LOCK = new Object();

    private StatisticsEventHandlerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerProcessAllShutdownHook() {
        Object object = SHUTDOWN_HOOK_LOCK;
        synchronized (object) {
            if (shutdownHook != null) {
                return;
            }
            shutdownHook = new Thread(StatisticsEventSender::sendStatisticsOnExit);
            try {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            catch (SecurityException security) {
                LoggerFactory.getLogger(StatisticsEventHandlerUtil.class).error("Unable to register statistics event handler shutdown hook because of security reasons.");
                shutdownHook = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableShutdownHooks() {
        Object object = SHUTDOWN_HOOK_LOCK;
        synchronized (object) {
            if (shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                    shutdownHook = null;
                }
                catch (SecurityException security) {
                    LoggerFactory.getLogger(StatisticsEventHandlerUtil.class).error("Unable to unregister statistics event handler shutdown hook because of security permissions.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerTimedProcessing() {
        Object object = SCHEDULED_TASK_LOCK;
        synchronized (object) {
            if (scheduledTask != null) {
                return;
            }
            InterruptibleThread.InterruptibleTask task = new InterruptibleThread.InterruptibleTask(() -> StatisticsEventSender.trySendStatisticsAsync(false), () -> StatisticsEventSender.getWaitTime().getTime());
            scheduledTask = new InterruptibleThread(task);
            scheduledTask.setDaemon(true);
            scheduledTask.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableTimedProcessing() {
        Object object = SCHEDULED_TASK_LOCK;
        synchronized (object) {
            if (scheduledTask != null) {
                scheduledTask.interrupt();
                scheduledTask = null;
            }
        }
    }
}

