/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.LoggerFactory;

public final class PortingUtils {
    private PortingUtils() {
    }

    public static Map<String, Map<String, Map<String, Long>>> castJsonObjectToAlreadyReportedData(Object jsonObj) {
        return ((Map)jsonObj).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, fullEntry -> ((Map)fullEntry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, productEntry -> ((Map)productEntry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, eventEntry -> ((Number)eventEntry.getValue()).longValue()))))));
    }

    public static OutputStream createFileAppendOutputStream(String filePath) throws IOException {
        return Files.newOutputStream(Paths.get(filePath, new String[0]), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    public static File constructFileByDirectoryAndName(String directory, String fileName) {
        return new File(directory, fileName);
    }

    public static Scanner createLineReader(String filePath, Charset charset) throws IOException {
        return new Scanner(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]), charset.name());
    }

    public static String getDirectoryFullPath(String localFileRootDir) {
        return new File(localFileRootDir).getAbsolutePath();
    }

    public static void compressFiles(List<String> toCompress, String archivePath) {
        try {
            try (ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(archivePath), StandardCharsets.UTF_8);){
                zos.setMethod(8);
                zos.setLevel(9);
                for (String filePath : toCompress) {
                    File fileToZip = new File(filePath);
                    FileInputStream fis = new FileInputStream(fileToZip);
                    Throwable throwable = null;
                    try {
                        int length;
                        ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                        zos.putNextEntry(zipEntry);
                        byte[] bytes = new byte[1024];
                        while ((length = fis.read(bytes)) > 0) {
                            zos.write(bytes, 0, length);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                    }
                }
            }
            for (String filePath : toCompress) {
                FileUtil.deleteFile((File)new File(filePath));
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PortingUtils.class).error(MessageFormatUtil.format((String)"Files compression failed. Exception message: {0}.", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static String getUtcTimestamp(long millis) {
        long offset = TimeZone.getDefault().getOffset(millis);
        return new Timestamp(millis - offset).toString().split("\\.")[0];
    }

    public static String getSystemInfo() {
        return "java_version: " + System.getProperty("java.version") + ", java_vm_version: " + System.getProperty("java.vm.version");
    }

    public static boolean canReadAndWriteInDirectory(String directoryPath) {
        Path filePath = new File(directoryPath).toPath();
        return Files.isReadable(filePath) && Files.isWritable(filePath);
    }

    public static MessageDigest createMd5HashAlgorithm() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }
}

