/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.reporting.AbstractLocalFileServer;
import com.itextpdf.licensing.base.reporting.DataWithHash;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.LocalFileServerHelperKeeper;
import com.itextpdf.licensing.base.reporting.ProductLimitsRequest;
import com.itextpdf.licensing.base.reporting.ProductLimitsResponse;
import com.itextpdf.licensing.base.reporting.ReportMetadata;
import com.itextpdf.licensing.base.reporting.serverstatus.LicenseServerHealthStatus;
import com.itextpdf.licensing.base.reporting.volume.ProductUsage;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataAggregator;
import com.itextpdf.licensing.base.util.CollectionUtil;
import com.itextpdf.licensing.base.util.JsonMapperUtil;
import com.itextpdf.licensing.base.util.PortingUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

final class LocalFileLicenseServer
extends AbstractLocalFileServer<ProductUsage>
implements ILicenseServer {
    public static final String ALREADY_REPORTED_DATA_KEY = "alreadyReportedData";
    public static final String DISCLAIMER = "Please note that the information collected by iText Volume Reporting Mechanism is in human-readable form and available for inspection right in this file. The Volume Records contain timestamps and hashes which do not contain meaningful information about the environment and are used purely for technical purposes. Please refer to the SLA at https://itextpdf.com/legal";
    public static final String REPORT_FILE_PREFIX = "itext_volume_data_";
    public static final String REPORT_FILE_EXTENSION = "ulvd";
    private static LocalFileLicenseServer instance;
    private final Map<String, Map<String, Map<String, AtomicLong>>> reportedEvents = new ConcurrentHashMap<String, Map<String, Map<String, AtomicLong>>>();

    static LocalFileLicenseServer getInstance() {
        if (instance == null) {
            instance = new LocalFileLicenseServer();
        } else {
            instance.updateConfig();
        }
        try {
            String healthCheckTime = LocalFileServerHelperKeeper.getHelper().getCurrentTime();
            List<ProductUsage> healthCheckUsage = VolumeDataAggregator.createHealthCheckUsage(healthCheckTime);
            if (!instance.write(healthCheckUsage)) {
                throw new LicenseKeyException("Unable to write usage to the local server.");
            }
        }
        catch (Exception e) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Health check writing failed. Exception message: \"{0}\".", (Object[])new Object[]{e.getMessage()}), e);
        }
        return instance;
    }

    private LocalFileLicenseServer() {
    }

    @Override
    public boolean write(List<ProductUsage> usageList) {
        boolean writingSucceed = super.writeData(usageList);
        if (writingSucceed) {
            this.updateReportedEvents(usageList);
        }
        return writingSucceed;
    }

    @Override
    public List<ProductLimitsResponse> getRemainingEvents(List<ProductLimitsRequest> requestList) {
        ArrayList<ProductLimitsResponse> responseList = new ArrayList<ProductLimitsResponse>(requestList.size());
        for (ProductLimitsRequest request : requestList) {
            Map<String, AtomicLong> events = this.getReportedEventsForProduct(request.getLicenseKey(), request.getProductName());
            LinkedHashMap<String, Long> eventsResponse = new LinkedHashMap<String, Long>();
            Map<String, Long> requestLimits = request.getLimits();
            for (Map.Entry<String, Long> entry : requestLimits.entrySet()) {
                String eventType = entry.getKey();
                if ("default".equals(eventType)) continue;
                long reported = events.containsKey(eventType) ? events.get(eventType).get() : 0L;
                eventsResponse.put(eventType, (Long)entry.getValue() - reported);
            }
            Long defaultLimit = requestLimits.get("default");
            if (defaultLimit != null) {
                Map.Entry<String, Long> entry;
                entry = events.entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)entry.next();
                    String eventType = (String)entry2.getKey();
                    if (requestLimits.containsKey(eventType)) continue;
                    eventsResponse.put(eventType, defaultLimit - events.get(eventType).get());
                }
            }
            ProductLimitsResponse response = new ProductLimitsResponse(request.getLicenseKey(), request.getProductName(), eventsResponse);
            responseList.add(response);
        }
        return responseList;
    }

    @Override
    public LicenseServerHealthStatus healthCheck() {
        return LicenseServerHealthStatus.HEALTHY;
    }

    @Override
    protected String getDisclaimer() {
        return DISCLAIMER;
    }

    @Override
    protected String getReportFilePrefix() {
        return REPORT_FILE_PREFIX;
    }

    @Override
    protected String getReportFileExtension() {
        return REPORT_FILE_EXTENSION;
    }

    @Override
    protected void processMetadata(ReportMetadata metadata) {
        super.processMetadata(metadata);
        this.clear();
        Map<String, Object> sequenceData = metadata.getSequenceData();
        if (sequenceData == null || sequenceData.get(ALREADY_REPORTED_DATA_KEY) == null) {
            return;
        }
        Map<String, Map<String, Map<String, Long>>> previousReportedEvents = PortingUtils.castJsonObjectToAlreadyReportedData(sequenceData.get(ALREADY_REPORTED_DATA_KEY));
        for (Map.Entry<String, Map<String, Map<String, Long>>> licenseEntry : previousReportedEvents.entrySet()) {
            ConcurrentHashMap products = new ConcurrentHashMap();
            this.reportedEvents.put(licenseEntry.getKey(), products);
            for (Map.Entry<String, Map<String, Long>> productEntry : licenseEntry.getValue().entrySet()) {
                ConcurrentHashMap<String, AtomicLong> events = new ConcurrentHashMap<String, AtomicLong>();
                products.put(productEntry.getKey(), events);
                for (Map.Entry<String, Long> eventsEntry : productEntry.getValue().entrySet()) {
                    events.put(eventsEntry.getKey(), new AtomicLong(eventsEntry.getValue()));
                }
            }
        }
    }

    @Override
    protected void processLine(String json) {
        super.processLine(json);
        if (json.startsWith("\"") && json.endsWith("\"")) {
            return;
        }
        DataWithHash<ProductUsage> dataWithHash = JsonMapperUtil.deserializeDataWithHashProductUsageFromString(json);
        if (dataWithHash == null) {
            throw new LicenseKeyException("Unable to deserialize report file data line.");
        }
        this.updateReportedEvents(dataWithHash.getData());
    }

    @Override
    protected void resetSequenceData() {
        this.clear();
        super.resetSequenceData();
    }

    @Override
    protected void setNewFileSequenceData() {
        this.clear();
        super.setNewFileSequenceData();
    }

    @Override
    protected Map<String, Object> calculateSequenceData() {
        TreeMap copyReportedEvents = new TreeMap();
        for (Map.Entry<String, Map<String, Map<String, AtomicLong>>> licenseEntry : this.reportedEvents.entrySet()) {
            TreeMap productsMap = new TreeMap();
            copyReportedEvents.put(licenseEntry.getKey(), productsMap);
            for (Map.Entry<String, Map<String, AtomicLong>> productEntry : licenseEntry.getValue().entrySet()) {
                TreeMap<String, Long> eventsMap = new TreeMap<String, Long>();
                productsMap.put(productEntry.getKey(), eventsMap);
                for (Map.Entry<String, AtomicLong> eventsEntry : productEntry.getValue().entrySet()) {
                    eventsMap.put(eventsEntry.getKey(), eventsEntry.getValue().get());
                }
            }
        }
        if (copyReportedEvents.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> sequenceData = new TreeMap<String, Object>();
        sequenceData.put(ALREADY_REPORTED_DATA_KEY, copyReportedEvents);
        return sequenceData;
    }

    static void resetInstance() {
        instance = null;
    }

    private void clear() {
        if (this.reportedEvents != null) {
            this.reportedEvents.clear();
        }
    }

    private Map<String, AtomicLong> getReportedEventsForProduct(String licenseKey, String productName) {
        Map<String, Map<String, AtomicLong>> products = this.reportedEvents.get(licenseKey);
        Map<String, AtomicLong> events = null;
        if (products != null) {
            events = products.get(productName);
        }
        if (events == null) {
            events = CollectionUtil.emptyMap();
        }
        return events;
    }

    private void updateReportedEvents(List<ProductUsage> usageList) {
        for (ProductUsage usage : usageList) {
            Map<String, AtomicLong> events;
            Map<String, Map<String, AtomicLong>> products = this.reportedEvents.get(usage.getLicenseKey());
            if (products == null) {
                products = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
                this.reportedEvents.put(usage.getLicenseKey(), products);
            }
            if ((events = products.get(usage.getProductName())) == null) {
                events = new ConcurrentHashMap<String, AtomicLong>();
                products.put(usage.getProductName(), events);
            }
            for (Map.Entry<String, Long> entry : usage.getEvents().entrySet()) {
                Long wrapperValue = entry.getValue();
                long longValue = wrapperValue;
                String eventType = entry.getKey();
                if (events.containsKey(eventType)) {
                    events.get(eventType).addAndGet(longValue);
                    continue;
                }
                events.put(eventType, new AtomicLong(longValue));
            }
        }
    }
}

