/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.storage;

import com.itextpdf.licensing.base.storage.DefaultLicenseFileStorageClient;
import com.itextpdf.licensing.base.storage.ILicenseFileStorageClient;
import com.itextpdf.licensing.base.storage.LicenseFilesCache;
import com.itextpdf.licensing.base.storage.RemoteLicenseFileStorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseFilesCacheKeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseFilesCacheKeeper.class);
    private static LicenseFilesCache licenseFilesCache = null;

    private LicenseFilesCacheKeeper() {
    }

    public static LicenseFilesCache getLicenseFilesCache() {
        if (licenseFilesCache == null) {
            licenseFilesCache = LicenseFilesCacheKeeper.initDefaultLicenseFilesCache();
        }
        return licenseFilesCache;
    }

    static void resetLicenseFilesCache() {
        licenseFilesCache = null;
    }

    static void setLicenseFilesCache(LicenseFilesCache licenseFilesCache) {
        LicenseFilesCacheKeeper.licenseFilesCache = licenseFilesCache;
    }

    private static LicenseFilesCache initDefaultLicenseFilesCache() {
        ILicenseFileStorageClient storageRetriever;
        try {
            storageRetriever = new RemoteLicenseFileStorageClient();
        }
        catch (NoClassDefFoundError error) {
            LOGGER.info("The automatic updates of license files is not available. The 'licensing-remote' library is required for this functionality, but it is missing or outdated. Please add or update this library if you need the automatic updates of license files.");
            storageRetriever = new DefaultLicenseFileStorageClient();
        }
        return new LicenseFilesCache(3600000L, storageRetriever);
    }
}

