/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.strategy;

import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.strategy.IStrategy;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeWrapperStrategy
implements IStrategy {
    private final IStrategy strategy;
    private final AtomicLong lastMethodCallTime = new AtomicLong(Long.MIN_VALUE);

    public TimeWrapperStrategy(IStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void onFailure() {
        this.lastMethodCallTime.set(SystemUtil.getRelativeTimeMillis());
        this.strategy.onFailure();
    }

    @Override
    public void onSuccess() {
        this.lastMethodCallTime.set(SystemUtil.getRelativeTimeMillis());
        this.strategy.onSuccess();
    }

    @Override
    public void onProcessing() {
        this.strategy.onProcessing();
    }

    public long getLastMethodCallTime() {
        return this.lastMethodCallTime.get();
    }
}

