/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PageSet;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContainer;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.positioner.DrawPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

public class PageArea
extends SubFormPositioner {
    protected static final JsContainer pageareaJsObject = new JsContainer("pageArea");
    protected int currentContentAreaInd = 0;
    protected List<ContentArea> contentAreas = new ArrayList<ContentArea>();
    protected Rectangle pageSize = null;
    private int maxOccur = Integer.MAX_VALUE;
    private int occured = 0;
    private PageSet parentPageSet;

    public PageArea(XFATemplateTag templateTag, JsNode parentNode, DataTag dataTag, FlattenerContext flattenerContext) {
        super(templateTag, dataTag, flattenerContext, parentNode);
        List<Tag> mediumTags;
        this.setPrototype((Scriptable)pageareaJsObject);
        this.maxOccur = this.template.getMaxOccur();
        if (parentNode instanceof PageSet) {
            this.parentPageSet = (PageSet)parentNode;
        }
        if ((mediumTags = this.template.getChildren("medium")) != null && mediumTags.size() > 0) {
            Tag mediumTag = mediumTags.get(0);
            Map<String, String> attributes = mediumTag.getAttributes();
            String stockValue = XFAUtil.getAttributeValue("stock", attributes);
            String orientationValue = XFAUtil.getAttributeValue("orientation", attributes);
            if (orientationValue != null && !"portrait".equals(orientationValue)) {
                stockValue = stockValue + "_" + orientationValue;
            }
            if (stockValue != null) {
                try {
                    this.pageSize = PageSize.getRectangle(stockValue);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (this.pageSize == null) {
                String shortValue = XFAUtil.getAttributeValue("short", attributes);
                String longValue = XFAUtil.getAttributeValue("long", attributes);
                float sh = CssUtils.getInstance().parsePxInCmMmPcToPt(shortValue);
                float ln = CssUtils.getInstance().parsePxInCmMmPcToPt(longValue);
                if (orientationValue == null || "portrait".equals(orientationValue)) {
                    this.pageSize = PageSize.getRectangle(Float.toString(sh) + " " + Float.toString(ln));
                } else if ("landscape".equals(orientationValue)) {
                    this.pageSize = PageSize.getRectangle(Float.toString(ln) + " " + Float.toString(sh));
                }
            }
        }
        if (this.pageSize == null) {
            this.pageSize = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            PdfRectangle pdfRect = new PdfRectangle(this.pageSize, this.pageSize.getRotation());
            this.pageSize = pdfRect.getRectangle();
        }
        this.setRole(PdfName.ARTIFACT);
    }

    public int getOccured() {
        return this.occured;
    }

    public int getMaxOccur() {
        return this.maxOccur;
    }

    public void setMaxOccur(int maxOccur) {
        this.maxOccur = maxOccur;
    }

    public void setOccured(int occured) {
        this.occured = occured;
    }

    public void incOccured() {
        ++this.occured;
    }

    public int getCurrentContentAreaInd() {
        return this.currentContentAreaInd;
    }

    public PageArea setCurrentContentAreaInd(int currentContentAreaInd) {
        this.currentContentAreaInd = currentContentAreaInd;
        return this;
    }

    public PageSet getParentPageSet() {
        return this.parentPageSet;
    }

    @Override
    public String getClassName() {
        return "pageArea";
    }

    @Override
    public void initContentArea(Float parentLlx, Float parentUry) {
        if (parentLlx == null) {
            parentLlx = Float.valueOf(0.0f);
        }
        if (parentUry == null) {
            parentUry = Float.valueOf(this.pageSize.getHeight());
        }
        this.contentArea = new XFARectangle(parentLlx, parentUry, Float.valueOf(this.pageSize.getWidth()), Float.valueOf(this.pageSize.getHeight()));
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public ContentArea getCurrentContentArea() {
        if (this.currentContentAreaInd != -1 && this.currentContentAreaInd < this.contentAreas.size()) {
            return this.contentAreas.get(this.currentContentAreaInd);
        }
        return null;
    }

    public PageArea setCurrentContentArea(ContentArea contentArea) {
        int ind = this.contentAreas.indexOf(contentArea);
        if (ind != -1) {
            this.currentContentAreaInd = ind;
        }
        return this;
    }

    public ContentArea getNextContentArea() {
        int nextContentAreaInd = this.currentContentAreaInd + 1;
        if (nextContentAreaInd >= this.contentAreas.size()) {
            return null;
        }
        return this.contentAreas.get(nextContentAreaInd);
    }

    @Override
    public void addChild(JsTree child) {
        super.addChild(child);
        if (child instanceof ContentArea) {
            ContentArea contentArea = (ContentArea)child;
            contentArea.setPageArea(this);
            contentArea.getRect().setLlx(Float.valueOf(XFAUtil.reverseX(Float.valueOf(this.pageSize.getLeft()), contentArea.getRect().getLlx())));
            contentArea.getRect().setUry(Float.valueOf(XFAUtil.reverseY(Float.valueOf(this.pageSize.getHeight()), contentArea.getRect().getUry(), Float.valueOf(0.0f))));
            this.contentAreas.add(contentArea);
        }
    }

    public int indexOf(ContentArea nextContentArea) {
        return this.contentAreas.indexOf(nextContentArea);
    }

    @Override
    protected void populateCanvases(PdfContentByte parentCanvas) {
        ArrayList<PdfContentByte> drawCanvases = new ArrayList<PdfContentByte>();
        for (Positioner p : this.childElements) {
            if (!p.isVisible() && !p.isInvisible() || p instanceof SubFormPositioner) continue;
            p.setCanvas(parentCanvas.getDuplicate(true));
            if (p instanceof DrawPositioner) {
                drawCanvases.add(p.getCanvas());
                continue;
            }
            this.canvases.add(p.getCanvas());
        }
        this.canvases.addAll(0, drawCanvases);
        super.populateCanvases(parentCanvas);
    }

    public static boolean arePartsOfDifferentPageSets(PageArea first, PageArea second) {
        PageSet firstPS = first != null ? first.getParentPageSet() : null;
        PageSet secondPs = second != null ? second.getParentPageSet() : null;
        return firstPS != secondPs;
    }
}

