/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.positioner;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.TabSettings;
import com.itextpdf.text.TabStop;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.XFAConstants;
import com.itextpdf.tool.xml.xtra.xfa.bind.DataBindReference;
import com.itextpdf.tool.xml.xtra.xfa.bind.DataTreeResolver;
import com.itextpdf.tool.xml.xtra.xfa.bind.DataTreeResolverContext;
import com.itextpdf.tool.xml.xtra.xfa.element.ButtonElement;
import com.itextpdf.tool.xml.xtra.xfa.element.CheckButtonElement;
import com.itextpdf.tool.xml.xtra.xfa.element.TextDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.TextEditElement;
import com.itextpdf.tool.xml.xtra.xfa.element.TextElement;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContainer;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContent;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.pipe.FormBuilder;
import com.itextpdf.tool.xml.xtra.xfa.positioner.ContentPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.ExclGroupPositioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldPositioner
extends ContentPositioner {
    protected static final JsContainer fieldJsObject = new JsContainer("field");
    private static final Logger LOGGER;
    private Map<String, JsContent> displayItemElements = new HashMap<String, JsContent>();
    private List<String> boundItemValues = new ArrayList<String>();

    public FieldPositioner(XFATemplateTag templateTag, DataTag dataTag, JsNode parent, FlattenerContext flattenerContext) {
        super(templateTag, dataTag, flattenerContext, parent);
        this.setPrototype((Scriptable)fieldJsObject);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        Object prevValue = this.getRawValue();
        super.put(name, start, value);
        if ("rawValue".equals(name)) {
            this.propagateValueToParentIfNeeded(value, prevValue);
        }
    }

    @Override
    protected void putCallback(String name, Object value) {
        super.putCallback(name, value);
        if ("rawValue".equals(name) && "".equals(value) && !FormBuilder.isNoneDataRef(this.template)) {
            this.defineProperty("rawValue", null);
        }
    }

    @Override
    public boolean isBreakable() {
        if (this.keepConditions == null) {
            return this.uiElement instanceof TextEditElement && "textEdit".equals(this.uiElement.getTagName()) || this.contentElement instanceof TextElement;
        }
        return this.keepConditions.getIntact().equals("none");
    }

    public void clearItems() {
        Object itemsProp;
        if (FieldPositioner.hasProperty((Scriptable)this, (String)"items") && (itemsProp = this.getProperty("items")) instanceof RhinoJsNodeList) {
            FieldPositioner.deleteProperty((Scriptable)this, (String)"items");
            RhinoJsNodeList nodes = this.getNodes();
            for (long ind = nodes.getLength() - 1L; ind >= 0L; --ind) {
                if (nodes.get(ind) != ((RhinoJsNodeList)((Object)itemsProp)).get(0) && nodes.get(ind) != ((RhinoJsNodeList)((Object)itemsProp)).get(1)) continue;
                nodes.delete((int)ind);
            }
        }
        this.boundItemValues.clear();
        this.displayItemElements.clear();
    }

    private DataTag createDisplayItemsTag() {
        DataTag itemsDataTag = new DataTag("items");
        itemsDataTag.getAttributes().put("save", "0");
        itemsDataTag.getAttributes().put("presence", "visible");
        itemsDataTag.getAttributes().put("id", "items");
        return itemsDataTag;
    }

    private DataTag createBoundItemsTag() {
        DataTag itemBoundValuesDataTag = new DataTag("items");
        itemBoundValuesDataTag.getAttributes().put("save", "1");
        itemBoundValuesDataTag.getAttributes().put("presence", "hidden");
        itemBoundValuesDataTag.getAttributes().put("id", "items");
        return itemBoundValuesDataTag;
    }

    public void addItem(String value, Object boundValue) {
        if (!FieldPositioner.hasProperty((Scriptable)this, (String)"items")) {
            JsNode itemsNode = new JsNode(this.createDisplayItemsTag(), this, JsNode.getNotNullXFAPrototype("items"));
            JsNode itemBoundValuesNode = new JsNode(this.createBoundItemsTag(), this, JsNode.getNotNullXFAPrototype("items"));
            this.addChild(itemsNode);
            this.addChild(itemBoundValuesNode);
        }
        RhinoJsNodeList items = (RhinoJsNodeList)((Object)this.getProperty("items"));
        JsNode itemsNode = (JsNode)items.get(0);
        JsNode itemsBoundValuesNode = (JsNode)items.get(1);
        JsContent viewValueElement = new JsContent("text", itemsNode, JsNode.textJsObject, value);
        itemsNode.addChild(viewValueElement);
        if (this.isUndefined(boundValue) || !(boundValue instanceof String) || ((String)boundValue).isEmpty()) {
            boundValue = value;
        }
        JsContent boundValueElement = new JsContent("text", itemsBoundValuesNode, JsNode.textJsObject, (String)boundValue);
        itemsBoundValuesNode.addChild(boundValueElement);
        this.displayItemElements.put((String)boundValue, viewValueElement);
        this.boundItemValues.add((String)boundValue);
    }

    public String getDisplayItem(int index) {
        if (index < this.boundItemValues.size()) {
            String boundItem = this.boundItemValues.get(index);
            return this.displayItemElements.get(boundItem) != null ? this.displayItemElements.get(boundItem).getStringProperty("value") : null;
        }
        return null;
    }

    public String getSaveItem(int index) {
        if (index < this.boundItemValues.size()) {
            return this.boundItemValues.get(index);
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            this.clearItems();
        } else if (index >= 0 && index < this.boundItemValues.size()) {
            this.setRawValue(this.boundItemValues.get(index));
        }
    }

    public int getSelectedIndex() {
        Object rawValue = this.getRawValue();
        if (rawValue instanceof String) {
            return this.boundItemValues.indexOf(rawValue);
        }
        return -1;
    }

    public int getLength() {
        return this.boundItemValues.size();
    }

    public void setFontColor(String color) {
        JsNode fontNode = (JsNode)this.get("font", (Scriptable)this);
        JsNode fillNode = (JsNode)fontNode.get("fill", (Scriptable)fontNode);
        JsNode colorNode = (JsNode)fillNode.get("color", (Scriptable)fillNode);
        colorNode.defineProperty("value", color);
    }

    public String getFontColor() {
        FormNode colorNode;
        FormNode fillNode;
        FormNode fontNode = this.retrieveChild("font");
        if (fontNode != null && (fillNode = fontNode.retrieveChild("fill")) != null && (colorNode = fillNode.retrieveChild("color")) != null) {
            return colorNode.retrieveAttribute("value");
        }
        return null;
    }

    @Override
    public void addChild(Tag tag) {
        if ("items".equals(tag.getName())) {
            if (!FieldPositioner.hasProperty((Scriptable)this, (String)"items")) {
                JsNode itemsNode = new JsNode(this.createDisplayItemsTag(), this, (JsNode)nodes.get("items"));
                JsNode itemsBoundValuesNode = new JsNode(this.createBoundItemsTag(), this, (JsNode)nodes.get("items"));
                List<Tag> tagItemsNodes = tag.getParent().getChildren("items");
                if (tagItemsNodes.size() > 0 && tagItemsNodes.get(0) != null) {
                    List<Tag> itemValuesChildren = tagItemsNodes.get(0).getChildren();
                    for (int childIndex = 0; childIndex < itemValuesChildren.size(); ++childIndex) {
                        List<Tag> itemBoundValuesChildren;
                        Tag childItemTag = itemValuesChildren.get(childIndex);
                        JsContent contentElement = new JsContent(childItemTag, itemsNode, JsNode.getNotNullXFAPrototype(childItemTag.getName()));
                        itemsNode.addChild(contentElement);
                        boolean addedBoundValue = false;
                        if (tagItemsNodes.size() == 2 && tagItemsNodes.get(1) != null && childIndex < (itemBoundValuesChildren = tagItemsNodes.get(1).getChildren()).size()) {
                            XFATemplateTag childBoundValueTag = (XFATemplateTag)itemBoundValuesChildren.get(childIndex);
                            JsContent boundContentElement = new JsContent(childBoundValueTag, itemsNode, JsNode.getNotNullXFAPrototype(childBoundValueTag.getName()));
                            itemsBoundValuesNode.addChild(boundContentElement);
                            List<String> content = childBoundValueTag.getContent();
                            String contentStr = "";
                            if (content != null && !content.isEmpty() && content.get(0) != null) {
                                contentStr = content.get(0);
                            }
                            this.displayItemElements.put(contentStr, contentElement);
                            this.boundItemValues.add(contentStr);
                            addedBoundValue = true;
                        }
                        if (addedBoundValue) continue;
                        this.displayItemElements.put(contentElement.getStringProperty("value"), contentElement);
                        this.boundItemValues.add(contentElement.getStringProperty("value"));
                        itemsBoundValuesNode.addChild(new JsContent(childItemTag, itemsBoundValuesNode, JsNode.getNotNullXFAPrototype(childItemTag.getName())));
                    }
                }
                this.addChild(itemsNode);
                this.addChild(itemsBoundValuesNode);
            }
        } else {
            super.addChild(tag);
        }
    }

    @Override
    public String getClassName() {
        return "field";
    }

    @Override
    public void initValues() {
        Object rawValue = null;
        if (this.isCheckButtonInsideRadioButtonList()) {
            DataTag parentData;
            if (!(this.data == null || this.data.isFictive() || this.data.getRichText() != null && this.data.getRichText().size() != 0)) {
                rawValue = this.data.getValue();
                if (rawValue instanceof String && ((String)rawValue).isEmpty()) {
                    rawValue = null;
                } else {
                    this.inputParsingPattern = this.data.getCanonizationPattern();
                }
            }
            String parentDataValue = null;
            if (!(rawValue != null || this.parent.getData() == null || this.parent.getData().isFictive() || (parentData = this.parent.getData()).getRichText() != null && parentData.getRichText().size() != 0)) {
                parentDataValue = parentData.getValue();
                if (this.correspondsToOnValue(parentDataValue)) {
                    rawValue = parentDataValue;
                }
                this.inputParsingPattern = parentData.getCanonizationPattern();
            }
            if (rawValue != null) {
                this.setRawValue(rawValue);
            } else if (parentDataValue == null) {
                super.initValues();
            }
        } else if (this.data != null && !this.data.isFictive()) {
            if (this.data.getRichText() != null && this.data.getRichText().size() > 0) {
                rawValue = this.data.getRichText();
            } else {
                List<Tag> valueChildren = this.data.getChildren("value");
                if (valueChildren.size() > 0) {
                    StringBuffer strBuff = new StringBuffer();
                    for (Tag valueChild : valueChildren) {
                        if (!(valueChild instanceof DataTag)) continue;
                        String curValue = ((DataTag)valueChild).getValue();
                        if (strBuff.length() != 0 && curValue != null && curValue.length() != 0) {
                            strBuff.append("\n");
                        }
                        if (curValue == null || curValue.length() == 0) continue;
                        strBuff.append(curValue);
                    }
                    rawValue = strBuff.toString();
                } else {
                    rawValue = this.data.getValue();
                }
                if (rawValue instanceof String && ((String)rawValue).isEmpty()) {
                    rawValue = null;
                }
                this.inputParsingPattern = this.data.getCanonizationPattern();
            }
            this.setRawValue(rawValue);
        } else {
            super.initValues();
        }
        this.applySetPropertyTags();
    }

    boolean correspondsToOnValue(Object rawValue) {
        boolean newValueCorrespondsToOnValue;
        if (rawValue == null) {
            return false;
        }
        String onValue = CheckButtonElement.getOnValue(this.template);
        boolean bl = newValueCorrespondsToOnValue = rawValue instanceof String && rawValue.equals(onValue);
        if (!newValueCorrespondsToOnValue && rawValue instanceof Double && onValue != null) {
            try {
                double onValueAsNumber = Double.parseDouble(onValue);
                newValueCorrespondsToOnValue = (Double)rawValue == onValueAsNumber;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return newValueCorrespondsToOnValue;
    }

    protected boolean isCheckButtonInsideRadioButtonList() {
        Tag uiTag;
        if (this.parent instanceof ExclGroupPositioner && (uiTag = this.template.getChild("ui", "", false)) != null && uiTag.getChildren() != null && uiTag.getChildren().size() > 0) {
            Tag uiElementTag = uiTag.getChildren().get(0);
            String uiElementName = uiElementTag.getName();
            return uiElementName.equalsIgnoreCase("checkButton");
        }
        return false;
    }

    @Override
    protected XFARectangle getTextArea() {
        return this.contentElement != null ? this.contentElement.getElementRec() : this.getElementArea(this.contentArea);
    }

    @Override
    protected TextElement createChoiceListTextContentElement(FormNode uiElementTag, XFARectangle textElementRect) {
        if (this.template == null) {
            return this.createTextContentElement();
        }
        String openAttribute = uiElementTag.retrieveAttribute("open");
        if ("multiSelect".equals(openAttribute) || "always".equals(openAttribute)) {
            int minDisplayItemIndex;
            HashSet<String> selectedBoundValues = new HashSet<String>();
            Object rawValue = this.getRawValue();
            String firstSelectedBoundValue = null;
            if (rawValue instanceof String && !((String)rawValue).isEmpty()) {
                List<String> selectedBoundValuesList = Arrays.asList(((String)rawValue).split("\n"));
                if (selectedBoundValuesList.size() > 0) {
                    firstSelectedBoundValue = selectedBoundValuesList.get(0);
                }
                selectedBoundValues.addAll(selectedBoundValuesList);
            }
            Chunk dummyChunk = new Chunk("choice list item");
            Phrase dummyPhrase = new Phrase(dummyChunk);
            TextElement dummyElement = new TextElement((FormNode)this.template, (JsNode)this, textElementRect, this.document, Arrays.asList(dummyPhrase), this.flattenerContext);
            dummyElement.createColumnText(textElementRect);
            final Font itemsFont = dummyElement.getTextDrawer().getContent().get(0).getChunks().get(0).getFont();
            final float leading = itemsFont.getSize() * XFAConstants.DEFAULT_LEADING_MULTIPLIER.floatValue();
            int itemsToFit = 0;
            if (this.getTextArea().getHeight().floatValue() >= itemsFont.getSize()) {
                itemsToFit = (int)((float)itemsToFit + (1.0f + (this.getTextArea().getHeight().floatValue() - itemsFont.getSize()) / leading));
            }
            int firstSelectedItemIndex = firstSelectedBoundValue != null ? this.boundItemValues.indexOf(firstSelectedBoundValue) : -1;
            int maxDisplayItemIndex = firstSelectedItemIndex != -1 ? firstSelectedItemIndex : Math.min(itemsToFit - 1, this.boundItemValues.size() - 1);
            int n = minDisplayItemIndex = firstSelectedItemIndex != -1 ? maxDisplayItemIndex - itemsToFit + 1 : 0;
            if (minDisplayItemIndex < 0) {
                int delta = -minDisplayItemIndex;
                minDisplayItemIndex += delta;
                maxDisplayItemIndex += delta;
            }
            final BaseColor itemSelectionColor = new BaseColor(155, 192, 218);
            TabStop tabStop = new TabStop(textElementRect.getWidth().floatValue(), new DrawInterface(){

                @Override
                public void draw(PdfContentByte canvas, float llx, float lly, float urx, float ury, float y) {
                    canvas.saveState();
                    canvas.setColorFill(itemSelectionColor);
                    canvas.rectangle(llx, lly - (leading - itemsFont.getSize()), urx - llx, leading);
                    canvas.fill();
                    canvas.restoreState();
                }
            });
            TabSettings tabSettings = new TabSettings(Arrays.asList(tabStop), 1.0f);
            ArrayList<Element> displayRichText = new ArrayList<Element>();
            int skippedItemsNumber = 0;
            for (int ind = minDisplayItemIndex; ind <= maxDisplayItemIndex && ind < this.boundItemValues.size(); ++ind) {
                String displayValue;
                String boundValue = this.boundItemValues.get(ind);
                JsContent displayValueElement = this.displayItemElements.get(boundValue);
                String string = displayValue = displayValueElement != null ? displayValueElement.getStringProperty("value") : boundValue;
                if (displayValue.length() > 0) {
                    Phrase itemPhrase = new Phrase();
                    String maxSingleLineDisplayValue = TextDrawer.getMaxSingleLineText(displayValue, textElementRect, this, this.document.getPageSize(), this.flattenerContext);
                    Chunk itemChunk = new Chunk(maxSingleLineDisplayValue);
                    if (selectedBoundValues.contains(this.boundItemValues.get(ind - skippedItemsNumber))) {
                        itemChunk.setBackground(itemSelectionColor, 0.0f, leading - itemsFont.getSize(), 0.0f, 0.0f);
                    }
                    itemPhrase.add(itemChunk);
                    if (selectedBoundValues.contains(this.boundItemValues.get(ind - skippedItemsNumber))) {
                        itemPhrase.setTabSettings(tabSettings);
                        Chunk tabChunk = new Chunk(Chunk.TABBING);
                        tabChunk.getAttributes().put("TABSETTINGS", tabSettings);
                        itemPhrase.add(tabChunk);
                    }
                    itemPhrase.add(new Chunk("\n"));
                    displayRichText.add(itemPhrase);
                    continue;
                }
                ++maxDisplayItemIndex;
                ++skippedItemsNumber;
            }
            return new TextElement((FormNode)this.template, (JsNode)this, textElementRect, this.document, displayRichText, this.flattenerContext);
        }
        Object formatRawValue = this.getFormattedValue();
        if (!(formatRawValue instanceof String)) {
            return this.createTextContentElement();
        }
        String boundValue = (String)formatRawValue;
        JsContent displayValueElement = this.displayItemElements.get(boundValue);
        String displayValue = displayValueElement != null ? displayValueElement.getStringProperty("value") : boundValue;
        return new TextElement((FormNode)this.template, (JsNode)this, textElementRect, this.document, displayValue, this.flattenerContext);
    }

    @Override
    public boolean supportLegacyPlusPrint() {
        return this.uiElement instanceof ButtonElement;
    }

    private void propagateValueToParentIfNeeded(Object value, Object prevValue) {
        if (this.isCheckButtonInsideRadioButtonList()) {
            ExclGroupPositioner exclGroupParent = (ExclGroupPositioner)this.parent;
            exclGroupParent.getValueResolver().propagateValueFromChildToParent(value, prevValue, this);
        }
    }

    private void applySetPropertyTags() {
        List<FormNode> setPropertyTags = this.template.retrieveChildren("setProperty");
        for (FormNode setPropertyTag : setPropertyTags) {
            String dataRef = setPropertyTag.retrieveAttribute("ref");
            String target = setPropertyTag.retrieveAttribute("target");
            if (target == null || dataRef == null || this.data == null) continue;
            ArrayList<Tag> propertyDataTags = new ArrayList<Tag>();
            DataBindReference reference = DataBindReference.createFromSom(dataRef);
            DataTreeResolver.fillDataList(propertyDataTags, reference, 0, this.data, false, new DataTreeResolverContext());
            target = target.replaceAll("\\.#", ".");
            if (propertyDataTags.size() <= 0 || !(propertyDataTags.get(0) instanceof DataTag)) continue;
            String value = ((DataTag)propertyDataTags.get(0)).getValue();
            StringBuilder script = new StringBuilder();
            script.append("resolveNode").append("(\"").append(target).append("\")").append(".value=").append("\"").append(value).append("\"").append(";");
            try {
                this.evaluateScript(script.toString());
            }
            catch (Exception e) {
                LOGGER.error("Could not evaluate <setProperty> declaration with generated script: " + script.toString(), (Throwable)e);
            }
        }
    }

    static {
        fieldJsObject.defineFunctionProperties(new String[]{"clearItems"}, FieldPositioner.class, 4);
        fieldJsObject.defineFunctionProperties(new String[]{"addItem"}, FieldPositioner.class, 4);
        fieldJsObject.defineFunctionProperties(new String[]{"getDisplayItem"}, FieldPositioner.class, 4);
        fieldJsObject.defineFunctionProperties(new String[]{"getSaveItem"}, FieldPositioner.class, 4);
        fieldJsObject.defineProperty("fontColor", FieldPositioner.class, 0);
        fieldJsObject.defineProperty("selectedIndex", FieldPositioner.class, 0);
        fieldJsObject.defineProperty("length", FieldPositioner.class, 0);
        LOGGER = LoggerFactory.getLogger(FieldPositioner.class);
    }
}

