/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.DriveRecipient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.IPermissionGrantCollectionRequest;
import com.microsoft.graph.requests.extensions.IPermissionGrantCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionGrantCollectionRequest;
import java.util.List;

public class PermissionGrantCollectionRequestBuilder
extends BaseActionRequestBuilder
implements IPermissionGrantCollectionRequestBuilder {
    public PermissionGrantCollectionRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, List<String> roles, List<DriveRecipient> recipients) {
        super(requestUrl, client, requestOptions);
        if (roles != null) {
            this.bodyParams.put("roles", roles);
        }
        if (recipients != null) {
            this.bodyParams.put("recipients", recipients);
        }
    }

    @Override
    public IPermissionGrantCollectionRequest buildRequest() {
        return this.buildRequest(this.getOptions());
    }

    @Override
    public IPermissionGrantCollectionRequest buildRequest(List<? extends Option> requestOptions) {
        PermissionGrantCollectionRequest request = new PermissionGrantCollectionRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("roles")) {
            request.body.roles = (List)this.getParameter("roles");
        }
        if (this.hasParameter("recipients")) {
            request.body.recipients = (List)this.getParameter("recipients");
        }
        return request;
    }
}

