/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteGetByPathRequest;
import java.util.List;

public class SiteGetByPathRequest
extends BaseRequest
implements ISiteGetByPathRequest {
    public SiteGetByPathRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    @Override
    public void patch(Site srcSite, ICallback<Site> callback) {
        this.send(HttpMethod.PATCH, callback, srcSite);
    }

    @Override
    public Site patch(Site srcSite) throws ClientException {
        return (Site)this.send(HttpMethod.PATCH, srcSite);
    }

    @Override
    public void put(Site srcSite, ICallback<Site> callback) {
        this.send(HttpMethod.PUT, callback, srcSite);
    }

    @Override
    public Site put(Site srcSite) throws ClientException {
        return (Site)this.send(HttpMethod.PUT, srcSite);
    }

    @Override
    public void get(ICallback<Site> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Site get() throws ClientException {
        return (Site)this.send(HttpMethod.GET, null);
    }

    @Override
    public ISiteGetByPathRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteGetByPathRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

