/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public class JVMLocator {
    private Log log;
    private MavenSession session;
    private ToolchainManager toolchainManager;
    private String jvm;

    public JVMLocator(MavenSession session, String jvm, ToolchainManager toolchainManager, Log log) {
        this.log = log;
        this.session = session;
        this.jvm = jvm;
        this.toolchainManager = toolchainManager;
    }

    public String locate() {
        String jvmToUse = this.jvm;
        Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            this.log.info((CharSequence)("Toolchain: " + toolchain));
            if (StringUtils.isEmpty((CharSequence)jvmToUse)) {
                jvmToUse = toolchain.findTool("java");
            } else {
                this.log.warn((CharSequence)("Toolchain ignored. Parameter 'jvm' was set to " + jvmToUse));
            }
        }
        if (StringUtils.isEmpty((CharSequence)jvmToUse)) {
            jvmToUse = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        this.log.debug((CharSequence)("Using JVM: " + jvmToUse));
        return jvmToUse;
    }

    protected Toolchain getToolchain() {
        Toolchain toolchain = null;
        if (this.toolchainManager != null && this.session != null) {
            toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return toolchain;
    }
}

