/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\f\u0010\u0017\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0019\u001a\u00020\r*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ChainWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "nextLineTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "noSpaceAroundTokens", "prefixTokens", "sameLineTokens", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isInPrefixPosition", "isPartOfSpread", "isPartOfWhenCondition", "ktlint-ruleset-standard"})
public final class ChainWrappingRule
extends Rule {
    private final TokenSet sameLineTokens;
    private final TokenSet prefixTokens;
    private final TokenSet nextLineTokens;
    private final TokenSet noSpaceAroundTokens;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        if (this.nextLineTokens.contains(elementType)) {
            ASTNode nextLeaf;
            if (PackageKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = PackageKt.nextCodeLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            ASTNode aSTNode2 = nextLeaf = aSTNode != null ? PackageKt.prevLeaf$default((ASTNode)aSTNode, (boolean)false, (int)1, null) : null;
            if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && nextLeaf.textContains('\n')) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not end with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode prevLeaf2 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
                    if (prevLeaf2 instanceof PsiWhiteSpace) {
                        ASTNode aSTNode3 = ((PsiWhiteSpace)prevLeaf2).getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"prevLeaf.node");
                        aSTNode3.getTreeParent().removeChild(((PsiWhiteSpace)prevLeaf2).getNode());
                    }
                    if (!this.noSpaceAroundTokens.contains(elementType)) {
                        ASTNode aSTNode4 = nextLeaf;
                        if (aSTNode4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                        }
                        PackageKt.upsertWhitespaceAfterMe((LeafElement)((LeafElement)aSTNode4), (String)" ");
                    }
                    node.getTreeParent().removeChild(node);
                    ASTNode aSTNode5 = nextLeaf;
                    if (aSTNode5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                    }
                    ((LeafElement)aSTNode5).rawInsertAfterMe((TreeElement)((LeafElement)node));
                }
            }
        } else if (this.sameLineTokens.contains(elementType) || this.prefixTokens.contains(elementType)) {
            ASTNode prevLeaf3;
            if (PackageKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = prevLeaf3 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            if (!(!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || !prevLeaf3.textContains('\n') || !(Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getMUL()) ^ true) && this.isPartOfSpread(prevLeaf3) || this.prefixTokens.contains(elementType) && this.isInPrefixPosition(node) || this.isPartOfWhenCondition(node))) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not begin with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode nextLeaf = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
                    if (nextLeaf instanceof PsiWhiteSpace) {
                        ASTNode aSTNode6 = ((PsiWhiteSpace)nextLeaf).getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode6, (String)"nextLeaf.node");
                        aSTNode6.getTreeParent().removeChild(((PsiWhiteSpace)nextLeaf).getNode());
                    }
                    ASTNode aSTNode7 = PackageKt.prevCodeLeaf$default((ASTNode)prevLeaf3, (boolean)false, (int)1, null);
                    if (aSTNode7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement insertionPoint = (LeafPsiElement)aSTNode7;
                    node.getTreeParent().removeChild(node);
                    insertionPoint.rawInsertAfterMe((TreeElement)((LeafPsiElement)node));
                    if (!this.noSpaceAroundTokens.contains(elementType)) {
                        PackageKt.upsertWhitespaceAfterMe((LeafElement)((LeafElement)insertionPoint), (String)" ");
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfSpread(ASTNode $this$isPartOfSpread) {
        ASTNode aSTNode = PackageKt.prevCodeLeaf$default((ASTNode)$this$isPartOfSpread, (boolean)false, (int)1, null);
        if (aSTNode == null) return false;
        ASTNode aSTNode2 = aSTNode;
        boolean bl = false;
        boolean bl2 = false;
        ASTNode leaf = aSTNode2;
        boolean bl3 = false;
        IElementType iElementType = leaf.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"leaf.elementType");
        IElementType type = iElementType;
        if (Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLPAR())) return true;
        if (Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getCOMMA())) return true;
        if (Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLBRACE())) return true;
        if (Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getELSE_KEYWORD())) return true;
        if (!KtTokens.OPERATIONS.contains(type)) return false;
        return true;
    }

    private final boolean isInPrefixPosition(ASTNode $this$isInPrefixPosition) {
        ASTNode aSTNode = $this$isInPrefixPosition.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getPREFIX_EXPRESSION());
    }

    private final boolean isPartOfWhenCondition(ASTNode $this$isPartOfWhenCondition) {
        ASTNode aSTNode = $this$isPartOfWhenCondition.getTreeParent();
        return Intrinsics.areEqual(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null, (Object)ElementType.INSTANCE.getWHEN_CONDITION_WITH_EXPRESSION());
    }

    public ChainWrappingRule() {
        super("chain-wrapping");
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getPERC(), ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getOROR()});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"TokenSet.create(MUL, DIV, PERC, ANDAND, OROR)");
        this.sameLineTokens = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getMINUS()});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"TokenSet.create(PLUS, MINUS)");
        this.prefixTokens = tokenSet2;
        TokenSet tokenSet3 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getELVIS()});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet3, (String)"TokenSet.create(DOT, SAFE_ACCESS, ELVIS)");
        this.nextLineTokens = tokenSet3;
        TokenSet tokenSet4 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS()});
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet4, (String)"TokenSet.create(DOT, SAFE_ACCESS)");
        this.noSpaceAroundTokens = tokenSet4;
    }
}

