/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson;

import com.thdjson.JSONDeserializerFeature;
import com.thdjson.JSONParser;
import com.thdjson.entity.JSONArray;
import com.thdjson.entity.JSONElement;
import com.thdjson.entity.JSONObject;
import com.thdjson.entity.JSONValue;
import com.thdjson.entity.JSONValueType;
import com.thdjson.exception.JSONDeserializerException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONDeserializer {
    private int features;

    public JSONDeserializer() {
        this.features = 0;
    }

    public JSONDeserializer(JSONDeserializerFeature ... features) {
        for (JSONDeserializerFeature feature : features) {
            this.features |= feature.getMask();
        }
    }

    public <T> T deserializeToObject(String json, Class<T> clazz) {
        JSONParser parser = new JSONParser(this.inFeatures(JSONDeserializerFeature.CaseInsensitive));
        return this.deserializeToObject(parser.parseObject(json), clazz);
    }

    public <T> T deserializeToObject(JSONObject jsonObject, Class<T> clazz) {
        if (jsonObject == null) {
            return null;
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || clazz.isArray()) {
            throw new JSONDeserializerException("wrong type: " + clazz);
        }
        T result = null;
        try {
            result = this.deserializeJsonObject(jsonObject, clazz);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JSONDeserializerException(e.getMessage());
        }
        return result;
    }

    public <T> Map<String, T> deserializeToMap(String json, Class<T> clazz) {
        JSONParser parser = new JSONParser(this.inFeatures(JSONDeserializerFeature.CaseInsensitive));
        return this.deserializeToMap(parser.parseObject(json), clazz);
    }

    public <T> Map<String, T> deserializeToMap(JSONObject jsonObject, Class<T> clazz) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (String key : jsonObject.keySet()) {
                JSONValue value = jsonObject.get(key);
                map.put(key, this.deserializeJsonValue(value, clazz));
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JSONDeserializerException(e.getMessage());
        }
        return map;
    }

    public Map<String, Object> deserializeToMap(String json, Class<?>[] clazz) {
        JSONParser parser = new JSONParser(this.inFeatures(JSONDeserializerFeature.CaseInsensitive));
        return this.deserializeToMap(parser.parseObject(json), clazz);
    }

    public Map<String, Object> deserializeToMap(JSONObject jsonObject, Class<?>[] clazz) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int i = 0;
            for (String key : jsonObject.keySet()) {
                JSONValue value = jsonObject.get(key);
                Class cla = i < clazz.length ? clazz[i++] : String.class;
                map.put(key, this.deserializeJsonValue(value, cla));
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JSONDeserializerException(e.getMessage());
        }
        return map;
    }

    public <T> T deserializeToArray(String json, Class<T> clazz) {
        JSONParser parser = new JSONParser(this.inFeatures(JSONDeserializerFeature.CaseInsensitive));
        return this.deserializeToArray(parser.parseArray(json), clazz);
    }

    public <T> T deserializeToArray(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return null;
        }
        if (!clazz.isArray()) {
            throw new JSONDeserializerException("wrong type: " + clazz);
        }
        T result = null;
        try {
            result = this.deserializeJsonArray(jsonArray, clazz);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JSONDeserializerException(e.getMessage());
        }
        return result;
    }

    public <T> List<T> deserializeToList(String json, Class<T> clazz) {
        JSONParser parser = new JSONParser(this.inFeatures(JSONDeserializerFeature.CaseInsensitive));
        return this.deserializeToList(parser.parseArray(json), clazz);
    }

    public <T> List<T> deserializeToList(JSONArray jsonArray, Class<T> clazz) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (JSONValue jsonValue : jsonArray) {
                list.add(this.deserializeJsonValue(jsonValue, clazz));
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JSONDeserializerException(e.getMessage());
        }
        return list;
    }

    private <T> T deserializeJsonArray(JSONArray jsonArray, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object array = Array.newInstance(clazz.getComponentType(), jsonArray.size());
        int i = 0;
        for (JSONValue jsonValue : jsonArray) {
            Array.set(array, i, this.deserializeJsonValue(jsonValue, clazz.getComponentType()));
            ++i;
        }
        return (T)array;
    }

    private <T> T deserializeJsonObject(JSONObject jsonObject, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Constructor<?>[] cons = clazz.getConstructors();
        Class<?>[] classes = cons[0].getParameterTypes();
        Object[] params = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isPrimitive()) {
                if (classes[i] == Boolean.TYPE) {
                    params[i] = false;
                    continue;
                }
                params[i] = 0;
                continue;
            }
            params[i] = null;
        }
        Object obj = cons[0].newInstance(params);
        Field[] fields = null;
        for (Class<T> cla = clazz; cla != Object.class; cla = cla.getSuperclass()) {
            for (Field field : fields = cla.getDeclaredFields()) {
                JSONValue JSONValue2;
                if (!this.inFeatures(JSONDeserializerFeature.AllowNonPublic) && (field.getModifiers() & 1) == 0) continue;
                String name = field.getName();
                JSONValue jSONValue = JSONValue2 = this.inFeatures(JSONDeserializerFeature.CaseInsensitive) ? jsonObject.get(name.toLowerCase()) : jsonObject.get(name);
                if (JSONValue2 == null) {
                    if (this.inFeatures(JSONDeserializerFeature.IgnoreNotMatch)) continue;
                    throw new JSONDeserializerException("field \"" + name + "\" cannot match");
                }
                Object val = this.deserializeJsonValue(JSONValue2, field.getType());
                field.setAccessible(true);
                field.set(obj, val);
            }
        }
        return (T)obj;
    }

    private Object deserializeJsonValue(JSONValue jsonValue, Class<?> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (jsonValue == null) {
            return null;
        }
        if (clazz == String.class) {
            if (jsonValue instanceof JSONElement) {
                return ((JSONElement)jsonValue).getString();
            }
            return jsonValue.toString();
        }
        JSONValueType type = jsonValue.getType();
        if (jsonValue instanceof JSONElement) {
            String value = ((JSONElement)jsonValue).getString();
            if (type == JSONValueType.INT) {
                if (clazz == BigInteger.class) {
                    return new BigInteger(value);
                }
                long val = Long.parseLong(value);
                if (clazz == Short.TYPE || clazz == Short.class) {
                    if (val < -32768L || val > 32767L) {
                        throw new JSONDeserializerException("short overflow: " + value);
                    }
                    return (short)val;
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
                        throw new JSONDeserializerException("int overflow: " + value);
                    }
                    return (int)val;
                }
                if (clazz == Byte.TYPE || clazz == Byte.TYPE) {
                    if (val < -128L || val > 127L) {
                        throw new JSONDeserializerException("byte overflow: " + value);
                    }
                    return (byte)val;
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return val;
                }
                if (clazz == Object.class) {
                    if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                        return (int)val;
                    }
                    return val;
                }
                throw new JSONDeserializerException("unknown type: " + clazz);
            }
            if (type == JSONValueType.FLOAT) {
                if (clazz == BigDecimal.class) {
                    return new BigDecimal(value);
                }
                double val = Double.parseDouble(value);
                if (clazz == Float.TYPE || clazz == Float.class) {
                    if (val < (double)1.4E-45f || val > 3.4028234663852886E38) {
                        throw new JSONDeserializerException("float overflow: " + value);
                    }
                    return Float.valueOf((float)val);
                }
                if (clazz == Double.TYPE || clazz == Double.class || clazz == Object.class) {
                    return val;
                }
                if (clazz == String.class) {
                    return value;
                }
                throw new JSONDeserializerException("unknown type: " + clazz);
            }
            if (type == JSONValueType.BOOL) {
                if (clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Object.class) {
                    return Boolean.parseBoolean(value);
                }
                throw new JSONDeserializerException("unknown type: " + clazz);
            }
            if (type == JSONValueType.STRING) {
                if ((clazz == Character.TYPE || clazz == Character.class) && value.length() == 1) {
                    return Character.valueOf(value.charAt(0));
                }
                if (clazz == String.class || clazz == Object.class) {
                    return value;
                }
                throw new JSONDeserializerException("unknown type: " + clazz);
            }
            if (type == JSONValueType.NULL && clazz.getSuperclass() == Object.class) {
                return null;
            }
            throw new JSONDeserializerException("unknown type: " + clazz);
        }
        if (jsonValue instanceof JSONArray) {
            return this.deserializeJsonArray((JSONArray)jsonValue, clazz);
        }
        if (jsonValue instanceof JSONObject) {
            return this.deserializeJsonObject((JSONObject)jsonValue, clazz);
        }
        throw new JSONDeserializerException("unknown type: " + clazz);
    }

    private boolean inFeatures(JSONDeserializerFeature feature) {
        return (this.features & feature.getMask()) == feature.getMask();
    }
}

