/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson;

import com.thdjson.JSONToken;
import com.thdjson.exception.JSONLexerException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class JSONLexer {
    private static final char EOI = '\u001a';
    private static final char[] FilterChar;
    private static final HashSet<Character> EndSigns;
    private static final Map<Character, Character> EscapeChars;
    private String jsonString;
    private int len;
    private int cur = -1;
    private JSONToken token;
    private char ch = '\u0000';
    private StringBuilder readBuffer = null;
    private static final int[] digits;

    public JSONLexer(String json) {
        this.jsonString = json;
        this.len = json.length();
    }

    public JSONToken nextToken() throws JSONLexerException {
        this.nextChar();
        while (this.include(FilterChar, this.ch) || this.ch == '\n') {
            this.nextChar();
        }
        if (this.isEOF()) {
            this.token = null;
        } else if (this.ch == '{') {
            this.token = JSONToken.LBRACE;
        } else if (this.ch == '}') {
            this.token = JSONToken.RBRACE;
        } else if (this.ch == '[') {
            this.token = JSONToken.LBRACKET;
        } else if (this.ch == ']') {
            this.token = JSONToken.RBRACKET;
        } else if (this.ch == ':') {
            this.token = JSONToken.COLON;
        } else if (this.ch == ',') {
            this.token = JSONToken.COMMA;
        } else if (this.ch == 'n') {
            this.scanNull();
        } else if (this.ch == 'f') {
            this.scanFalse();
        } else if (this.ch == 't') {
            this.scanTrue();
        } else if (this.inNumberSet(this.ch)) {
            this.scanNumber();
        } else if (this.ch == '\"') {
            this.scanString();
        } else {
            throw new JSONLexerException(this.ch);
        }
        return this.token;
    }

    private char nextChar() throws JSONLexerException {
        if (this.cur >= this.len - 1) {
            this.ch = '\u0000';
            return '\u0000';
        }
        this.ch = this.jsonString.charAt(++this.cur);
        return this.ch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanString() throws JSONLexerException {
        this.nextChar();
        this.refreshBuffer();
        while (this.ch != '\"') {
            if (this.ch == '\u001a' || this.ch == '\u0000') {
                if (this.isEOF()) throw new JSONLexerException("unclosed string : " + this.readBuffer.toString());
                this.readBuffer.append(this.ch);
                continue;
            }
            if (this.ch == '\\') {
                this.nextChar();
                if (EscapeChars.containsKey(Character.valueOf(this.ch))) {
                    this.readBuffer.append(EscapeChars.get(Character.valueOf(this.ch)));
                } else if (this.ch == 'x') {
                    char x1 = this.nextChar();
                    char x2 = this.nextChar();
                    int x_val = digits[x1] * 16 + digits[x2];
                    char x_char = (char)x_val;
                    this.readBuffer.append(x_char);
                } else {
                    if (this.ch != 'u') throw new JSONLexerException("error string : " + this.readBuffer.toString());
                    char u1 = this.nextChar();
                    char u2 = this.nextChar();
                    char u3 = this.nextChar();
                    char u4 = this.nextChar();
                    int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                    this.readBuffer.append((char)val);
                }
            } else {
                this.readBuffer.append(this.ch);
            }
            this.nextChar();
        }
        this.token = JSONToken.STRING.addData(this.readBuffer.toString());
    }

    private void scanTrue() throws JSONLexerException {
        this.nextChar();
        if (this.ch != 'r') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 'u') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 'e') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (EndSigns.contains(Character.valueOf(this.ch))) {
            this.token = JSONToken.TRUE;
            --this.cur;
        } else {
            throw new JSONLexerException(this.ch);
        }
    }

    private void scanFalse() throws JSONLexerException {
        this.nextChar();
        if (this.ch != 'a') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 'l') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 's') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 'e') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (EndSigns.contains(Character.valueOf(this.ch))) {
            this.token = JSONToken.FALSE;
            --this.cur;
        } else {
            throw new JSONLexerException(this.ch);
        }
    }

    private void scanNull() throws JSONLexerException {
        this.nextChar();
        if (this.ch != 'u') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 'l') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (this.ch != 'l') {
            throw new JSONLexerException(this.ch);
        }
        this.nextChar();
        if (EndSigns.contains(Character.valueOf(this.ch))) {
            this.token = JSONToken.NULL;
            --this.cur;
        } else {
            throw new JSONLexerException(this.ch);
        }
    }

    private void scanNumber() throws JSONLexerException {
        this.refreshBuffer();
        if (this.ch == '+' || this.ch == '-') {
            this.readBuffer.append(this.ch);
            this.nextChar();
        }
        while (this.ch >= '0' && this.ch <= '9') {
            this.readBuffer.append(this.ch);
            this.nextChar();
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            this.readBuffer.append(this.ch);
            this.nextChar();
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                this.readBuffer.append(this.ch);
                this.nextChar();
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            this.readBuffer.append(this.ch);
            this.nextChar();
            if (this.ch == '+' || this.ch == '-') {
                this.readBuffer.append(this.ch);
                this.nextChar();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                this.readBuffer.append(this.ch);
                this.nextChar();
            }
            isDouble = true;
        }
        --this.cur;
        this.token = isDouble ? JSONToken.FLOAT.addData(this.readBuffer.toString()) : JSONToken.INT.addData(this.readBuffer.toString());
    }

    private void refreshBuffer(char c) {
        this.readBuffer = new StringBuilder();
        this.readBuffer.append(c);
    }

    private void refreshBuffer() {
        this.readBuffer = new StringBuilder();
    }

    private boolean inNumberSet(char c) {
        return c >= '0' & c <= '9' || c == '+' || c == '-';
    }

    private boolean isEOF() {
        return this.cur >= this.len || this.ch == '\u001a' || this.ch == '\u0000';
    }

    private boolean include(char[] range, char c) {
        boolean include = false;
        for (int i = 0; i < range.length; ++i) {
            if (range[i] != c) continue;
            include = true;
            break;
        }
        return include;
    }

    static {
        int i;
        FilterChar = new char[]{'\b', '\f', '\r', ' ', '\t'};
        EndSigns = new HashSet<Character>(){
            {
                this.add(Character.valueOf(' '));
                this.add(Character.valueOf(','));
                this.add(Character.valueOf('}'));
                this.add(Character.valueOf(']'));
                this.add(Character.valueOf('\n'));
                this.add(Character.valueOf('\r'));
                this.add(Character.valueOf('\t'));
                this.add(Character.valueOf('\u001a'));
                this.add(Character.valueOf('\f'));
                this.add(Character.valueOf('\b'));
            }
        };
        EscapeChars = new HashMap<Character, Character>(){
            {
                this.put(Character.valueOf('b'), Character.valueOf('\b'));
                this.put(Character.valueOf('t'), Character.valueOf('\t'));
                this.put(Character.valueOf('n'), Character.valueOf('\n'));
                this.put(Character.valueOf('v'), Character.valueOf('\b'));
                this.put(Character.valueOf('f'), Character.valueOf('\f'));
                this.put(Character.valueOf('F'), Character.valueOf('\f'));
                this.put(Character.valueOf('r'), Character.valueOf('\r'));
                this.put(Character.valueOf('\"'), Character.valueOf('\"'));
                this.put(Character.valueOf('\''), Character.valueOf('\''));
                this.put(Character.valueOf('/'), Character.valueOf('/'));
                this.put(Character.valueOf('\\'), Character.valueOf('\\'));
            }
        };
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONLexer.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONLexer.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONLexer.digits[i] = i - 65 + 10;
        }
    }
}

