/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson;

import com.thdjson.JSONLexer;
import com.thdjson.JSONToken;
import com.thdjson.entity.JSONArray;
import com.thdjson.entity.JSONElement;
import com.thdjson.entity.JSONFormat;
import com.thdjson.entity.JSONObject;
import com.thdjson.entity.JSONValue;
import com.thdjson.exception.JSONParserException;

public class JSONParser {
    private JSONLexer lexer;
    private JSONFormat jsonFormat;
    private JSONToken token;
    private boolean isCaseInsensitive;

    public JSONParser() {
        this.isCaseInsensitive = false;
    }

    public JSONParser(boolean caseInsensitive) {
        this.isCaseInsensitive = caseInsensitive;
    }

    public JSONFormat parseJson(String json) {
        if (json == null) {
            return null;
        }
        this.init(json);
        this.nextToken();
        this.jsonFormat = this.token == JSONToken.LBRACE ? this.parseObject() : (this.token == JSONToken.LBRACKET ? this.parseArray() : null);
        return this.jsonFormat;
    }

    public JSONArray parseArray(String json) {
        if (json == null) {
            return null;
        }
        JSONFormat jsonFormat = this.parseJson(json);
        assert (jsonFormat instanceof JSONArray);
        return (JSONArray)jsonFormat;
    }

    public JSONObject parseObject(String json) {
        if (json == null) {
            return null;
        }
        JSONFormat jsonFormat = this.parseJson(json);
        assert (jsonFormat instanceof JSONObject);
        return (JSONObject)jsonFormat;
    }

    private void init(String json) {
        this.lexer = new JSONLexer(json);
        this.token = null;
        this.jsonFormat = null;
    }

    private JSONToken nextToken() {
        this.token = this.lexer.nextToken();
        return this.token;
    }

    private JSONObject parseObject() {
        JSONObject object = new JSONObject();
        JSONValue value = null;
        boolean isFirst = true;
        while (true) {
            this.nextToken();
            if (this.token == JSONToken.RBRACE) {
                return object;
            }
            if (this.token == JSONToken.COMMA && !isFirst) {
                this.nextToken();
            } else if (this.token != JSONToken.COMMA && !isFirst) {
                throw new JSONParserException("expect \",\"");
            }
            if (this.token != JSONToken.STRING) {
                throw new JSONParserException("expect string type");
            }
            String key = this.token.getData();
            this.nextToken();
            if (this.token != JSONToken.COLON) {
                throw new JSONParserException("expect \":\"");
            }
            this.nextToken();
            value = this.token == JSONToken.LBRACE ? this.parseObject() : (this.token == JSONToken.LBRACKET ? this.parseArray() : new JSONElement(this.token));
            object.put(this.isCaseInsensitive ? key.toLowerCase() : key, value);
            if (!isFirst) continue;
            isFirst = false;
        }
    }

    private JSONArray parseArray() {
        JSONArray array = new JSONArray();
        boolean isFirst = true;
        while (true) {
            this.nextToken();
            if (this.token == JSONToken.RBRACKET) {
                return array;
            }
            if (this.token == JSONToken.COMMA && !isFirst) {
                this.nextToken();
            } else if (this.token != JSONToken.COMMA && !isFirst) {
                throw new JSONParserException("expect \",\"");
            }
            if (this.token == JSONToken.LBRACKET) {
                array.addValue(this.parseArray());
            } else if (this.token == JSONToken.LBRACE) {
                array.addValue(this.parseObject());
            } else {
                array.addValue(new JSONElement(this.token));
            }
            if (!isFirst) continue;
            isFirst = false;
        }
    }
}

