/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson;

import com.thdjson.JSONSerializerFeature;
import com.thdjson.entity.JSONArray;
import com.thdjson.entity.JSONElement;
import com.thdjson.entity.JSONObject;
import com.thdjson.entity.JSONValue;
import com.thdjson.entity.JSONValueType;
import com.thdjson.exception.JSONSerializerException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class JSONSerializer {
    private int features;

    public JSONSerializer() {
        this.features = 0;
    }

    public JSONSerializer(JSONSerializerFeature ... features) {
        for (JSONSerializerFeature feature : features) {
            this.features |= feature.getMask();
        }
    }

    public String serializeObjectToString(Object obj) {
        return this.serializeObject(obj).toString();
    }

    public JSONObject serializeObject(Object obj) {
        if (obj == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        JSONValue value = null;
        Field[] fields = null;
        try {
            for (Class<?> cla = obj.getClass(); cla != Object.class; cla = cla.getSuperclass()) {
                for (Field field : fields = cla.getDeclaredFields()) {
                    if (!this.inFeatures(JSONSerializerFeature.AllowNonPublic) && (field.getModifiers() & 1) == 0) continue;
                    field.setAccessible(true);
                    String name = this.inFeatures(JSONSerializerFeature.CaseInsensitive) ? field.getName().toLowerCase() : field.getName();
                    value = this.serializeValue(field.get(obj), field.getType());
                    jsonObject.put(name, value);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new JSONSerializerException(e.getMessage());
        }
        return jsonObject;
    }

    public String serializeMapToString(Map map) {
        return this.serializeMap(map).toString();
    }

    public JSONObject serializeMap(Map map) {
        if (map == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            for (Object key : map.keySet()) {
                Object val = map.get(key);
                JSONValue jsonValue = this.serializeValue(val, val.getClass());
                String k = this.inFeatures(JSONSerializerFeature.CaseInsensitive) ? key.toString().toLowerCase() : key.toString();
                jsonObject.put(k, jsonValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new JSONSerializerException(e.getMessage());
        }
        return jsonObject;
    }

    public String serializeArrayToString(Object array) {
        return this.serializeArray(array).toString();
    }

    public JSONArray serializeArray(Object array) {
        if (array == null) {
            return null;
        }
        if (!array.getClass().isArray()) {
            throw new JSONSerializerException("wrong type: " + array.getClass());
        }
        JSONArray jsonArray = new JSONArray();
        int len = Array.getLength(array);
        try {
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(array, i);
                jsonArray.addValue(this.serializeValue(o, array.getClass().getComponentType()));
            }
        }
        catch (IllegalAccessException e) {
            throw new JSONSerializerException(e.getMessage());
        }
        return jsonArray;
    }

    public String serializeListToString(List list) {
        return this.serializeList(list).toString();
    }

    public JSONArray serializeList(List list) {
        if (list == null) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        try {
            for (Object obj : list) {
                jsonArray.addValue(this.serializeValue(obj, obj.getClass()));
            }
        }
        catch (IllegalAccessException e) {
            throw new JSONSerializerException(e.getMessage());
        }
        return jsonArray;
    }

    private <T> JSONValue serializeValue(T obj, Class<?> clazz) throws IllegalAccessException {
        JSONValue JSONValue2 = null;
        JSONValue2 = obj != null ? (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) ? (clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class ? new JSONElement(obj.toString(), JSONValueType.FLOAT) : new JSONElement(obj.toString(), JSONValueType.INT)) : (clazz == Boolean.TYPE || clazz == Boolean.class ? new JSONElement(obj.toString(), JSONValueType.BOOL) : (clazz == Character.TYPE || clazz == Character.class || clazz == String.class ? new JSONElement(obj.toString(), JSONValueType.STRING) : (clazz.isArray() ? this.serializeArray(obj) : this.serializeObject(obj))))) : new JSONElement(null, JSONValueType.NULL);
        return JSONValue2;
    }

    private boolean inFeatures(JSONSerializerFeature feature) {
        return (this.features & feature.getMask()) == feature.getMask();
    }
}

