/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson.entity;

import com.thdjson.entity.JSONElement;
import com.thdjson.entity.JSONFormat;
import com.thdjson.entity.JSONObject;
import com.thdjson.entity.JSONValue;
import com.thdjson.entity.JSONValueType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class JSONArray
extends JSONFormat
implements List<JSONValue>,
Cloneable,
RandomAccess,
Serializable {
    private JSONValueType type;
    private ArrayList<JSONValue> list;

    public JSONArray() {
        this.list = new ArrayList();
        this.type = JSONValueType.ARRAY;
    }

    public JSONArray(ArrayList<JSONValue> list) {
        this.list = list;
        this.type = JSONValueType.ARRAY;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<JSONValue> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(JSONValue e) {
        return this.list.add(e);
    }

    public JSONArray fluentAdd(JSONValue e) {
        this.list.add(e);
        return this;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    public JSONArray fluentRemove(Object o) {
        this.list.remove(o);
        return this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends JSONValue> c) {
        return this.list.addAll(c);
    }

    public JSONArray fluentAddAll(Collection<? extends JSONValue> c) {
        this.list.addAll(c);
        return this;
    }

    @Override
    public boolean addAll(int index, Collection<? extends JSONValue> c) {
        return this.list.addAll(index, c);
    }

    public JSONArray fluentAddAll(int index, Collection<? extends JSONValue> c) {
        this.list.addAll(index, c);
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    public JSONArray fluentRemoveAll(Collection<?> c) {
        this.list.removeAll(c);
        return this;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    public JSONArray fluentRetainAll(Collection<?> c) {
        this.list.retainAll(c);
        return this;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public JSONArray fluentClear() {
        this.list.clear();
        return this;
    }

    @Override
    public JSONValue set(int index, JSONValue element) {
        if (index == -1) {
            this.list.add(element);
            return null;
        }
        if (this.list.size() <= index) {
            for (int i = this.list.size(); i < index; ++i) {
                this.list.add(null);
            }
            this.list.add(element);
            return null;
        }
        return this.list.set(index, element);
    }

    public JSONArray fluentSet(int index, JSONValue element) {
        this.set(index, element);
        return this;
    }

    @Override
    public void add(int index, JSONValue element) {
        this.list.add(index, element);
    }

    public JSONArray fluentAdd(int index, JSONValue element) {
        this.list.add(index, element);
        return this;
    }

    @Override
    public JSONValue remove(int index) {
        return this.list.remove(index);
    }

    public JSONArray fluentRemove(int index) {
        this.list.remove(index);
        return this;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<JSONValue> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<JSONValue> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<JSONValue> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public void addValue(JSONValue value) {
        this.list.add(value);
    }

    @Override
    public JSONValueType getType() {
        return this.type;
    }

    public Byte getByte(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getByte();
        }
        return null;
    }

    public byte getByteValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getByteValue();
        }
        return 0;
    }

    public Short getShort(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getShort();
        }
        return null;
    }

    public short getShortValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getShortValue();
        }
        return 0;
    }

    public Integer getInt(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getInt();
        }
        return null;
    }

    public int getIntValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getIntValue();
        }
        return 0;
    }

    public Long getLong(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getLong();
        }
        return null;
    }

    public long getLongValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getLongValue();
        }
        return 0L;
    }

    public Boolean getBoolean(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBoolean();
        }
        return null;
    }

    public boolean getBooleanValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBooleanValue();
        }
        return false;
    }

    public Float getFloat(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getFloat();
        }
        return null;
    }

    public float getFloatValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getFloatValue();
        }
        return 0.0f;
    }

    public Double getDouble(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getDouble();
        }
        return null;
    }

    public double getDoubleValue(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getDoubleValue();
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBigDecimal();
        }
        return null;
    }

    public BigInteger getBigInteger(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBigInteger();
        }
        return null;
    }

    public String getString(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getString();
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public JSONArray getJSONArray(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return null;
    }

    public JSONObject getJSONObject(int index) {
        JSONValue value = this.list.get(index);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return null;
    }

    @Override
    public JSONValue get(int index) {
        return this.list.get(index);
    }

    @Override
    public String toString() {
        return this.format(1);
    }

    @Override
    String format(int layer) {
        StringBuilder str = new StringBuilder();
        str.append("[\n");
        for (JSONValue value : this.list) {
            str.append(this.withSpace(layer));
            str.append(this.matchFormat(value, layer + 1));
            str.append(",\n");
        }
        int lastIndex = str.length() - 2;
        if (str.charAt(lastIndex) == ',') {
            str.deleteCharAt(lastIndex);
        }
        str.append(this.withSpace(layer - 1));
        str.append("]");
        return str.toString();
    }
}

