/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson.entity;

import com.thdjson.JSONToken;
import com.thdjson.entity.JSONValue;
import com.thdjson.entity.JSONValueType;
import com.thdjson.exception.JSONParserException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JSONElement
implements JSONValue {
    private JSONValueType type;
    private String value;

    public JSONElement(JSONToken jsonToken) throws JSONParserException {
        switch (jsonToken) {
            case STRING: {
                this.type = JSONValueType.STRING;
                break;
            }
            case NULL: {
                this.type = JSONValueType.NULL;
                break;
            }
            case TRUE: 
            case FALSE: {
                this.type = JSONValueType.BOOL;
                break;
            }
            case FLOAT: {
                this.type = JSONValueType.FLOAT;
                break;
            }
            case INT: {
                this.type = JSONValueType.INT;
                break;
            }
            default: {
                throw new JSONParserException();
            }
        }
        this.value = jsonToken.getData();
    }

    public JSONElement(String value, JSONValueType type) {
        this.type = type;
        this.value = value;
    }

    public Byte getByte() {
        if (this.type == JSONValueType.FLOAT) {
            return Byte.parseByte(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type != JSONValueType.INT || this.value == null) {
            return null;
        }
        return Byte.parseByte(this.value);
    }

    public byte getByteValue() {
        if (this.type == JSONValueType.FLOAT) {
            return Byte.parseByte(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type != JSONValueType.INT) {
            return Byte.parseByte(this.value);
        }
        return 0;
    }

    public Short getShort() {
        if (this.type == JSONValueType.FLOAT) {
            return Short.parseShort(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type != JSONValueType.INT) {
            return null;
        }
        return Short.parseShort(this.value);
    }

    public short getShortValue() {
        if (this.type == JSONValueType.FLOAT) {
            return Short.parseShort(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type == JSONValueType.INT) {
            return Short.parseShort(this.value);
        }
        return 0;
    }

    public Integer getInt() {
        if (this.type == JSONValueType.FLOAT) {
            return Integer.parseInt(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type != JSONValueType.INT) {
            return null;
        }
        return Integer.parseInt(this.value);
    }

    public int getIntValue() {
        if (this.type == JSONValueType.FLOAT) {
            return Integer.parseInt(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type == JSONValueType.INT) {
            return Integer.parseInt(this.value);
        }
        return 0;
    }

    public Long getLong() {
        if (this.type == JSONValueType.FLOAT) {
            return Long.parseLong(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type != JSONValueType.INT) {
            return null;
        }
        return Long.parseLong(this.value);
    }

    public long getLongValue() {
        if (this.type == JSONValueType.FLOAT) {
            return Long.parseLong(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type == JSONValueType.INT) {
            return Long.parseLong(this.value);
        }
        return 0L;
    }

    public Boolean getBoolean() {
        if (this.type != JSONValueType.BOOL) {
            return null;
        }
        return Boolean.parseBoolean(this.value);
    }

    public boolean getBooleanValue() {
        if (this.type == JSONValueType.BOOL) {
            return Boolean.parseBoolean(this.value);
        }
        return false;
    }

    public Float getFloat() {
        if (this.type != JSONValueType.FLOAT && this.type != JSONValueType.INT) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(this.value));
    }

    public float getFloatValue() {
        if (this.type == JSONValueType.FLOAT || this.type == JSONValueType.INT) {
            return Float.parseFloat(this.value);
        }
        return 0.0f;
    }

    public Double getDouble() {
        if (this.type != JSONValueType.FLOAT && this.type != JSONValueType.INT) {
            return null;
        }
        return Double.parseDouble(this.value);
    }

    public double getDoubleValue() {
        if (this.type == JSONValueType.FLOAT || this.type == JSONValueType.INT) {
            return Double.parseDouble(this.value);
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal() {
        if (this.type != JSONValueType.FLOAT && this.type != JSONValueType.INT) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    public BigInteger getBigInteger() {
        if (this.type == JSONValueType.FLOAT) {
            return new BigInteger(this.value.substring(0, this.value.indexOf(46)));
        }
        if (this.type != JSONValueType.INT) {
            return null;
        }
        return new BigInteger(this.value);
    }

    public String getString() {
        if (this.type == JSONValueType.NULL) {
            return null;
        }
        return this.value;
    }

    @Override
    public String toString() {
        if (this.type == JSONValueType.STRING) {
            return "\"" + this.value + "\"";
        }
        return this.value;
    }

    @Override
    public JSONValueType getType() {
        return this.type;
    }
}

