/*
 * Decompiled with CFR 0.152.
 */
package com.thdjson.entity;

import com.thdjson.entity.JSONArray;
import com.thdjson.entity.JSONElement;
import com.thdjson.entity.JSONFormat;
import com.thdjson.entity.JSONValue;
import com.thdjson.entity.JSONValueType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSONFormat
implements Map<String, JSONValue>,
Cloneable,
Serializable {
    private final JSONValueType type = JSONValueType.OBJECT;
    private LinkedHashMap<String, JSONValue> map;

    public JSONObject() {
        this.map = new LinkedHashMap();
    }

    public JSONObject(LinkedHashMap<String, JSONValue> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public JSONValue get(Object key) {
        return this.map.get(key);
    }

    @Override
    public JSONValueType getType() {
        return this.type;
    }

    @Override
    public JSONValue put(String key, JSONValue value) {
        return this.map.put(key, value);
    }

    public JSONObject fluentPut(String key, JSONValue value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends JSONValue> m) {
        this.map.putAll(m);
    }

    public JSONObject fluentPutAll(Map<? extends String, ? extends JSONValue> m) {
        this.map.putAll(m);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public JSONValue remove(Object key) {
        return (JSONValue)this.map.remove(key);
    }

    public JSONObject fluentRemove(String key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public Set<Map.Entry<String, JSONValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<JSONValue> values() {
        return this.map.values();
    }

    public Byte getByte(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getByte();
        }
        return null;
    }

    public byte getByteValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getByteValue();
        }
        return 0;
    }

    public Short getShort(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getShort();
        }
        return null;
    }

    public short getShortValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getShortValue();
        }
        return 0;
    }

    public Integer getInt(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getInt();
        }
        return null;
    }

    public int getIntValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getIntValue();
        }
        return 0;
    }

    public Long getLong(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getLong();
        }
        return null;
    }

    public long getLongValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getLongValue();
        }
        return 0L;
    }

    public Boolean getBoolean(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBoolean();
        }
        return null;
    }

    public boolean getBooleanValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBooleanValue();
        }
        return false;
    }

    public Float getFloat(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getFloat();
        }
        return null;
    }

    public float getFloatValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getFloatValue();
        }
        return 0.0f;
    }

    public Double getDouble(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getDouble();
        }
        return null;
    }

    public double getDoubleValue(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getDoubleValue();
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBigDecimal();
        }
        return null;
    }

    public BigInteger getBigInteger(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getBigInteger();
        }
        return null;
    }

    public String getString(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONElement) {
            return ((JSONElement)value).getString();
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public JSONArray getJSONArray(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        JSONValue value = this.map.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return null;
    }

    public Object clone() {
        return new JSONObject(this.map);
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.format(1);
    }

    @Override
    String format(int layer) {
        StringBuilder str = new StringBuilder();
        str.append("{\n");
        for (Map.Entry<String, JSONValue> entry : this.map.entrySet()) {
            str.append(this.withSpace(layer));
            str.append("\"" + entry.getKey() + "\"");
            str.append(": ");
            str.append(this.matchFormat(entry.getValue(), layer + 1));
            str.append(",\n");
        }
        int lastIndex = str.length() - 2;
        if (str.charAt(lastIndex) == ',') {
            str.deleteCharAt(lastIndex);
        }
        str.append(this.withSpace(layer - 1));
        str.append("}");
        return str.toString();
    }
}

