/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension;

import java.io.File;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SerenityReportExtension
implements AfterAllCallback {
    public void afterAll(@NotNull ExtensionContext context) throws Exception {
        BaseStepListener baseStepListener = StepEventBus.getEventBus().getBaseStepListener();
        this.generateReports(baseStepListener);
    }

    protected void generateReports(BaseStepListener baseStepListener) {
        this.generateReportsFor(baseStepListener.getTestOutcomes());
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        ReportService reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        reportService.generateReportsFor(testOutcomeResults);
        reportService.generateConfigurationsReport();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }

    public File getOutputDirectory() {
        return ConfiguredEnvironment.getConfiguration().getOutputDirectory();
    }
}

