/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension.page;

import java.lang.reflect.Field;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.annotations.ClearCookiesPolicy;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.InvalidManagedWebDriverFieldException;
import net.thucydides.core.annotations.Managed;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;

@Deprecated
public class PatchedManagedWebDriverAnnotatedField {
    private static final String NO_ANNOTATED_FIELD_ERROR = "No WebDriver field annotated with @Managed was found in the test case.";
    private final Field field;

    static Optional<PatchedManagedWebDriverAnnotatedField> findOptionalAnnotatedField(Class<?> testClass) {
        try {
            return PatchedManagedWebDriverAnnotatedField.fieldsIn(testClass).stream().filter(PatchedManagedWebDriverAnnotatedField::isFieldAnnotated).map(PatchedManagedWebDriverAnnotatedField::new).findFirst();
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    public static PatchedManagedWebDriverAnnotatedField findFirstAnnotatedField(Class<?> testClass) {
        Optional<PatchedManagedWebDriverAnnotatedField> optionalField = PatchedManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass);
        if (optionalField.isPresent()) {
            return optionalField.get();
        }
        throw new InvalidManagedWebDriverFieldException(NO_ANNOTATED_FIELD_ERROR);
    }

    public static List<PatchedManagedWebDriverAnnotatedField> findAnnotatedFields(Class<?> testClass) {
        return Fields.of(testClass).allFields().stream().filter(PatchedManagedWebDriverAnnotatedField::isFieldAnnotated).map(PatchedManagedWebDriverAnnotatedField::new).collect(Collectors.toList());
    }

    public static boolean hasManagedWebdriverField(Class<?> testClass) {
        try {
            return PatchedManagedWebDriverAnnotatedField.fieldsIn(testClass).stream().anyMatch(PatchedManagedWebDriverAnnotatedField::isFieldAnnotated);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private static boolean isFieldAnnotated(Field field) {
        return PatchedManagedWebDriverAnnotatedField.fieldIsAnnotatedCorrectly(field) && PatchedManagedWebDriverAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return WebDriverFacade.class.isAssignableFrom(field.getType()) || field.getType().isAssignableFrom(WebDriver.class);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Managed.class) != null;
    }

    private PatchedManagedWebDriverAnnotatedField(Field field) {
        this.field = field;
    }

    public void setValue(Object testCase, WebDriver manageDriver) {
        try {
            this.field.setAccessible(true);
            this.field.set(testCase, manageDriver);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedWebDriverFieldException("Could not access or set web driver field: " + this.field + " - is this field public?", (Throwable)e);
        }
    }

    public WebDriver getValue(Object testCase) {
        try {
            this.field.setAccessible(true);
            return (WebDriver)this.field.get(testCase);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedWebDriverFieldException("Could not access or set web driver field: " + this.field + " - is this field public?", (Throwable)e);
        }
    }

    private static Set<Field> fieldsIn(Class clazz) {
        return Fields.of((Class)clazz).allFields();
    }

    public boolean isUniqueSession() {
        return this.field.getAnnotation(Managed.class).uniqueSession();
    }

    ClearCookiesPolicy getClearCookiesPolicy() {
        return this.field.getAnnotation(Managed.class).clearCookies();
    }

    public String getDriver() {
        return this.field.getAnnotation(Managed.class).driver();
    }

    public String getOptions() {
        return this.field.getAnnotation(Managed.class).options();
    }

    public String getName() {
        return this.field.getName();
    }
}

