/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.jcs3.slf4j;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.jcs3.log.Log;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class Slf4jAdapter
implements Log {
    private final Logger logger;

    public Slf4jAdapter(Logger log) {
        this.logger = log;
    }

    public void debug(String string) {
        this.logger.debug(string);
    }

    public void debug(Object o) {
        this.logger.debug(o.toString());
    }

    public void debug(String string, Object ... os) {
        this.logger.debug(string, os);
    }

    public void debug(String string, Supplier<?> ... splrs) {
        this.log(Level.DEBUG, string, splrs);
    }

    public void debug(String string, Throwable thrwbl) {
        this.logger.debug(string, thrwbl);
    }

    public void error(String string) {
        this.logger.error(string);
    }

    public void error(Object o) {
        this.logger.error(o.toString());
    }

    public void error(String string, Object ... os) {
        this.logger.error(string, os);
    }

    public void error(String string, Supplier<?> ... splrs) {
        this.log(Level.ERROR, string, splrs);
    }

    public void error(String string, Throwable thrwbl) {
        this.logger.error(string, thrwbl);
    }

    public void fatal(String string) {
        this.logger.error(string);
    }

    public void fatal(Object o) {
        this.logger.error(o.toString());
    }

    public void fatal(String string, Object ... os) {
        this.logger.error(string, os);
    }

    public void fatal(String string, Supplier<?> ... splrs) {
        this.log(Level.ERROR, string, splrs);
    }

    public void fatal(String string, Throwable thrwbl) {
        this.logger.error(string, thrwbl);
    }

    public String getName() {
        return this.logger.getName();
    }

    public void info(String string) {
        this.logger.info(string);
    }

    public void info(Object o) {
        this.logger.info(o.toString());
    }

    public void info(String string, Object ... os) {
        this.logger.info(string, os);
    }

    public void info(String string, Supplier<?> ... splrs) {
        this.log(Level.INFO, string, splrs);
    }

    public void info(String string, Throwable thrwbl) {
        this.logger.info(string, thrwbl);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void trace(String string) {
        this.logger.trace(string);
    }

    public void trace(Object o) {
        this.logger.trace(o.toString());
    }

    public void trace(String string, Object ... os) {
        this.logger.trace(string, os);
    }

    public void trace(String string, Supplier<?> ... splrs) {
        this.log(Level.TRACE, string, splrs);
    }

    public void trace(String string, Throwable thrwbl) {
        this.logger.trace(string, thrwbl);
    }

    public void warn(String string) {
        this.logger.warn(string);
    }

    public void warn(Object o) {
        this.logger.warn(o.toString());
    }

    public void warn(String string, Object ... os) {
        this.logger.warn(string, os);
    }

    public void warn(String string, Supplier<?> ... splrs) {
        this.log(Level.WARN, string, splrs);
    }

    public void warn(String string, Throwable thrwbl) {
        this.logger.warn(string, thrwbl);
    }

    private void log(Level level, String string, Supplier<?>[] splrs) {
        if (this.isEnabled(level)) {
            Object[] o = null;
            if (splrs != null) {
                o = Arrays.stream(splrs).map(s -> s.get()).toArray();
            }
            switch (level) {
                case ERROR: {
                    this.logger.error(string, o);
                    break;
                }
                case WARN: {
                    this.logger.warn(string, o);
                    break;
                }
                case INFO: {
                    this.logger.info(string, o);
                    break;
                }
                case TRACE: {
                    this.logger.trace(string, o);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(string, o);
                }
            }
        }
    }

    private boolean isEnabled(Level level) {
        return Level.DEBUG == level && this.logger.isDebugEnabled() || Level.INFO == level && this.logger.isInfoEnabled() || Level.TRACE == level && this.logger.isTraceEnabled() || Level.WARN == level && this.logger.isWarnEnabled() || Level.ERROR == level && this.logger.isErrorEnabled();
    }
}

