/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2Data;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source", "type", "cvssData", "baseSeverity", "exploitabilityScore", "impactScore", "acInsufInfo", "obtainAllPrivilege", "obtainUserPrivilege", "obtainOtherPrivilege", "userInteractionRequired"})
public class CvssV2
implements Serializable {
    private static final long serialVersionUID = 7595837336051753457L;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="cvssData")
    private CvssV2Data cvssData;
    @JsonProperty(value="baseSeverity")
    private String baseSeverity;
    @JsonProperty(value="exploitabilityScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double exploitabilityScore;
    @JsonProperty(value="impactScore")
    @JsonPropertyDescription(value="CVSS subscore.")
    private Double impactScore;
    @JsonProperty(value="acInsufInfo")
    private Boolean acInsufInfo;
    @JsonProperty(value="obtainAllPrivilege")
    private Boolean obtainAllPrivilege;
    @JsonProperty(value="obtainUserPrivilege")
    private Boolean obtainUserPrivilege;
    @JsonProperty(value="obtainOtherPrivilege")
    private Boolean obtainOtherPrivilege;
    @JsonProperty(value="userInteractionRequired")
    private Boolean userInteractionRequired;

    public CvssV2() {
    }

    public CvssV2(String source, Type type, CvssV2Data cvssData, String baseSeverity, Double exploitabilityScore, Double impactScore, Boolean acInsufInfo, Boolean obtainAllPrivilege, Boolean obtainUserPrivilege, Boolean obtainOtherPrivilege, Boolean userInteractionRequired) {
        this.source = source;
        this.type = type;
        this.cvssData = cvssData;
        this.baseSeverity = baseSeverity;
        this.exploitabilityScore = exploitabilityScore;
        this.impactScore = impactScore;
        this.acInsufInfo = acInsufInfo;
        this.obtainAllPrivilege = obtainAllPrivilege;
        this.obtainUserPrivilege = obtainUserPrivilege;
        this.obtainOtherPrivilege = obtainOtherPrivilege;
        this.userInteractionRequired = userInteractionRequired;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="cvssData")
    public CvssV2Data getCvssData() {
        return this.cvssData;
    }

    @JsonProperty(value="baseSeverity")
    public String getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitabilityScore")
    public Double getExploitabilityScore() {
        return this.exploitabilityScore;
    }

    @JsonProperty(value="impactScore")
    public Double getImpactScore() {
        return this.impactScore;
    }

    @JsonProperty(value="acInsufInfo")
    public Boolean getAcInsufInfo() {
        return this.acInsufInfo;
    }

    @JsonProperty(value="obtainAllPrivilege")
    public Boolean getObtainAllPrivilege() {
        return this.obtainAllPrivilege;
    }

    @JsonProperty(value="obtainUserPrivilege")
    public Boolean getObtainUserPrivilege() {
        return this.obtainUserPrivilege;
    }

    @JsonProperty(value="obtainOtherPrivilege")
    public Boolean getObtainOtherPrivilege() {
        return this.obtainOtherPrivilege;
    }

    @JsonProperty(value="userInteractionRequired")
    public Boolean getUserInteractionRequired() {
        return this.userInteractionRequired;
    }

    public String toString() {
        if (this.cvssData.getVectorString() != null) {
            return this.cvssData.getVectorString();
        }
        return String.format("/AV:%s/AC:%s/Au:%s/C:%s/I:%s/A:%s", this.cvssData.getAccessVector() == null ? "" : this.cvssData.getAccessVector().value().substring(0, 1), this.cvssData.getAccessComplexity() == null ? "" : this.cvssData.getAccessComplexity().value().substring(0, 1), this.cvssData.getAuthentication() == null ? "" : this.cvssData.getAuthentication().value().substring(0, 1), this.cvssData.getConfidentialityImpact() == null ? "" : this.cvssData.getConfidentialityImpact().value().substring(0, 1), this.cvssData.getIntegrityImpact() == null ? "" : this.cvssData.getIntegrityImpact().value().substring(0, 1), this.cvssData.getAvailabilityImpact() == null ? "" : this.cvssData.getAvailabilityImpact().value().substring(0, 1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV2 cvssV2 = (CvssV2)o;
        return Objects.equals(this.source, cvssV2.source) && this.type == cvssV2.type && Objects.equals(this.cvssData, cvssV2.cvssData) && Objects.equals(this.baseSeverity, cvssV2.baseSeverity) && Objects.equals(this.exploitabilityScore, cvssV2.exploitabilityScore) && Objects.equals(this.impactScore, cvssV2.impactScore) && Objects.equals(this.acInsufInfo, cvssV2.acInsufInfo) && Objects.equals(this.obtainAllPrivilege, cvssV2.obtainAllPrivilege) && Objects.equals(this.obtainUserPrivilege, cvssV2.obtainUserPrivilege) && Objects.equals(this.obtainOtherPrivilege, cvssV2.obtainOtherPrivilege) && Objects.equals(this.userInteractionRequired, cvssV2.userInteractionRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.type, this.cvssData, this.baseSeverity, this.exploitabilityScore, this.impactScore, this.acInsufInfo, this.obtainAllPrivilege, this.obtainUserPrivilege, this.obtainOtherPrivilege, this.userInteractionRequired});
    }

    public static enum Type {
        PRIMARY("Primary"),
        SECONDARY("Secondary");

        private static final Map<String, Type> CONSTANTS;
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

