/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.opentelemetry;

import java.io.FileInputStream;
import java.util.Properties;

public class EnvironmentConfiguration {
    public static final String HONEYCOMB_API_KEY = "HONEYCOMB_API_KEY";
    public static final String HONEYCOMB_TRACES_APIKEY = "HONEYCOMB_TRACES_APIKEY";
    public static final String HONEYCOMB_METRICS_APIKEY = "HONEYCOMB_METRICS_APIKEY";
    public static final String HONEYCOMB_API_ENDPOINT = "HONEYCOMB_API_ENDPOINT";
    public static final String HONEYCOMB_TRACES_ENDPOINT = "HONEYCOMB_TRACES_ENDPOINT";
    public static final String HONEYCOMB_METRICS_ENDPOINT = "HONEYCOMB_METRICS_ENDPOINT";
    public static final String HONEYCOMB_DATASET = "HONEYCOMB_DATASET";
    public static final String HONEYCOMB_TRACES_DATASET = "HONEYCOMB_TRACES_DATASET";
    public static final String HONEYCOMB_METRICS_DATASET = "HONEYCOMB_METRICS_DATASET";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String SAMPLE_RATE = "SAMPLE_RATE";
    public static final String HONEYCOMB_CONFIGURATION_FILE = "HONEYCOMB_CONFIG_FILE";
    public static final String DEFAULT_HONEYCOMB_ENDPOINT = "https://api.honeycomb.io:443";
    public static final String SERVICE_NAME_FIELD = "service.name";
    public static final String HONEYCOMB_TEAM_HEADER = "X-Honeycomb-Team";
    public static final String HONEYCOMB_DATASET_HEADER = "X-Honeycomb-Dataset";
    private static final Properties properties = EnvironmentConfiguration.loadPropertiesFromConfigFile();
    private static final String OTEL_AGENT_CONFIG_FILE = "otel.javaagent.configuration-file";

    public static String getHoneycombApiKey() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_API_KEY, null);
    }

    public static String getHoneycombTracesApiKey() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_TRACES_APIKEY, EnvironmentConfiguration.getHoneycombApiKey());
    }

    public static String getHoneycombMetricsApiKey() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_METRICS_APIKEY, EnvironmentConfiguration.getHoneycombApiKey());
    }

    public static String getHoneycombApiEndpoint() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_API_ENDPOINT, DEFAULT_HONEYCOMB_ENDPOINT);
    }

    public static String getHoneycombTracesApiEndpoint() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_TRACES_ENDPOINT, EnvironmentConfiguration.getHoneycombApiEndpoint());
    }

    public static String getHoneycombMetricsApiEndpoint() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_METRICS_ENDPOINT, EnvironmentConfiguration.getHoneycombApiEndpoint());
    }

    public static String getHoneycombDataset() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_DATASET, null);
    }

    public static String getHoneycombTracesDataset() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_TRACES_DATASET, EnvironmentConfiguration.getHoneycombDataset());
    }

    public static String getHoneycombMetricsDataset() {
        return EnvironmentConfiguration.readVariable(HONEYCOMB_METRICS_DATASET, null);
    }

    public static String getServiceName() {
        return EnvironmentConfiguration.readVariable(SERVICE_NAME, null);
    }

    public static int getSampleRate() throws NumberFormatException {
        String sampleRate = EnvironmentConfiguration.readVariable(SAMPLE_RATE, "1");
        return Integer.parseInt(sampleRate);
    }

    public static String getErrorMessage(String humanKey, String key) {
        return String.format("Missing %s. Specify either %s environment variable or %s system property.", humanKey, key, EnvironmentConfiguration.getPropertyName(key));
    }

    public static boolean isPresent(String value) {
        return value != null && !value.isEmpty();
    }

    public static boolean isLegacyKey(String key) {
        return key.length() == 32;
    }

    private static String readVariable(String key, String fallback) {
        String propertyName = EnvironmentConfiguration.getPropertyName(key);
        String value = System.getProperty(propertyName);
        if (EnvironmentConfiguration.isPresent(value)) {
            return value;
        }
        value = System.getenv(key);
        if (EnvironmentConfiguration.isPresent(value)) {
            return value;
        }
        value = properties.getProperty(propertyName);
        if (EnvironmentConfiguration.isPresent(value)) {
            return value;
        }
        return fallback;
    }

    private static String getPropertyName(String envKey) {
        return envKey.toLowerCase().replace('_', '.');
    }

    public static void enableOTLPTraces() {
        String endpoint = EnvironmentConfiguration.getHoneycombTracesApiEndpoint();
        String apiKey = EnvironmentConfiguration.getHoneycombTracesApiKey();
        String dataset = EnvironmentConfiguration.getHoneycombTracesDataset();
        String serviceName = EnvironmentConfiguration.getServiceName();
        if (!EnvironmentConfiguration.isPresent(serviceName)) {
            System.out.printf("WARN: %s%n", EnvironmentConfiguration.getErrorMessage("service name", SERVICE_NAME) + " If left unset, this will show up in Honeycomb as unknown_service:java");
        }
        if (EnvironmentConfiguration.isPresent(apiKey) && !EnvironmentConfiguration.isLegacyKey(apiKey) && EnvironmentConfiguration.isPresent(dataset)) {
            if (EnvironmentConfiguration.isPresent(serviceName)) {
                System.out.printf("WARN: Dataset is ignored in favor of service name. Data will be sent to service name: %s%n", serviceName);
            } else {
                System.out.printf("WARN: Dataset is ignored in favor of service name.%n", new Object[0]);
            }
        }
        System.setProperty("otel.exporter.otlp.traces.endpoint", endpoint);
        if (EnvironmentConfiguration.isPresent(apiKey)) {
            String header = String.format("%s=%s", HONEYCOMB_TEAM_HEADER, apiKey);
            if (EnvironmentConfiguration.isLegacyKey(apiKey)) {
                if (EnvironmentConfiguration.isPresent(dataset)) {
                    header = header + String.format(",%s=%s", HONEYCOMB_DATASET_HEADER, dataset);
                } else {
                    System.out.printf("WARN: %s%n", EnvironmentConfiguration.getErrorMessage("dataset", HONEYCOMB_DATASET));
                }
            }
            System.setProperty("otel.exporter.otlp.traces.headers", header);
        } else {
            System.out.printf("WARN: %s%n", EnvironmentConfiguration.getErrorMessage("API key", HONEYCOMB_API_KEY));
        }
    }

    public static void enableOTLPMetrics() {
        String endpoint = EnvironmentConfiguration.getHoneycombMetricsApiEndpoint();
        String apiKey = EnvironmentConfiguration.getHoneycombMetricsApiKey();
        String dataset = EnvironmentConfiguration.getHoneycombMetricsDataset();
        if (EnvironmentConfiguration.isPresent(dataset)) {
            System.setProperty("otel.metrics.exporter", "otlp");
            System.setProperty("otel.exporter.otlp.metrics.endpoint", endpoint);
            System.setProperty("otel.exporter.otlp.metrics.headers", String.format("%s=%s,%s=%s", HONEYCOMB_TEAM_HEADER, apiKey, HONEYCOMB_DATASET_HEADER, dataset));
        }
    }

    static Properties loadPropertiesFromConfigFile() {
        String path = System.getProperty(EnvironmentConfiguration.getPropertyName(HONEYCOMB_CONFIGURATION_FILE));
        if (!EnvironmentConfiguration.isPresent(path)) {
            path = System.getenv(HONEYCOMB_CONFIGURATION_FILE);
        }
        Properties properties = new Properties();
        if (EnvironmentConfiguration.isPresent(path)) {
            try (FileInputStream stream = new FileInputStream(path);){
                properties.load(stream);
                if (!EnvironmentConfiguration.isPresent(System.getProperty(OTEL_AGENT_CONFIG_FILE))) {
                    System.setProperty(OTEL_AGENT_CONFIG_FILE, path);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to load config file with path: " + path);
                System.out.print(e);
            }
        }
        return properties;
    }
}

